/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import javax.management.Attribute;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import org.jboss.mx.capability.DispatcherFactory;
import org.jboss.mx.interceptor.Interceptor;
import org.jboss.mx.interceptor.Invocation;
import org.jboss.mx.interceptor.InvocationException;

public class ObjectReferenceInterceptor
extends Interceptor {
    private MBeanInfo info;
    private DynamicMBean resource;

    public ObjectReferenceInterceptor(Object resource, ModelMBeanInfo info) throws ReflectionException {
        super("Model MBean Interceptor");
        try {
            this.resource = DispatcherFactory.create(new ModelMBeanInfoSupport(info), resource);
        }
        catch (IntrospectionException e) {
            throw new ReflectionException(e);
        }
    }

    public Object invoke(Invocation invocation) throws InvocationException {
        try {
            if (invocation.getInvocationType() == 16) {
                return this.resource.invoke(invocation.getName(), invocation.getArgs(), invocation.getSignature());
            }
            if (invocation.getImpact() == 2) {
                this.resource.setAttribute(new Attribute(invocation.getName(), invocation.getArgs()[0]));
                return null;
            }
            return this.resource.getAttribute(invocation.getName());
        }
        catch (Throwable t) {
            throw new InvocationException(t);
        }
    }
}

