/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import java.util.Date;
import java.util.HashMap;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.PersistentMBean;
import javax.management.timer.TimerMBean;
import org.jboss.mx.interceptor.Interceptor;
import org.jboss.mx.interceptor.Invocation;
import org.jboss.mx.interceptor.InvocationException;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jboss.mx.service.ServiceConstants;
import org.jboss.mx.util.MBeanProxy;

public class PersistenceInterceptor
extends Interceptor
implements ModelMBeanConstants,
ServiceConstants {
    private HashMap attrPersistencePolicies = new HashMap();
    private String mbeanPersistencePolicy = null;
    private MBeanServer server = null;
    private PersistentMBean callback = null;
    static /* synthetic */ Class class$javax$management$timer$Timer;
    static /* synthetic */ Class class$javax$management$timer$TimerMBean;

    public PersistenceInterceptor(MBeanServer server, PersistentMBean callback, Descriptor[] descriptors) {
        super("MBean Persistence Interceptor");
        this.server = server;
        this.callback = callback;
        int i = 0;
        while (i < descriptors.length) {
            String policy = (String)descriptors[i].getFieldValue("persistPolicy");
            String persistPeriod = (String)descriptors[i].getFieldValue("persistPeriod");
            if (((String)descriptors[i].getFieldValue("descriptorType")).equalsIgnoreCase("MBean")) {
                this.mbeanPersistencePolicy = policy == null ? "Never" : policy;
                if (this.mbeanPersistencePolicy.equalsIgnoreCase("OnTimer")) {
                    this.schedulePersistenceNotifications(Long.parseLong(persistPeriod), "MBean");
                }
            } else {
                String name = (String)descriptors[i].getFieldValue("name");
                this.attrPersistencePolicies.put(name, policy);
                if (policy != null && policy.equalsIgnoreCase("OnTimer")) {
                    this.schedulePersistenceNotifications(Long.parseLong(persistPeriod), name);
                }
            }
            ++i;
        }
    }

    public Object invoke(Invocation invocation) throws InvocationException {
        if (invocation.getInvocationType() == 16) {
            return this.getNext().invoke(invocation);
        }
        String policy = (String)this.attrPersistencePolicies.get(invocation.getName());
        if (policy == null) {
            policy = this.mbeanPersistencePolicy;
        }
        if (policy.equalsIgnoreCase("Never") || policy.equalsIgnoreCase("OnTimer")) {
            return this.getNext().invoke(invocation);
        }
        if (policy.equalsIgnoreCase("OnUpdate")) {
            Object returnValue = this.getNext().invoke(invocation);
            try {
                this.callback.store();
            }
            catch (Throwable t) {
                throw new InvocationException(t, "Cannot persist the MBean data.");
            }
            return returnValue;
        }
        throw new Error("NoMoreOftenThan: NYI");
    }

    private void schedulePersistenceNotifications(long persistPeriod, String name) {
        try {
            ObjectName timerName = new ObjectName(ServiceConstants.PERSISTENCE_TIMER);
            TimerMBean timer = (TimerMBean)MBeanProxy.create(class$javax$management$timer$Timer == null ? (class$javax$management$timer$Timer = PersistenceInterceptor.class$("javax.management.timer.Timer")) : class$javax$management$timer$Timer, class$javax$management$timer$TimerMBean == null ? (class$javax$management$timer$TimerMBean = PersistenceInterceptor.class$("javax.management.timer.TimerMBean")) : class$javax$management$timer$TimerMBean, timerName, this.server);
            timer.start();
            timer.addNotification("persistence.timer.notification", null, name, new Date(System.currentTimeMillis()), persistPeriod);
            this.server.addNotificationListener(timerName, new PersistenceNotificationListener(), (NotificationFilter)new PersistenceNotificationFilter(name), null);
        }
        catch (Throwable t) {
            throw new Error(t.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PersistenceNotificationFilter
    implements NotificationFilter {
        private String name = null;

        public PersistenceNotificationFilter(String attrName) {
            this.name = attrName;
        }

        public boolean isNotificationEnabled(Notification notification) {
            return notification.getUserData().equals(this.name);
        }
    }

    private class PersistenceNotificationListener
    implements NotificationListener {
        private PersistenceNotificationListener() {
        }

        public void handleNotification(Notification notification, Object handback) {
            try {
                PersistenceInterceptor.this.callback.store();
            }
            catch (MBeanException e) {
            }
            catch (InstanceNotFoundException e) {
                // empty catch block
            }
        }
    }
}

