/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.jboss.mx.loading.UnifiedClassLoader3;
import org.jboss.mx.logging.Logger;

public class ClassLoadingTask {
    static Logger log = Logger.getLogger(class$org$jboss$mx$loading$ClassLoadingTask == null ? (class$org$jboss$mx$loading$ClassLoadingTask = ClassLoadingTask.class$("org.jboss.mx.loading.ClassLoadingTask")) : class$org$jboss$mx$loading$ClassLoadingTask);
    static final int FOUND_CLASS_LOADER = 1;
    static final int WAIT_ON_EVENT = 2;
    static final int FINISHED = 3;
    String classname;
    Thread requestingThread;
    UnifiedClassLoader3 requestingClassLoader;
    Class loadedClass;
    int loadOrder = Integer.MAX_VALUE;
    Throwable loadException;
    int threadTaskCount;
    int state;
    boolean trace;
    static /* synthetic */ Class class$org$jboss$mx$loading$ClassLoadingTask;

    ClassLoadingTask(String classname, UnifiedClassLoader3 requestingClassLoader, Thread requestingThread) {
        this.requestingThread = requestingThread;
        this.requestingClassLoader = requestingClassLoader;
        this.classname = classname;
        this.trace = log.isTraceEnabled();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append('{');
        buffer.append("classname: " + this.classname);
        buffer.append(", requestingThread: " + this.requestingThread);
        buffer.append(", requestingClassLoader: " + this.requestingClassLoader);
        buffer.append(", loadedClass: " + this.loadedClass);
        if (this.loadedClass != null) {
            buffer.append("@" + Integer.toHexString(this.loadedClass.hashCode()));
        }
        buffer.append(", loadOrder: " + this.loadOrder);
        buffer.append(", loadException: " + this.loadException);
        buffer.append(", threadTaskCount: " + this.threadTaskCount);
        buffer.append(", state: " + this.state);
        buffer.append('}');
        return buffer.toString();
    }

    ThreadTask newThreadTask(UnifiedClassLoader3 ucl, Thread t, int order, boolean reschedule, boolean releaseInNextTask) {
        if (!reschedule) {
            ++this.threadTaskCount;
        }
        return new ThreadTask(ucl, t, order, releaseInNextTask);
    }

    private synchronized void setLoadedClass(Class theClass, int order) {
        --this.threadTaskCount;
        if (this.trace) {
            log.trace("setLoadedClass, theClass=" + theClass + ", order=" + order);
        }
        if (this.loadedClass != null && order == this.loadOrder) {
            StringBuffer tmp = new StringBuffer("Duplicate class found: " + this.classname);
            tmp.append('\n');
            ProtectionDomain pd = this.loadedClass.getProtectionDomain();
            CodeSource cs = pd != null ? pd.getCodeSource() : null;
            tmp.append("Current CS: " + cs);
            tmp.append('\n');
            pd = theClass.getProtectionDomain();
            cs = pd != null ? pd.getCodeSource() : null;
            tmp.append("Duplicate CS: " + cs);
            log.warn(tmp.toString());
        }
        if (theClass != null) {
            if (order < this.loadOrder) {
                this.loadedClass = theClass;
                this.loadOrder = order;
            } else {
                ProtectionDomain pd = this.loadedClass.getProtectionDomain();
                CodeSource cs = pd != null ? pd.getCodeSource() : null;
                ProtectionDomain pd2 = theClass.getProtectionDomain();
                CodeSource cs2 = pd != null ? pd2.getCodeSource() : null;
                log.debug("Ignoring source of: " + this.classname + " from CodeSource: " + cs2 + ", due to order(" + order + ">=" + this.loadOrder + "), " + "accepted CodeSource: " + cs);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ThreadTask {
        UnifiedClassLoader3 ucl;
        Thread t;
        int order;
        boolean releaseInNextTask;

        ThreadTask(UnifiedClassLoader3 ucl, Thread t, int order, boolean releaseInNextTask) {
            this.ucl = ucl;
            this.t = t;
            this.order = order;
            this.releaseInNextTask = releaseInNextTask;
        }

        public String toString() {
            return "{t=" + this.t + ", ucl=" + this.ucl + ", name=" + ClassLoadingTask.this.classname + ", requestingThread=" + ClassLoadingTask.this.requestingThread + ", order=" + this.order + ", releaseInNextTask=" + this.releaseInNextTask + "}";
        }

        String getClassname() {
            return ClassLoadingTask.this.classname;
        }

        Class getLoadedClass() {
            return ClassLoadingTask.this.loadedClass;
        }

        ClassLoadingTask getLoadTask() {
            return ClassLoadingTask.this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void run() throws ClassNotFoundException {
            Class theClass = null;
            try {
                try {
                    theClass = this.ucl.loadClassLocally(ClassLoadingTask.this.classname, false);
                }
                catch (ClassNotFoundException e) {
                    String subname;
                    Class elementClass;
                    ClassLoadingTask.this.loadException = e;
                    if (ClassLoadingTask.this.classname.charAt(0) == '[' && (elementClass = this.ucl.loadClassLocally(subname = ClassLoadingTask.this.classname.substring(2, ClassLoadingTask.this.classname.length() - 1), false)) != null) {
                        theClass = this.ucl.loadClassLocally(ClassLoadingTask.this.classname, false);
                        ClassLoadingTask.this.loadException = null;
                    }
                    Object var6_3 = null;
                    ClassLoadingTask.this.setLoadedClass(theClass, this.order);
                    return;
                }
                Object var6_2 = null;
            }
            catch (Throwable throwable) {
                Object var6_4 = null;
                ClassLoadingTask.this.setLoadedClass(theClass, this.order);
                throw throwable;
            }
            ClassLoadingTask.this.setLoadedClass(theClass, this.order);
        }
    }
}

