/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.mx.loading.LoadMgr;
import org.jboss.mx.loading.UnifiedClassLoader3;
import org.jboss.mx.loading.UnifiedLoaderRepository3;
import org.jboss.mx.logging.Logger;

public class HeirarchicalLoaderRepository3
extends UnifiedLoaderRepository3 {
    private static final Logger log = Logger.getLogger(class$org$jboss$mx$loading$HeirarchicalLoaderRepository3 == null ? (class$org$jboss$mx$loading$HeirarchicalLoaderRepository3 = HeirarchicalLoaderRepository3.class$("org.jboss.mx.loading.HeirarchicalLoaderRepository3")) : class$org$jboss$mx$loading$HeirarchicalLoaderRepository3);
    private static ObjectName DEFAULT_LOADER_NAME;
    private UnifiedLoaderRepository3 parentRepository;
    static /* synthetic */ Class class$org$jboss$mx$loading$HeirarchicalLoaderRepository3;

    public HeirarchicalLoaderRepository3(MBeanServer server) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        this(server, DEFAULT_LOADER_NAME);
    }

    public HeirarchicalLoaderRepository3(MBeanServer server, ObjectName parentName) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        this.parentRepository = (UnifiedLoaderRepository3)server.getAttribute(parentName, "Instance");
    }

    public Class loadClass(String name, boolean resolve, ClassLoader scl) throws ClassNotFoundException {
        Class foundClass;
        block3: {
            foundClass = null;
            try {
                foundClass = super.loadClass(name, resolve, scl);
            }
            catch (ClassNotFoundException e) {
                if (foundClass != null) break block3;
                foundClass = this.parentRepository.loadClass(name, resolve, scl);
            }
        }
        if (foundClass != null) {
            return foundClass;
        }
        throw new ClassNotFoundException(name);
    }

    public URL getResource(String name, ClassLoader scl) {
        URL resource = super.getResource(name, scl);
        if (resource == null) {
            resource = this.parentRepository.getResource(name, scl);
        }
        return resource;
    }

    public URL[] getURLs() {
        URL[] ourURLs = super.getURLs();
        URL[] parentURLs = this.parentRepository.getURLs();
        int size = ourURLs.length + parentURLs.length;
        URL[] urls = new URL[size];
        System.arraycopy(ourURLs, 0, urls, 0, ourURLs.length);
        System.arraycopy(parentURLs, 0, urls, ourURLs.length, parentURLs.length);
        return urls;
    }

    Class loadClassFromCache(String name) {
        Class foundClass = super.loadClassFromCache(name);
        if (foundClass == null) {
            foundClass = this.parentRepository.loadClassFromCache(name);
        }
        return foundClass;
    }

    public HashSet getPackageClassLoaders(String name) {
        LoadMgr.PkgClassLoader pkgUcl;
        UnifiedClassLoader3 ucl;
        Iterator iter;
        HashSet pkgSet = super.getPackageClassLoaders(name);
        HashSet parentPkgSet = this.parentRepository.getPackageClassLoaders(name);
        HashSet<LoadMgr.PkgClassLoader> theSet = new HashSet<LoadMgr.PkgClassLoader>();
        if (pkgSet != null) {
            iter = pkgSet.iterator();
            while (iter.hasNext()) {
                ucl = (UnifiedClassLoader3)iter.next();
                pkgUcl = new LoadMgr.PkgClassLoader(ucl, 0);
                theSet.add(pkgUcl);
            }
        }
        if (parentPkgSet != null) {
            iter = parentPkgSet.iterator();
            while (iter.hasNext()) {
                ucl = (UnifiedClassLoader3)iter.next();
                pkgUcl = new LoadMgr.PkgClassLoader(ucl, 1);
                theSet.add(pkgUcl);
            }
        }
        return theSet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            DEFAULT_LOADER_NAME = new ObjectName("JMImplementation:service=LoaderRepository,name=Default");
        }
        catch (Exception e) {
            log.error("Failed to initialize default loader name", e);
        }
    }
}

