/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.mx.loading.ClassLoadingTask;
import org.jboss.mx.loading.UnifiedClassLoader3;
import org.jboss.mx.loading.UnifiedLoaderRepository3;
import org.jboss.mx.logging.Logger;

public class LoadMgr {
    private static Logger log = Logger.getLogger(class$org$jboss$mx$loading$LoadMgr == null ? (class$org$jboss$mx$loading$LoadMgr = LoadMgr.class$("org.jboss.mx.loading.LoadMgr")) : class$org$jboss$mx$loading$LoadMgr);
    private static Object registrationLock = new Object();
    private static Map loadClassThreads = Collections.synchronizedMap(new HashMap());
    private static Map loadTasksByThread = Collections.synchronizedMap(new WeakHashMap());
    static /* synthetic */ Class class$org$jboss$mx$loading$LoadMgr;

    static void registerLoaderThread(UnifiedClassLoader3 ucl, Thread t) {
        Object object = registrationLock;
        synchronized (object) {
            Thread prevThread = loadClassThreads.put(ucl, t);
            if (log.isTraceEnabled()) {
                log.trace("registerLoaderThread, ucl=" + ucl + ", t=" + t + ", prevT=" + prevThread);
            }
            Map map = loadTasksByThread;
            synchronized (map) {
                LinkedList taskList = (LinkedList)loadTasksByThread.get(t);
                if (taskList == null) {
                    taskList = new LinkedList();
                    loadTasksByThread.put(t, taskList);
                    if (log.isTraceEnabled()) {
                        log.trace("created new task list");
                    }
                }
            }
            registrationLock.notify();
        }
    }

    static synchronized boolean beginLoadTask(ClassLoadingTask task, UnifiedLoaderRepository3 repository) throws ClassNotFoundException {
        Class cls;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Begin beginLoadTask, task=" + task);
        }
        if ((cls = repository.loadClassFromCache(task.classname)) != null) {
            if (trace) {
                log.trace("End beginLoadTask, loadClassFromCache");
            }
            task.loadedClass = cls;
            task.state = 3;
            return true;
        }
        cls = repository.loadClassFromClassLoader(task.classname, false, task.requestingClassLoader);
        if (cls != null) {
            if (trace) {
                log.trace("End beginLoadTask, loadClassFromClassLoader");
            }
            task.loadedClass = cls;
            task.state = 3;
            return true;
        }
        HashSet pkgSet = repository.getPackageClassLoaders(task.classname);
        if (pkgSet == null || pkgSet.size() == 0) {
            if (trace) {
                log.trace("End beginLoadTask, ClassNotFoundException");
            }
            String msg = "No ClassLoaders found for: " + task.classname;
            throw new ClassNotFoundException(msg);
        }
        Iterator iter = pkgSet.iterator();
        int order = 0;
        while (iter.hasNext()) {
            UnifiedClassLoader3 ucl;
            Object next = iter.next();
            if (next instanceof UnifiedClassLoader3) {
                ucl = (UnifiedClassLoader3)next;
            } else {
                PkgClassLoader pkgUcl = (PkgClassLoader)next;
                ucl = pkgUcl.ucl;
                order = pkgUcl.order;
            }
            LoadMgr.scheduleTask(task, ucl, order, false, trace);
            ++order;
        }
        if (trace) {
            log.trace("End beginLoadTask, task=" + task);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static synchronized void nextTask(Thread t, ClassLoadingTask task, UnifiedLoaderRepository3 repository) {
        ClassLoadingTask loadTask;
        ClassLoadingTask.ThreadTask threadTask;
        LinkedList taskList;
        boolean trace;
        block26: {
            trace = log.isTraceEnabled();
            taskList = (LinkedList)loadTasksByThread.get(t);
            if (taskList.size() == 0) {
                if (trace) {
                    log.trace("Begin/End nextTask(-1), task=" + task);
                }
                task.state = 2;
                if (task.threadTaskCount == 0) {
                    task.state = 3;
                    if (task.loadedClass != null) {
                        ClassLoader loader = task.loadedClass.getClassLoader();
                        repository.cacheLoadedClass(task.classname, task.loadedClass, loader);
                    }
                }
                return;
            }
            threadTask = (ClassLoadingTask.ThreadTask)taskList.removeFirst();
            loadTask = threadTask.getLoadTask();
            if (trace) {
                log.trace("Begin nextTask(" + taskList.size() + "), LoadTask=" + loadTask);
            }
            try {
                try {
                    if (threadTask.t == null) {
                        if (trace) {
                            log.trace("Rescheduling threadTask=" + threadTask);
                        }
                        LoadMgr.scheduleTask(loadTask, threadTask.ucl, threadTask.order, true, trace);
                    } else {
                        if (trace) {
                            log.trace("Running threadTask=" + threadTask);
                        }
                        threadTask.run();
                    }
                }
                catch (Throwable e) {
                    loadTask.loadException = e;
                    Object var9_9 = null;
                    if (threadTask.releaseInNextTask) {
                        if (trace) {
                            log.trace("Releasing loadLock and ownership of UCL: " + threadTask.ucl);
                        }
                        loadClassThreads.remove(threadTask.ucl);
                        UnifiedClassLoader3 unifiedClassLoader32 = threadTask.ucl;
                        synchronized (unifiedClassLoader32) {
                            threadTask.ucl.release();
                            threadTask.ucl.notifyAll();
                        }
                    }
                    break block26;
                }
                Object var9_8 = null;
                if (!threadTask.releaseInNextTask) break block26;
                if (trace) {
                    log.trace("Releasing loadLock and ownership of UCL: " + threadTask.ucl);
                }
                loadClassThreads.remove(threadTask.ucl);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (threadTask.releaseInNextTask) {
                    if (trace) {
                        log.trace("Releasing loadLock and ownership of UCL: " + threadTask.ucl);
                    }
                    loadClassThreads.remove(threadTask.ucl);
                    UnifiedClassLoader3 unifiedClassLoader3 = threadTask.ucl;
                    synchronized (unifiedClassLoader3) {
                        threadTask.ucl.release();
                        threadTask.ucl.notifyAll();
                    }
                }
                throw throwable;
            }
            UnifiedClassLoader3 unifiedClassLoader3 = threadTask.ucl;
            synchronized (unifiedClassLoader3) {
                threadTask.ucl.release();
                threadTask.ucl.notifyAll();
            }
        }
        if (loadTask.threadTaskCount == 0) {
            loadTask.state = 3;
            Class loadedClass = threadTask.getLoadedClass();
            if (loadedClass != null) {
                ClassLoader loader = loadedClass.getClassLoader();
                repository.cacheLoadedClass(threadTask.getClassname(), loadedClass, loader);
            }
        }
        if (trace) {
            log.trace("End nextTask(" + taskList.size() + "), task=" + loadTask);
        }
    }

    static synchronized void endLoadTask(ClassLoadingTask task) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Begin endLoadTask, task=" + task);
        }
        loadClassThreads.remove(task.requestingClassLoader);
        LinkedList taskList = (LinkedList)loadTasksByThread.get(task.requestingThread);
        int size = taskList != null ? taskList.size() : 0;
        LinkedList linkedList = taskList;
        synchronized (linkedList) {
            int i = 0;
            while (i < size) {
                ClassLoadingTask.ThreadTask threadTask = (ClassLoadingTask.ThreadTask)taskList.removeFirst();
                ClassLoadingTask loadTask = threadTask.getLoadTask();
                if (trace) {
                    log.trace("Reassigning task: " + threadTask + ", to: " + loadTask.requestingThread);
                }
                threadTask.t = null;
                LinkedList toTaskList = (LinkedList)loadTasksByThread.get(loadTask.requestingThread);
                toTaskList.add(0, threadTask);
                ++i;
            }
        }
    }

    static synchronized URL getResource(String name, UnifiedClassLoader3 ucl, UnifiedLoaderRepository3 repository) {
        return repository.getResource(name, ucl);
    }

    private static void scheduleTask(ClassLoadingTask task, UnifiedClassLoader3 ucl, int order, boolean reschedule, boolean trace) throws ClassNotFoundException {
        Thread t = null;
        boolean releaseInNextTask = false;
        Object object = registrationLock;
        synchronized (object) {
            t = (Thread)loadClassThreads.get(ucl);
            if (t == null) {
                if (!ucl.attempt(1L)) {
                    if (trace) {
                        log.trace("Waiting for owner of UCL: " + ucl);
                    }
                    try {
                        registrationLock.wait();
                    }
                    catch (InterruptedException e) {
                        String msg = "Interrupted waiting for registration notify, classame: " + task.classname;
                        throw new ClassNotFoundException(msg);
                    }
                    t = (Thread)loadClassThreads.get(ucl);
                    if (t == null) {
                        String msg = "Failed to obtain UCL thread after notify, classame: " + task.classname;
                        throw new ClassNotFoundException(msg);
                    }
                    if (trace) {
                        log.trace("Notified that UCL owner is: " + t);
                    }
                } else {
                    releaseInNextTask = true;
                    t = task.requestingThread;
                    Thread prevThread = loadClassThreads.put(ucl, t);
                    if (trace) {
                        log.trace("scheduleTask, taking ownership of ucl=" + ucl + ", t=" + t + ", prevT=" + prevThread);
                    }
                }
            }
        }
        ClassLoadingTask.ThreadTask subtask = task.newThreadTask(ucl, t, order, reschedule, releaseInNextTask);
        LinkedList taskList = (LinkedList)loadTasksByThread.get(t);
        taskList.add(subtask);
        if (trace) {
            log.trace("scheduleTask(" + taskList.size() + "), created subtask: " + subtask);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class PkgClassLoader {
        UnifiedClassLoader3 ucl;
        int order;

        PkgClassLoader(UnifiedClassLoader3 ucl) {
            this(ucl, Integer.MAX_VALUE);
        }

        PkgClassLoader(UnifiedClassLoader3 ucl, int order) {
            this.ucl = ucl;
            this.order = order;
        }
    }
}

