/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.UnifiedClassLoaderMBean;
import org.jboss.mx.loading.UnifiedLoaderRepository2;
import org.jboss.mx.logging.Logger;

public class UnifiedClassLoader
extends URLClassLoader
implements UnifiedClassLoaderMBean {
    private static final Logger log = Logger.getLogger(class$org$jboss$mx$loading$UnifiedClassLoader == null ? (class$org$jboss$mx$loading$UnifiedClassLoader = UnifiedClassLoader.class$("org.jboss.mx.loading.UnifiedClassLoader")) : class$org$jboss$mx$loading$UnifiedClassLoader);
    private static long repositoryLockWait = 1000L;
    private static int loadInternalRetryCount = 4;
    protected LoaderRepository repository = null;
    protected URL url = null;
    protected URL origURL = null;
    private Map classes = new ConcurrentReaderHashMap();
    private static final URL[] EMPTY_URL_ARRAY;
    static /* synthetic */ Class class$org$jboss$mx$loading$UnifiedClassLoader;

    public UnifiedClassLoader(URL url) {
        this(url, (URL)null);
    }

    public UnifiedClassLoader(URL url, URL origURL) {
        super(new URL[]{url}, (class$org$jboss$mx$loading$UnifiedClassLoader == null ? (class$org$jboss$mx$loading$UnifiedClassLoader = UnifiedClassLoader.class$("org.jboss.mx.loading.UnifiedClassLoader")) : class$org$jboss$mx$loading$UnifiedClassLoader).getClassLoader());
        log.debug("New jmx UCL with url " + url);
        this.url = url;
        this.origURL = origURL;
    }

    public UnifiedClassLoader(URL url, LoaderRepository repository) {
        this(url, null, repository);
    }

    public UnifiedClassLoader(URL url, URL origURL, LoaderRepository repository) {
        this(url, origURL);
        this.repository = repository;
        repository.addClassLoader(this);
    }

    public UnifiedClassLoader(URL url, MBeanServer server, ObjectName repositoryName) throws Exception {
        this(url, null, server, repositoryName);
    }

    public UnifiedClassLoader(URL url, URL origURL, MBeanServer server, ObjectName repositoryName) throws Exception {
        this(url, origURL);
        this.repository = (LoaderRepository)server.invoke(repositoryName, "registerClassLoader", new Object[]{this}, new String[]{this.getClass().getName()});
    }

    public UnifiedClassLoader(String name, byte[] code) {
        super(new URL[]{}, (class$org$jboss$mx$loading$UnifiedClassLoader == null ? (class$org$jboss$mx$loading$UnifiedClassLoader = UnifiedClassLoader.class$("org.jboss.mx.loading.UnifiedClassLoader")) : class$org$jboss$mx$loading$UnifiedClassLoader).getClassLoader());
        this.addClass(name, code);
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        return new ObjectName("jmx.loading:UCL=" + super.hashCode());
    }

    public void unregister() {
        if (this.repository != null) {
            this.repository.removeClassLoader(this);
        }
    }

    public void addClass(String name, byte[] code) {
        this.classes.put(name, code);
    }

    public void setRepository(LoaderRepository repository) {
        this.repository = repository;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Object o = this.classes.get(name);
        if (o != null) {
            byte[] code = (byte[])o;
            this.classes.remove(name);
            return this.defineClass(name, code, 0, code.length);
        }
        return super.findClass(name);
    }

    public Class loadClassLocally(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    public URL getResourceLocally(String name) {
        return super.getResource(name);
    }

    public URL getURL() {
        return this.url;
    }

    public URL getOrigURL() {
        return this.origURL;
    }

    public URL[] getClasspath() {
        return super.getURLs();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = null;
        boolean acquired = false;
        try {
            long waitTime = repositoryLockWait;
            int attempt = 0;
            while (!acquired && attempt < loadInternalRetryCount) {
                acquired = UnifiedLoaderRepository2.attempt(waitTime);
                waitTime *= 2L;
                ++attempt;
            }
            if (!acquired) {
                throw new IllegalStateException("UCL.loadClass called outside UnifiedLoaderRepository2 lock");
            }
            c = this.repository.loadClass(name, resolve, this);
            Object var9_7 = null;
            if (!acquired) return c;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (!acquired) throw throwable;
            UnifiedLoaderRepository2.release();
            throw throwable;
        }
        UnifiedLoaderRepository2.release();
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URL getResource(String name) {
        URL res = null;
        boolean acquired = false;
        try {
            long waitTime = repositoryLockWait;
            int attempt = 0;
            while (!acquired && attempt < loadInternalRetryCount) {
                acquired = UnifiedLoaderRepository2.attempt(waitTime);
                waitTime *= 2L;
                ++attempt;
            }
            if (!acquired) {
                log.warn("UCL.getResource called outside UnifiedLoaderRepository2 lock");
            } else {
                res = this.repository.getResource(name, this);
            }
            Object var8_6 = null;
            if (!acquired) return res;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (!acquired) throw throwable;
            UnifiedLoaderRepository2.release();
            throw throwable;
        }
        UnifiedLoaderRepository2.release();
        return res;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object other) {
        return super.equals(other);
    }

    public URL[] getAllURLs() {
        return this.repository.getURLs();
    }

    public URL[] getURLs() {
        return EMPTY_URL_ARRAY;
    }

    public Package getPackage(String name) {
        return super.getPackage(name);
    }

    public Package[] getPackages() {
        return super.getPackages();
    }

    public String toString() {
        return super.toString() + "{ url=" + this.getURL() + " }";
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        CodeSource permCS = cs;
        if (this.origURL != null) {
            permCS = new CodeSource(this.origURL, cs.getCertificates());
        }
        PermissionCollection perms = super.getPermissions(permCS);
        if (log.isTraceEnabled()) {
            log.trace("getPermissions, url=" + this.url + ", origURL=" + this.origURL + " -> " + perms);
        }
        return perms;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Integer count;
            Long wait = Long.getLong("org.jboss.mx.loading.repositoryLockWait");
            if (wait != null) {
                repositoryLockWait = wait;
            }
            if ((count = Integer.getInteger("org.jboss.mx.loading.loadInternalRetryCount")) != null) {
                loadInternalRetryCount = count;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        EMPTY_URL_ARRAY = new URL[0];
    }
}

