/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.net.URL;
import org.jboss.mx.loading.ClassLoadingTask;
import org.jboss.mx.loading.LoadMgr;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.loading.UnifiedClassLoader3MBean;
import org.jboss.mx.loading.UnifiedLoaderRepository3;
import org.jboss.mx.logging.Logger;

public class UnifiedClassLoader3
extends UnifiedClassLoader
implements UnifiedClassLoader3MBean {
    private static final Logger log = Logger.getLogger(class$org$jboss$mx$loading$UnifiedClassLoader3 == null ? (class$org$jboss$mx$loading$UnifiedClassLoader3 = UnifiedClassLoader3.class$("org.jboss.mx.loading.UnifiedClassLoader3")) : class$org$jboss$mx$loading$UnifiedClassLoader3);
    private ReentrantLock loadLock = new ReentrantLock();
    private int loadClassDepth;
    static /* synthetic */ Class class$org$jboss$mx$loading$UnifiedClassLoader3;

    public UnifiedClassLoader3(URL url) {
        this(url, (URL)null);
    }

    public UnifiedClassLoader3(URL url, URL origURL) {
        super(url, origURL);
    }

    public UnifiedClassLoader3(URL url, URL origURL, LoaderRepository repository) {
        this(url, origURL);
        this.repository = repository;
    }

    public void unregister() {
        this.repository.removeClassLoader(this);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ++this.loadClassDepth;
        boolean acquired = this.attempt(1L);
        while (!acquired) {
            try {
                this.wait();
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            acquired = this.attempt(1L);
        }
        ClassLoadingTask task = null;
        try {
            UnifiedLoaderRepository3 ulr3;
            Thread t = Thread.currentThread();
            if (this.loadLock.holds() == 1L) {
                LoadMgr.registerLoaderThread(this, t);
            }
            if (!LoadMgr.beginLoadTask(task = new ClassLoadingTask(name, this, t), ulr3 = (UnifiedLoaderRepository3)this.repository)) {
                while (task.state != 3) {
                    LoadMgr.nextTask(t, task, ulr3);
                    if (task.state != 2) continue;
                    ClassLoadingTask classLoadingTask = task;
                    synchronized (classLoadingTask) {
                        try {
                            task.wait(10L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (this.loadLock.holds() == 1L) {
                LoadMgr.endLoadTask(task);
            }
            this.release();
            this.notifyAll();
            --this.loadClassDepth;
            throw throwable;
        }
        if (this.loadLock.holds() == 1L) {
            LoadMgr.endLoadTask(task);
        }
        this.release();
        this.notifyAll();
        --this.loadClassDepth;
        {
        }
        if (task.loadedClass == null) {
            if (task.loadException instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)task.loadException;
            }
            if (task.loadException != null) {
                if (log.isTraceEnabled()) {
                    log.trace("Unexpected error during load of:" + name, task.loadException);
                }
                String msg = "Unexpected error during load of: " + name + ", msg=" + task.loadException.getMessage();
                throw new ClassNotFoundException(msg);
            }
            throw new IllegalStateException("ClassLoadingTask.loadedTask is null, name: " + name);
        }
        return task.loadedClass;
    }

    public URL getResource(String name) {
        UnifiedLoaderRepository3 ulr3 = (UnifiedLoaderRepository3)this.repository;
        URL u = LoadMgr.getResource(name, this, ulr3);
        return u;
    }

    boolean attempt(long waitMS) {
        boolean acquired = false;
        Thread.currentThread();
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            try {
                acquired = this.loadLock.attempt(waitMS);
            }
            catch (InterruptedException e) {
                Object var7_5 = null;
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            Object var7_4 = null;
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("attempt(" + this.loadLock.holds() + ") was: " + acquired + " for :" + this);
        }
        return acquired;
    }

    void acquire() {
        Thread.currentThread();
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            try {
                this.loadLock.acquire();
            }
            catch (InterruptedException e) {
                Object var4_3 = null;
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            Object var4_2 = null;
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("acquired(" + this.loadLock.holds() + ") for :" + this);
        }
    }

    void release() {
        if (log.isTraceEnabled()) {
            log.trace("release(" + this.loadLock.holds() + ") for :" + this);
        }
        this.loadLock.release();
        if (log.isTraceEnabled()) {
            log.trace("released, holds: " + this.loadLock.holds());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

