/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.jboss.mx.loading.ClassLoaderUtils;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.ResourceInfo;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.loading.UnifiedClassLoader3;
import org.jboss.mx.loading.UnifiedLoaderRepository3MBean;
import org.jboss.mx.logging.Logger;

public class UnifiedLoaderRepository3
extends LoaderRepository
implements NotificationBroadcaster,
UnifiedLoaderRepository3MBean {
    private static final Logger log = Logger.getLogger(class$org$jboss$mx$loading$UnifiedLoaderRepository3 == null ? (class$org$jboss$mx$loading$UnifiedLoaderRepository3 = UnifiedLoaderRepository3.class$("org.jboss.mx.loading.UnifiedLoaderRepository3")) : class$org$jboss$mx$loading$UnifiedLoaderRepository3);
    private HashSet classLoaders = new HashSet();
    private HashSet classLoaderURLs = new HashSet();
    private HashMap classes = new HashMap();
    private HashMap loaderToClassesMap = new HashMap();
    private HashMap loaderToResourcesMap = new HashMap();
    private HashMap globalResources = new HashMap();
    private HashMap packagesMap = new HashMap();
    private HashMap loaderToPackagesMap = new HashMap();
    private long sequenceNumber = 0L;
    private final NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
    private MBeanNotificationInfo[] info;
    static /* synthetic */ Class class$org$jboss$mx$loading$UnifiedLoaderRepository3;
    static /* synthetic */ Class class$org$jboss$mx$loading$LoadMgr;

    public UnifiedClassLoader newClassLoader(URL url, boolean addToRepository) throws Exception {
        UnifiedClassLoader3 ucl = new UnifiedClassLoader3(url, null, this);
        if (addToRepository) {
            this.addClassLoader(ucl);
        }
        return ucl;
    }

    public UnifiedClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository) throws Exception {
        UnifiedClassLoader3 ucl = new UnifiedClassLoader3(url, origURL, this);
        if (addToRepository) {
            this.addClassLoader(ucl);
        }
        return ucl;
    }

    public Class loadClass(String name, boolean resolve, ClassLoader cl) throws ClassNotFoundException {
        UnifiedClassLoader3 ucl = (UnifiedClassLoader3)cl;
        return ucl.loadClass(name, resolve);
    }

    public HashSet getPackageClassLoaders(String className) {
        String pkgName = ClassLoaderUtils.getPackageName(className);
        HashSet pkgSet = (HashSet)this.packagesMap.get(pkgName);
        return pkgSet;
    }

    private String getResourcePackageName(String rsrcName) {
        int index = rsrcName.lastIndexOf(47);
        String pkgName = rsrcName;
        if (index > 0) {
            pkgName = rsrcName.substring(0, index);
        }
        return pkgName.replace('/', '.');
    }

    private boolean containsClassPackage(String className) {
        String pkgName = ClassLoaderUtils.getPackageName(className);
        return this.packagesMap.containsKey(pkgName);
    }

    Class loadSystemClass(String name, UnifiedClassLoader cl) {
        Class cls = null;
        try {
            if (name.startsWith("java.") || name.startsWith("javax.")) {
                cls = cl.loadClassLocally(name, false);
            }
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        return cls;
    }

    Class loadClassFromCache(String name) {
        Class cls = (Class)this.classes.get(name);
        return cls;
    }

    void cacheLoadedClass(String name, Class cls, ClassLoader cl) {
        this.classes.put(name, cls);
        HashSet<String> classes = (HashSet<String>)this.loaderToClassesMap.get(cl);
        if (classes == null) {
            classes = new HashSet<String>();
            this.loaderToClassesMap.put(cl, classes);
        }
        classes.add(name);
    }

    Class loadClassFromClassLoader(String name, boolean resolve, UnifiedClassLoader cl) {
        if (cl instanceof UnifiedClassLoader) {
            try {
                Class cls = cl.loadClassLocally(name, resolve);
                this.cacheLoadedClass(name, cls, cl);
                return cls;
            }
            catch (ClassNotFoundException x) {
                // empty catch block
            }
        }
        return null;
    }

    private Class loadClassFromRepository(String name, boolean resolve, ClassLoader cl) {
        String pkgName = ClassLoaderUtils.getPackageName(name);
        HashSet pkgSet = (HashSet)this.packagesMap.get(pkgName);
        if (pkgSet == null) {
            return null;
        }
        Iterator i = pkgSet.iterator();
        while (i.hasNext()) {
            ClassLoader classloader = (ClassLoader)i.next();
            if (classloader.equals(cl) || !(classloader instanceof UnifiedClassLoader)) continue;
            try {
                UnifiedClassLoader ucl = (UnifiedClassLoader)classloader;
                Class cls = ucl.loadClassLocally(name, resolve);
                this.cacheLoadedClass(name, cls, classloader);
                return cls;
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    public URL getResource(String name, ClassLoader cl) {
        URL resource = this.getResourceFromCache(name, cl);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromClassLoader(name, cl);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromGlobalCache(name);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromRepository(name, cl);
        if (resource != null) {
            return resource;
        }
        return null;
    }

    private URL getResourceFromCache(String name, ClassLoader cl) {
        if (this.loaderToResourcesMap.containsKey(cl)) {
            HashMap resources = (HashMap)this.loaderToResourcesMap.get(cl);
            return (URL)resources.get(name);
        }
        return null;
    }

    private URL getResourceFromClassLoader(String name, ClassLoader cl) {
        if (cl instanceof UnifiedClassLoader) {
            URL url = ((UnifiedClassLoader)cl).getResourceLocally(name);
            this.cacheLoadedResource(name, url, cl);
            return url;
        }
        return null;
    }

    private URL getResourceFromGlobalCache(String name) {
        ResourceInfo ri = (ResourceInfo)this.globalResources.get(name);
        if (ri != null) {
            return ri.url;
        }
        return null;
    }

    private URL getResourceFromRepository(String name, ClassLoader cl) {
        String pkgName = this.getResourcePackageName(name);
        HashSet pkgSet = (HashSet)this.packagesMap.get(pkgName);
        Iterator i = pkgSet != null ? pkgSet.iterator() : this.classLoaders.iterator();
        while (i.hasNext()) {
            URL url;
            ClassLoader classloader = (ClassLoader)i.next();
            if (classloader.equals(cl) || !(classloader instanceof UnifiedClassLoader) || (url = ((UnifiedClassLoader)classloader).getResourceLocally(name)) == null) continue;
            this.cacheLoadedResource(name, url, classloader);
            this.cacheGlobalResource(name, url, classloader);
            return url;
        }
        return null;
    }

    private void cacheLoadedResource(String name, URL url, ClassLoader cl) {
        HashMap<String, URL> resources = (HashMap<String, URL>)this.loaderToResourcesMap.get(cl);
        if (resources == null) {
            resources = new HashMap<String, URL>();
            this.loaderToResourcesMap.put(cl, resources);
        }
        resources.put(name, url);
    }

    private void cacheGlobalResource(String name, URL url, ClassLoader cl) {
        this.globalResources.put(name, new ResourceInfo(url, cl));
    }

    public URL[] getURLs() {
        HashSet<URL> classpath = new HashSet<URL>();
        HashSet tmp = (HashSet)this.classLoaders.clone();
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof UnifiedClassLoader)) continue;
            UnifiedClassLoader cl = (UnifiedClassLoader)obj;
            URL[] urls = cl.getClasspath();
            int length = urls != null ? urls.length : 0;
            int u = 0;
            while (u < length) {
                URL path = urls[u];
                classpath.add(path);
                ++u;
            }
        }
        URL[] cp = new URL[classpath.size()];
        classpath.toArray(cp);
        return cp;
    }

    public String displayClassInfo(String className) {
        String classRsrcName = className.replace('.', '/') + ".class";
        int count = 0;
        StringBuffer results = new StringBuffer(className + " Information");
        HashSet tmp = (HashSet)this.classLoaders.clone();
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            URLClassLoader cl = (URLClassLoader)iter.next();
            URL classURL = cl.findResource(classRsrcName);
            if (classURL == null) continue;
            try {
                Class<?> cls = cl.loadClass(className);
                results.append("\n\n### Instance" + count + " via UCL: " + cl + "\n");
                ++count;
                ClassLoaderUtils.displayClassInfo(cls, results);
            }
            catch (ClassNotFoundException e) {
                results.append("\nFailed to find class in UCL: " + cl);
            }
        }
        return results.toString();
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader scl = Thread.currentThread().getContextClassLoader();
        Class clazz = null;
        clazz = scl instanceof UnifiedClassLoader3 ? this.loadClass(className, false, scl) : scl.loadClass(className);
        return clazz;
    }

    public Class findClass(String name) {
        String classRsrcName = name.replace('.', '/') + ".class";
        HashSet tmp = (HashSet)this.classLoaders.clone();
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            URLClassLoader cl = (URLClassLoader)iter.next();
            URL classURL = cl.findResource(classRsrcName);
            log.trace("Checking CL for URL: " + classURL);
            if (classURL == null) continue;
            try {
                Class<?> cls = cl.loadClass(name);
                log.trace("Found class in: " + cls.getProtectionDomain());
                return cls;
            }
            catch (ClassNotFoundException e) {
                log.debug("Failed to load class: " + name, e);
            }
        }
        log.trace("Class not found");
        return null;
    }

    public Class loadClassWithout(ClassLoader loader, String className) throws ClassNotFoundException {
        throw new ClassNotFoundException("NYI");
    }

    public void addClassLoader(ClassLoader loader) {
        Class clazz = class$org$jboss$mx$loading$LoadMgr == null ? (class$org$jboss$mx$loading$LoadMgr = UnifiedLoaderRepository3.class$("org.jboss.mx.loading.LoadMgr")) : class$org$jboss$mx$loading$LoadMgr;
        synchronized (clazz) {
            if (loader instanceof UnifiedClassLoader) {
                this.addUnifiedClassLoader((UnifiedClassLoader)loader);
            } else if (loader instanceof URLClassLoader) {
                URLClassLoader ucl = (URLClassLoader)loader;
                URL[] urls = ucl.getURLs();
                int i = 0;
                while (i < urls.length) {
                    this.addUnifiedClassLoader(new UnifiedClassLoader(urls[i], this));
                    ++i;
                }
            } else {
                log.warn("Tried to add non- URLClassLoader.  Ignored");
            }
        }
    }

    private void addUnifiedClassLoader(UnifiedClassLoader cl) {
        cl.setRepository(this);
        URL url = cl.getURL();
        boolean added = false;
        boolean exists = this.classLoaderURLs.contains(url);
        if (!exists) {
            this.classLoaderURLs.add(url);
            added = this.classLoaders.add(cl);
        }
        if (added) {
            log.debug("Adding " + cl);
            this.updatePackageMap(cl);
        } else {
            log.debug("Skipping duplicate " + cl);
        }
    }

    private void updatePackageMap(UnifiedClassLoader cl) {
        try {
            String[] pkgNames = ClassLoaderUtils.updatePackageMap(cl, this.packagesMap);
            this.loaderToPackagesMap.put(cl, pkgNames);
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Failed to update pkgs for cl=" + cl, e);
            }
            log.debug("Failed to update pkgs for cl=" + cl, e);
        }
    }

    public void removeClassLoader(ClassLoader cl) {
        Class clazz = class$org$jboss$mx$loading$LoadMgr == null ? (class$org$jboss$mx$loading$LoadMgr = UnifiedLoaderRepository3.class$("org.jboss.mx.loading.LoadMgr")) : class$org$jboss$mx$loading$LoadMgr;
        synchronized (clazz) {
            String[] pkgNames;
            HashMap resources;
            HashSet loaded;
            if (cl instanceof UnifiedClassLoader) {
                UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
                URL url = ucl.getURL();
                this.classLoaderURLs.remove(url);
            }
            boolean removed = this.classLoaders.remove(cl);
            log.debug("UnifiedLoaderRepository removed(" + removed + ") " + cl);
            if (this.loaderToClassesMap.containsKey(cl) && (loaded = (HashSet)this.loaderToClassesMap.remove(cl)) != null) {
                Iterator iter = loaded.iterator();
                while (iter.hasNext()) {
                    this.broadcaster.sendNotification(new Notification("jboss.mx.class.removed", (Object)this, this.getNextSequenceNumber(), (String)iter.next()));
                }
                Iterator i = loaded.iterator();
                while (i.hasNext()) {
                    String cls = (String)i.next();
                    this.classes.remove(cls);
                }
            }
            if (this.loaderToResourcesMap.containsKey(cl) && (resources = (HashMap)this.loaderToResourcesMap.remove(cl)) != null) {
                Iterator i = resources.keySet().iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    ResourceInfo ri = (ResourceInfo)this.globalResources.get(name);
                    if (ri == null || ri.cl != cl) continue;
                    this.globalResources.remove(name);
                }
            }
            int length = (pkgNames = (String[])this.loaderToPackagesMap.remove(cl)) != null ? pkgNames.length : 0;
            int p = 0;
            while (p < length) {
                String pkgName = pkgNames[p];
                HashSet pkgSet = (HashSet)this.packagesMap.get(pkgName);
                if (pkgSet != null) {
                    pkgSet.remove(cl);
                    if (pkgSet.isEmpty()) {
                        this.packagesMap.remove(pkgName);
                    }
                }
                ++p;
            }
        }
    }

    public LoaderRepository registerClassLoader(UnifiedClassLoader ucl) {
        this.addClassLoader(ucl);
        Notification msg = new Notification("jboss.mx.classloader.added", this, this.getNextSequenceNumber());
        msg.setUserData(ucl);
        this.broadcaster.sendNotification(msg);
        return this;
    }

    public LoaderRepository getInstance() {
        return this;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.info == null) {
            this.info = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"CLASSLOADER_ADDED"}, "javax.management.Notification", "Notification that a classloader has been added to the extensible classloader"), new MBeanNotificationInfo(new String[]{"CLASS_REMOVED"}, "javax.management.Notification", "Notification that a class has been removed from the extensible classloader")};
        }
        return this.info;
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    private long getNextSequenceNumber() {
        return this.sequenceNumber++;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

