/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.logging;

import org.jboss.mx.logging.LoggerAdapter;
import org.jboss.mx.logging.LoggerManager;

public class Logger {
    public static final int NONE = Integer.MAX_VALUE;
    public static final int FATAL = 50000;
    public static final int ERROR = 40000;
    public static final int WARN = 30000;
    public static final int INFO = 20000;
    public static final int DEBUG = 10000;
    public static final int TRACE = 9000;
    public static final int ALL = Integer.MIN_VALUE;
    private static LoggerManager manager = LoggerManager.getLoggerManager();
    private LoggerAdapter adapter;

    public static final Logger getLogger(String name) {
        return manager.getLogger(name);
    }

    public static final Logger getLogger(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        return Logger.getLogger(clazz.getName());
    }

    Logger(LoggerAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("Null adapter");
        }
        this.adapter = adapter;
    }

    public String getName() {
        return this.adapter.getName();
    }

    public int getLevel() {
        return this.adapter.getLevel();
    }

    public void setLevel(int level) throws SecurityException {
        this.adapter.setLevel(level);
    }

    public void log(int level, String message) {
        this.adapter.log(level, message);
    }

    public void log(int level, String message, Throwable throwable) {
        this.adapter.log(level, message, throwable);
    }

    public boolean isEnabled(int level) {
        return this.adapter.isEnabled(level);
    }

    public void fatal(String message) {
        this.adapter.fatal(message);
    }

    public void fatal(String message, Throwable throwable) {
        this.adapter.fatal(message, throwable);
    }

    public boolean isFatalEnabled() {
        return this.adapter.isFatalEnabled();
    }

    public void error(String message) {
        this.adapter.error(message);
    }

    public void error(String message, Throwable throwable) {
        this.adapter.error(message, throwable);
    }

    public boolean isErrorEnabled() {
        return this.adapter.isErrorEnabled();
    }

    public void warn(String message) {
        this.adapter.warn(message);
    }

    public void warn(String message, Throwable throwable) {
        this.adapter.warn(message, throwable);
    }

    public boolean isWarnEnabled() {
        return this.adapter.isWarnEnabled();
    }

    public void info(String message) {
        this.adapter.info(message);
    }

    public void info(String message, Throwable throwable) {
        this.adapter.info(message, throwable);
    }

    public boolean isInfoEnabled() {
        return this.adapter.isInfoEnabled();
    }

    public void debug(String message) {
        this.adapter.debug(message);
    }

    public void debug(String message, Throwable throwable) {
        this.adapter.debug(message, throwable);
    }

    public boolean isDebugEnabled() {
        return this.adapter.isDebugEnabled();
    }

    public void trace(String message) {
        this.adapter.trace(message);
    }

    public void trace(String message, Throwable throwable) {
        this.adapter.trace(message, throwable);
    }

    public boolean isTraceEnabled() {
        return this.adapter.isTraceEnabled();
    }

    public Object getUnderlyingLogger() {
        return this.adapter.getUnderlyingLogger();
    }

    LoggerAdapter getLoggerAdapter() {
        return this.adapter;
    }

    void setLoggerAdapter(LoggerAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("Null adapter");
        }
        this.adapter = adapter;
    }
}

