/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.logging;

import java.util.Enumeration;
import org.jboss.mx.logging.DefaultLoggerContextSelector;
import org.jboss.mx.logging.Logger;
import org.jboss.mx.logging.LoggerAdapterFactory;
import org.jboss.mx.logging.LoggerContext;
import org.jboss.mx.logging.LoggerContextSelector;

public class LoggerManager {
    private LoggerContextSelector selector = new DefaultLoggerContextSelector();
    private static LoggerManager manager = new LoggerManager();

    public static final LoggerManager getLoggerManager() {
        return manager;
    }

    private LoggerManager() {
    }

    public final Logger getLogger(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        return this.selector.getLoggerContext().getLogger(name);
    }

    public final void setLoggerAdapterFactory(LoggerAdapterFactory factory) throws SecurityException {
        this.selector.getLoggerContext().setLoggerAdapterFactory(factory);
    }

    public final void setConfiguration(Object configurator) throws SecurityException {
        this.selector.getLoggerContext().setConfiguration(configurator);
    }

    public final void resetConfiguration() throws SecurityException {
        this.selector.getLoggerContext().resetConfiguration();
    }

    public final Enumeration getLoggers() {
        return this.selector.getLoggerContext().getLoggers();
    }

    public final void setLoggerContextSelector(LoggerContextSelector seletor) throws SecurityException {
        if (this.selector == null) {
            throw new IllegalArgumentException("null selector");
        }
        this.selector = this.selector;
    }

    void associateContext(Object context, LoggerContext loggerContext) {
        this.selector.associate(context, loggerContext);
    }

    void removeContext(Object context) {
        this.selector.remove(context);
    }
}

