/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Descriptor;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.jboss.mx.metadata.MetaDataBuilder;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class JBossXMBean10
implements MetaDataBuilder,
ModelMBeanConstants {
    private URL url = null;
    private String className = null;

    public JBossXMBean10(String resourceClassName, URL url) {
        this.url = url;
        this.className = resourceClassName;
    }

    public JBossXMBean10(String resourceClassName, String url) throws MalformedURLException {
        this(resourceClassName, new URL(url));
    }

    public MBeanInfo build() throws NotCompliantMBeanException {
        try {
            SAXBuilder builder = new SAXBuilder("org.apache.crimson.parser.XMLReaderImpl");
            builder.setValidation(false);
            Element root = builder.build(this.url).getRootElement();
            String description = root.getChildText("description");
            if (this.className == null) {
                this.className = root.getChildText("class");
            }
            List constructors = root.getChildren("constructor");
            List operations = root.getChildren("operation");
            List attributes = root.getChildren("attribute");
            List notifications = root.getChildren("notifications");
            Descriptor descr = this.getDescriptor(root, this.className, "mbean");
            ModelMBeanInfo info = this.buildMBeanMetaData(description, constructors, operations, attributes, notifications, descr);
            return (MBeanInfo)((Object)info);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new NotCompliantMBeanException("Error parsing the XML file: " + (e.getCause() == null ? e.toString() : e.getCause().toString()));
        }
    }

    protected Descriptor getDescriptor(Element parent, String infoName, String type) throws NotCompliantMBeanException {
        DescriptorSupport descr = new DescriptorSupport();
        descr.setField("name", infoName);
        descr.setField("descriptorType", type);
        Element descriptors = parent.getChild("descriptors");
        if (descriptors == null) {
            return descr;
        }
        Iterator i = descriptors.getChildren().iterator();
        while (i.hasNext()) {
            Element descriptor = (Element)i.next();
            String name = descriptor.getName();
            if (name.equals("persistence")) {
                Attribute persistPolicy = descriptor.getAttribute("persistPolicy");
                Attribute persistPeriod = descriptor.getAttribute("persistPeriod");
                Attribute persistLocation = descriptor.getAttribute("persistLocation");
                Attribute persistName = descriptor.getAttribute("persistName");
                if (persistPolicy != null) {
                    String value = persistPolicy.getValue();
                    this.validate(value, ModelMBeanConstants.PERSIST_POLICY_LIST);
                    descr.setField("persistPolicy", value);
                }
                if (persistPeriod != null) {
                    descr.setField("persistPeriod", persistPeriod.getValue());
                }
                if (persistLocation != null) {
                    descr.setField("persistLocation", persistLocation.getValue());
                }
                if (persistName == null) continue;
                descr.setField("persistName", persistName.getValue());
                continue;
            }
            if (name.equals("currencyTimeLimit")) {
                descr.setField("currencyTimeLimit", descriptor.getAttributeValue("value"));
                continue;
            }
            if (name.equals("state-action-on-update")) {
                String value = descriptor.getAttributeValue("value");
                this.validate(value, ModelMBeanConstants.STATE_ACTION_ON_UPDATE_LIST);
                descr.setField("state-action-on-update", value);
                continue;
            }
            if (!name.equals("descriptor")) continue;
            descr.setField(descriptor.getAttributeValue("name"), descriptor.getAttributeValue("value"));
        }
        return descr;
    }

    private void validate(String value, String[] valid) throws NotCompliantMBeanException {
        int i = 0;
        while (i < valid.length) {
            if (valid[i].equalsIgnoreCase(value)) {
                return;
            }
            ++i;
        }
        throw new NotCompliantMBeanException("Unknown descriptor value: " + value);
    }

    protected ModelMBeanInfo buildMBeanMetaData(String description, List constructors, List operations, List attributes, List notifications, Descriptor descr) throws NotCompliantMBeanException {
        ModelMBeanOperationInfo[] operInfo = this.buildOperationInfo(operations);
        ModelMBeanAttributeInfo[] attrInfo = this.buildAttributeInfo(attributes);
        ModelMBeanConstructorInfo[] constrInfo = this.buildConstructorInfo(constructors);
        ModelMBeanNotificationInfo[] notifInfo = this.buildNotificationInfo(notifications);
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(this.className, description, attrInfo, constrInfo, operInfo, notifInfo, descr);
        return info;
    }

    protected ModelMBeanConstructorInfo[] buildConstructorInfo(List constructors) throws NotCompliantMBeanException {
        ArrayList<ModelMBeanConstructorInfo> infos = new ArrayList<ModelMBeanConstructorInfo>();
        Iterator it = constructors.iterator();
        while (it.hasNext()) {
            Element constr = (Element)it.next();
            String name = constr.getChildTextTrim("name");
            String description = constr.getChildTextTrim("description");
            List params = constr.getChildren("parameter");
            MBeanParameterInfo[] paramInfo = this.buildParameterInfo(params);
            Descriptor descr = this.getDescriptor(constr, name, "constructor");
            ModelMBeanConstructorInfo info = new ModelMBeanConstructorInfo(name, description, paramInfo, descr);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanConstructorInfo[0]);
    }

    protected ModelMBeanOperationInfo[] buildOperationInfo(List operations) throws NotCompliantMBeanException {
        ArrayList<ModelMBeanOperationInfo> infos = new ArrayList<ModelMBeanOperationInfo>();
        Iterator it = operations.iterator();
        while (it.hasNext()) {
            Element oper = (Element)it.next();
            String name = oper.getChildTextTrim("name");
            String description = oper.getChildTextTrim("description");
            String type = oper.getChildTextTrim("return-type");
            String impact = oper.getAttributeValue("impact");
            List params = oper.getChildren("parameter");
            MBeanParameterInfo[] paramInfo = this.buildParameterInfo(params);
            Descriptor descr = this.getDescriptor(oper, name, "operation");
            int operImpact = 2;
            if (impact != null) {
                if (impact.equals("INFO")) {
                    operImpact = 0;
                } else if (impact.equals("ACTION")) {
                    operImpact = 1;
                } else if (impact.equals("ACTION_INFO")) {
                    operImpact = 2;
                }
            }
            if (type == null) {
                type = "void";
            }
            ModelMBeanOperationInfo info = new ModelMBeanOperationInfo(name, description, paramInfo, type, operImpact, descr);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanOperationInfo[0]);
    }

    protected ModelMBeanNotificationInfo[] buildNotificationInfo(List notifications) throws NotCompliantMBeanException {
        ArrayList<ModelMBeanNotificationInfo> infos = new ArrayList<ModelMBeanNotificationInfo>();
        Iterator it = notifications.iterator();
        while (it.hasNext()) {
            Element notif = (Element)it.next();
            String name = notif.getChildTextTrim("name");
            String description = notif.getChildTextTrim("description");
            List notifTypes = notif.getChildren("notification-type");
            Descriptor descr = this.getDescriptor(notif, name, "notification");
            ArrayList<String> types = new ArrayList<String>();
            Iterator iterator = notifTypes.iterator();
            while (iterator.hasNext()) {
                Element type = (Element)iterator.next();
                types.add(type.getTextTrim());
            }
            ModelMBeanNotificationInfo info = new ModelMBeanNotificationInfo((String[])types.toArray(), name, description, descr);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanNotificationInfo[0]);
    }

    protected ModelMBeanAttributeInfo[] buildAttributeInfo(List attributes) throws NotCompliantMBeanException {
        ArrayList<ModelMBeanAttributeInfo> infos = new ArrayList<ModelMBeanAttributeInfo>();
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            Element attr = (Element)it.next();
            String name = attr.getChildTextTrim("name");
            String description = attr.getChildTextTrim("description");
            String type = attr.getChildTextTrim("type");
            String access = attr.getAttributeValue("access");
            String getMethod = attr.getAttributeValue("getMethod");
            String setMethod = attr.getAttributeValue("setMethod");
            Descriptor descr = this.getDescriptor(attr, name, "attribute");
            if (getMethod != null) {
                descr.setField("getMethod", getMethod);
            }
            if (setMethod != null) {
                descr.setField("setMethod", setMethod);
            }
            boolean isReadable = true;
            boolean isWritable = true;
            if (access.equalsIgnoreCase("read-only")) {
                isWritable = false;
            } else if (access.equalsIgnoreCase("write-only")) {
                isReadable = false;
            }
            ModelMBeanAttributeInfo info = new ModelMBeanAttributeInfo(name, type, description, isReadable, isWritable, false, descr);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanAttributeInfo[0]);
    }

    protected MBeanParameterInfo[] buildParameterInfo(List parameters) {
        Iterator it = parameters.iterator();
        ArrayList<MBeanParameterInfo> infos = new ArrayList<MBeanParameterInfo>();
        while (it.hasNext()) {
            Element param = (Element)it.next();
            String name = param.getChildTextTrim("name");
            String type = param.getChildTextTrim("type");
            String descr = param.getChildTextTrim("description");
            MBeanParameterInfo info = new MBeanParameterInfo(name, type, descr);
            infos.add(info);
        }
        return infos.toArray(new MBeanParameterInfo[0]);
    }
}

