/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.jboss.mx.metadata.MethodMapper;
import org.jboss.mx.modelmbean.ModelMBeanConstants;

public class MBeanInfoConversion
implements ModelMBeanConstants {
    public static ModelMBeanInfoSupport toModelMBeanInfo(MBeanInfo info) {
        return MBeanInfoConversion.toModelMBeanInfo(info, false);
    }

    public static ModelMBeanInfoSupport toModelMBeanInfo(MBeanInfo info, boolean createAttributeOperationMapping) {
        MBeanAttributeInfo[] attributes = info.getAttributes();
        ModelMBeanAttributeInfo[] mmbAttributes = new ModelMBeanAttributeInfo[attributes.length];
        ArrayList<ModelMBeanOperationInfo> accessorOperations = new ArrayList<ModelMBeanOperationInfo>();
        int i = 0;
        while (i < attributes.length) {
            mmbAttributes[i] = new ModelMBeanAttributeInfo(attributes[i].getName(), attributes[i].getType(), attributes[i].getDescription(), attributes[i].isReadable(), attributes[i].isWritable(), attributes[i].isIs());
            if (createAttributeOperationMapping) {
                Descriptor attrDescriptor;
                ModelMBeanOperationInfo opInfo;
                String getterOperationName = null;
                String setterOperationName = null;
                DescriptorSupport getterDescriptor = null;
                DescriptorSupport setterDescriptor = null;
                if (attributes[i].isReadable()) {
                    getterOperationName = attributes[i].isIs() ? "is" + attributes[i].getName() : "get" + attributes[i].getName();
                    getterDescriptor = new DescriptorSupport();
                    getterDescriptor.setField("name", getterOperationName);
                    getterDescriptor.setField("descriptorType", "operation");
                    getterDescriptor.setField("role", "getter");
                    opInfo = new ModelMBeanOperationInfo(getterOperationName, "Read accessor operation for '" + attributes[i].getName() + "' attribute.", new MBeanParameterInfo[0], attributes[i].getType(), 0, getterDescriptor);
                    attrDescriptor = mmbAttributes[i].getDescriptor();
                    attrDescriptor.setField("getMethod", getterOperationName);
                    mmbAttributes[i].setDescriptor(attrDescriptor);
                    accessorOperations.add(opInfo);
                }
                if (attributes[i].isWritable()) {
                    setterOperationName = "set" + attributes[i].getName();
                    setterDescriptor = new DescriptorSupport();
                    setterDescriptor.setField("name", setterOperationName);
                    setterDescriptor.setField("descriptorType", "operation");
                    setterDescriptor.setField("role", "setter");
                    opInfo = new ModelMBeanOperationInfo(setterOperationName, "Write accessor operation for '" + attributes[i].getName() + "' attribute.", new MBeanParameterInfo[]{new MBeanParameterInfo("value", attributes[i].getType(), "Attribute's value.")}, Void.TYPE.getName(), 1, setterDescriptor);
                    attrDescriptor = mmbAttributes[i].getDescriptor();
                    attrDescriptor.setField("setMethod", setterOperationName);
                    mmbAttributes[i].setDescriptor(attrDescriptor);
                    accessorOperations.add(opInfo);
                }
            }
            ++i;
        }
        MBeanOperationInfo[] operations = info.getOperations();
        ModelMBeanOperationInfo[] mmbOperations = new ModelMBeanOperationInfo[operations.length + accessorOperations.size()];
        int i2 = 0;
        while (i2 < operations.length) {
            mmbOperations[i2] = new ModelMBeanOperationInfo(operations[i2].getName(), operations[i2].getDescription(), operations[i2].getSignature(), operations[i2].getReturnType(), operations[i2].getImpact());
            ++i2;
        }
        int i3 = operations.length;
        while (i3 < mmbOperations.length) {
            mmbOperations[i3] = (ModelMBeanOperationInfo)accessorOperations.get(i3 - operations.length);
            ++i3;
        }
        MBeanConstructorInfo[] constructors = info.getConstructors();
        ModelMBeanConstructorInfo[] mmbConstructors = new ModelMBeanConstructorInfo[constructors.length];
        int i4 = 0;
        while (i4 < constructors.length) {
            mmbConstructors[i4] = new ModelMBeanConstructorInfo(constructors[i4].getName(), constructors[i4].getDescription(), constructors[i4].getSignature());
            ++i4;
        }
        MBeanNotificationInfo[] notifications = info.getNotifications();
        ModelMBeanNotificationInfo[] mmbNotifications = new ModelMBeanNotificationInfo[notifications.length];
        int i5 = 0;
        while (i5 < notifications.length) {
            mmbNotifications[i5] = new ModelMBeanNotificationInfo(notifications[i5].getNotifTypes(), notifications[i5].getName(), notifications[i5].getDescription());
            ++i5;
        }
        return new ModelMBeanInfoSupport(info.getClassName(), info.getDescription(), mmbAttributes, mmbConstructors, mmbOperations, mmbNotifications);
    }

    public static ModelMBeanInfoSupport stripAttributeOperations(ModelMBeanInfo info, boolean stripAllRoles) throws MBeanException {
        HashMap<String, ModelMBeanOperationInfo> opsMap = new HashMap<String, ModelMBeanOperationInfo>();
        ModelMBeanOperationInfo[] operations = (ModelMBeanOperationInfo[])info.getOperations();
        int i = 0;
        while (i < operations.length) {
            opsMap.put(MethodMapper.operationSignature(operations[i]), operations[i]);
            ++i;
        }
        ModelMBeanAttributeInfo[] attributes = (ModelMBeanAttributeInfo[])info.getAttributes();
        int i2 = 0;
        while (i2 < attributes.length) {
            String key;
            ModelMBeanOperationInfo opinfo;
            String role;
            if (attributes[i2].isReadable() && attributes[i2].getDescriptor().getFieldValue("getMethod") != null && ("getter".equals(role = (String)(opinfo = (ModelMBeanOperationInfo)opsMap.get(key = MethodMapper.getterSignature(attributes[i2]))).getDescriptor().getFieldValue("role")) || stripAllRoles)) {
                opsMap.remove(key);
            }
            if (attributes[i2].isWritable() && attributes[i2].getDescriptor().getFieldValue("setMethod") != null && ("setter".equals(role = (String)(opinfo = (ModelMBeanOperationInfo)opsMap.get(key = MethodMapper.getterSignature(attributes[i2]))).getDescriptor().getFieldValue("role")) || stripAllRoles)) {
                opsMap.remove(key);
            }
            ++i2;
        }
        operations = new ModelMBeanOperationInfo[opsMap.size()];
        int position = 0;
        Iterator iterator = opsMap.values().iterator();
        while (iterator.hasNext()) {
            operations[position] = (ModelMBeanOperationInfo)iterator.next();
            ++position;
        }
        return new ModelMBeanInfoSupport(info.getClassName(), info.getDescription(), (ModelMBeanAttributeInfo[])info.getAttributes(), (ModelMBeanConstructorInfo[])info.getConstructors(), operations, (ModelMBeanNotificationInfo[])info.getNotifications(), info.getMBeanDescriptor());
    }
}

