/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;

public class MethodMapper {
    private HashMap map = null;

    public MethodMapper(Class resourceClass) {
        if (null == resourceClass) {
            throw new IllegalArgumentException("resourceClass cannot be null");
        }
        this.map = this.createMap(resourceClass);
    }

    public Method lookupOperation(MBeanOperationInfo info) {
        if (null == info) {
            throw new IllegalArgumentException("MBeanOperationInfo cannot be null");
        }
        return (Method)this.map.get(MethodMapper.operationSignature(info));
    }

    public Method lookupGetter(MBeanAttributeInfo info) {
        if (null == info) {
            throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
        }
        return (Method)this.map.get(MethodMapper.getterSignature(info));
    }

    public Method lookupGetter(ModelMBeanAttributeInfo info) {
        if (null == info) {
            throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
        }
        return (Method)this.map.get(MethodMapper.getterSignature(info));
    }

    public Method lookupSetter(MBeanAttributeInfo info) {
        if (null == info) {
            throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
        }
        return (Method)this.map.get(MethodMapper.setterSignature(info));
    }

    public Method lookupSetter(ModelMBeanAttributeInfo info) {
        if (null == info) {
            throw new IllegalArgumentException("ModelMBeanAttributeInfo cannot be null");
        }
        return (Method)this.map.get(MethodMapper.setterSignature(info));
    }

    public Method lookupMethod(String returnType, String name, String[] signature) {
        if (null == returnType) {
            throw new IllegalArgumentException("returnType cannot be null");
        }
        if (null == name) {
            throw new IllegalArgumentException("method name cannot be null");
        }
        return (Method)this.map.get(MethodMapper.methodSignature(returnType, name, signature));
    }

    public static String getterSignature(MBeanAttributeInfo info) {
        if (null == info) {
            throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
        }
        String prefix = info.isIs() ? "is" : "get";
        return MethodMapper.methodSignature(info.getType(), prefix + info.getName(), null);
    }

    public static String getterSignature(ModelMBeanAttributeInfo info) {
        if (null == info) {
            throw new IllegalArgumentException("ModelMBeanAttributeInfo cannot be null");
        }
        String methodName = (String)info.getDescriptor().getFieldValue("getMethod");
        if (null == methodName) {
            throw new IllegalArgumentException("getMethod not defined in ModelMBeanAttributeInfo descriptor");
        }
        return MethodMapper.methodSignature(info.getType(), methodName, null);
    }

    public static String setterSignature(MBeanAttributeInfo info) {
        if (null == info) {
            throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
        }
        return MethodMapper.methodSignature(Void.TYPE.getName(), "set" + info.getName(), new String[]{info.getType()});
    }

    public static String setterSignature(ModelMBeanAttributeInfo info) {
        if (null == info) {
            throw new IllegalArgumentException("ModelMBeanAttributeInfo cannot be null");
        }
        String methodName = (String)info.getDescriptor().getFieldValue("setMethod");
        if (null == methodName) {
            throw new IllegalArgumentException("setMethod not defined in ModelMBeanAttributeInfo descriptor");
        }
        return MethodMapper.methodSignature(Void.TYPE.getName(), methodName, new String[]{info.getType()});
    }

    public static String operationSignature(MBeanOperationInfo info) {
        if (null == info) {
            throw new IllegalArgumentException("MBeanOperationInfo cannot be null");
        }
        MBeanParameterInfo[] params = info.getSignature();
        String[] signature = new String[params.length];
        int i = 0;
        while (i < signature.length) {
            signature[i] = params[i].getType();
            ++i;
        }
        return MethodMapper.methodSignature(info.getReturnType(), info.getName(), signature);
    }

    public static String methodSignature(Method method) {
        if (null == method) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        Class<?>[] paramtypes = method.getParameterTypes();
        String[] signature = new String[paramtypes.length];
        int i = 0;
        while (i < signature.length) {
            signature[i] = paramtypes[i].getName();
            ++i;
        }
        return MethodMapper.methodSignature(method.getReturnType().getName(), method.getName(), signature);
    }

    public static String methodSignature(String returnType, String name, String[] signature) {
        if (null == returnType) {
            throw new IllegalArgumentException("returnType cannot be null");
        }
        if (null == name) {
            throw new IllegalArgumentException("method name cannot be null");
        }
        StringBuffer buf = new StringBuffer(returnType).append(';').append(name);
        if (null == signature) {
            return buf.toString();
        }
        int i = 0;
        while (i < signature.length) {
            buf.append(';').append(signature[i]);
            ++i;
        }
        return buf.toString();
    }

    protected HashMap createMap(Class resourceClass) {
        HashMap<String, Method> cmap = new HashMap<String, Method>();
        Method[] methods = resourceClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            cmap.put(MethodMapper.methodSignature(methods[i]), methods[i]);
            ++i;
        }
        return cmap;
    }
}

