/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.server;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import org.jboss.mx.interceptor.Interceptor;
import org.jboss.mx.interceptor.Invocation;
import org.jboss.mx.interceptor.InvocationException;
import org.jboss.mx.logging.Logger;

public abstract class MBeanInvoker
implements DynamicMBean {
    protected Interceptor stack = null;
    protected Object resource = null;
    protected Descriptor[] descriptors = null;
    protected MBeanInfo info = null;
    private static final Logger log = Logger.getLogger(class$org$jboss$mx$server$MBeanInvoker == null ? (class$org$jboss$mx$server$MBeanInvoker = MBeanInvoker.class$("org.jboss.mx.server.MBeanInvoker")) : class$org$jboss$mx$server$MBeanInvoker);
    static /* synthetic */ Class class$org$jboss$mx$server$MBeanInvoker;

    public Object getResource() {
        return this.resource;
    }

    public Object invoke(String operationName, Object[] args, String[] signature) throws MBeanException, ReflectionException {
        try {
            Invocation invocation = new Invocation(operationName, 16, 0, args, signature, this.descriptors);
            return this.stack.invoke(invocation);
        }
        catch (InvocationException e) {
            if (e.getTargetException() instanceof MBeanException) {
                throw (MBeanException)e.getTargetException();
            }
            if (e.getTargetException() instanceof ReflectionException) {
                throw (ReflectionException)e.getTargetException();
            }
            throw (RuntimeException)e.getTargetException();
        }
        catch (Throwable t) {
            log.error("SERVER ERROR: " + t.getMessage(), t);
            throw new Error(t.toString());
        }
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            Invocation invocation = new Invocation(attribute, 32, 1, null, null, this.descriptors);
            return this.stack.invoke(invocation);
        }
        catch (InvocationException e) {
            if (e.getTargetException() instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)e.getTargetException();
            }
            if (e.getTargetException() instanceof MBeanException) {
                throw (MBeanException)e.getTargetException();
            }
            if (e.getTargetException() instanceof ReflectionException) {
                throw (ReflectionException)e.getTargetException();
            }
            throw (RuntimeException)e.getTargetException();
        }
        catch (Throwable t) {
            log.error("SERVER ERROR: " + t.getMessage(), t);
            throw new Error(t.toString());
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String attributeClassName = null;
        String attributeName = attribute.getName();
        MBeanAttributeInfo[] attInfos = this.info.getAttributes();
        int i = 0;
        while (i < attInfos.length) {
            if (attInfos[i].getName().equals(attributeName)) {
                attributeClassName = attInfos[i].getType();
                break;
            }
            ++i;
        }
        if (attributeClassName == null) {
            throw new AttributeNotFoundException(attributeName);
        }
        try {
            Invocation invocation = new Invocation(attributeName, 32, 2, new Object[]{attribute.getValue()}, new String[]{attributeClassName}, this.descriptors);
            this.stack.invoke(invocation);
        }
        catch (InvocationException e) {
            if (e.getTargetException() instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)e.getTargetException();
            }
            if (e.getTargetException() instanceof MBeanException) {
                throw (MBeanException)e.getTargetException();
            }
            if (e.getTargetException() instanceof ReflectionException) {
                throw (ReflectionException)e.getTargetException();
            }
            throw (RuntimeException)e.getTargetException();
        }
        catch (Throwable t) {
            log.error("SERVER ERROR: " + t.getMessage(), t);
            throw new Error(t.toString());
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("null array");
        }
        AttributeList list = new AttributeList();
        int i = 0;
        while (i < attributes.length) {
            try {
                list.add(new Attribute(attributes[i], this.getAttribute(attributes[i])));
            }
            catch (JMException ignored) {
                // empty catch block
            }
            ++i;
        }
        return list;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("null list");
        }
        AttributeList results = new AttributeList();
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            try {
                Attribute attr = (Attribute)it.next();
                this.setAttribute(attr);
                results.add(attr);
            }
            catch (JMException ignored) {
                // empty catch block
            }
        }
        return results;
    }

    public abstract MBeanInfo getMBeanInfo();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

