/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class ObjectInputStreamWithClassLoader
extends ObjectInputStream {
    ClassLoader cl;

    public ObjectInputStreamWithClassLoader(InputStream in, ClassLoader cl) throws IOException {
        super(in);
        this.cl = cl;
    }

    protected Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        return this.cl.loadClass(osc.getName());
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] interfacesClass = new Class[interfaces.length];
        int i = 0;
        while (i < interfaces.length) {
            interfacesClass[i] = Class.forName(interfaces[i], false, this.cl);
            ++i;
        }
        return Proxy.getProxyClass(this.cl, interfacesClass);
    }
}

