/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import org.jboss.mx.util.MBeanProxyCreationException;

public class MBeanProxy {
    public static Object get(Class intrface, ObjectName name, String agentID) throws MBeanProxyCreationException {
        return MBeanProxy.get(intrface, name, (MBeanServer)MBeanServerFactory.findMBeanServer(agentID).get(0));
    }

    public static Object get(Class intrface, ObjectName name, MBeanServer server) throws MBeanProxyCreationException {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{intrface}, (InvocationHandler)new JMXInvocationHandler(server, name));
    }

    public static Object create(Class instance, Class intrface, ObjectName name, String agentID) throws MBeanProxyCreationException {
        return MBeanProxy.create(instance, intrface, name, (MBeanServer)MBeanServerFactory.findMBeanServer(agentID).get(0));
    }

    public static Object create(Class instance, Class intrface, ObjectName name, MBeanServer server) throws MBeanProxyCreationException {
        try {
            server.createMBean(instance.getName(), name);
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{intrface}, (InvocationHandler)new JMXInvocationHandler(server, name));
        }
        catch (ReflectionException e) {
            throw new MBeanProxyCreationException("Creating the MBean failed: " + e.toString());
        }
        catch (InstanceAlreadyExistsException e) {
            throw new MBeanProxyCreationException("Instance already exists: " + name);
        }
        catch (MBeanRegistrationException e) {
            throw new MBeanProxyCreationException("Error registering the MBean to the server: " + e.toString());
        }
        catch (MBeanException e) {
            throw new MBeanProxyCreationException(e.toString());
        }
        catch (NotCompliantMBeanException e) {
            throw new MBeanProxyCreationException("Not a compliant MBean " + instance.getClass().getName() + ": " + e.toString());
        }
    }

    private static class JMXInvocationHandler
    implements InvocationHandler {
        private MBeanServer server = null;
        private ObjectName objectName = null;
        private HashMap attributeMap = new HashMap();
        static /* synthetic */ Class class$java$lang$Boolean;

        public JMXInvocationHandler(MBeanServer server, ObjectName name) throws MBeanProxyCreationException {
            try {
                if (server == null) {
                    throw new InstanceNotFoundException("null agent reference");
                }
                this.server = server;
                this.objectName = name;
                MBeanInfo info = server.getMBeanInfo(this.objectName);
                MBeanAttributeInfo[] attributes = info.getAttributes();
                int i = 0;
                while (i < attributes.length) {
                    this.attributeMap.put(attributes[i].getName(), attributes[i]);
                    ++i;
                }
            }
            catch (InstanceNotFoundException e) {
                throw new MBeanProxyCreationException("Object name " + name + " not found: " + e.toString());
            }
            catch (IntrospectionException e) {
                throw new MBeanProxyCreationException(e.toString());
            }
            catch (ReflectionException e) {
                throw new MBeanProxyCreationException(e.toString());
            }
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            try {
                Object retType;
                MBeanAttributeInfo info;
                String attrName;
                String methodName = method.getName();
                if (methodName.startsWith("get") && args == null) {
                    attrName = methodName.substring(3, methodName.length());
                    info = (MBeanAttributeInfo)this.attributeMap.get(attrName);
                    if (info != null && ((String)(retType = method.getReturnType().getName())).equals(info.getType())) {
                        return this.server.getAttribute(this.objectName, attrName);
                    }
                } else if (methodName.startsWith("is") && args == null) {
                    attrName = methodName.substring(2, methodName.length());
                    info = (MBeanAttributeInfo)this.attributeMap.get(attrName);
                    if (info != null && info.isIs() && ((retType = method.getReturnType()).equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JMXInvocationHandler.class$("java.lang.Boolean")) : class$java$lang$Boolean) || retType.equals(Boolean.TYPE))) {
                        return this.server.getAttribute(this.objectName, attrName);
                    }
                } else if (methodName.startsWith("set") && args != null && args.length == 1 && (info = (MBeanAttributeInfo)this.attributeMap.get(attrName = methodName.substring(3, methodName.length()))) != null && method.getReturnType().equals(Void.TYPE) && info.getType().equals(args[0].getClass().getName())) {
                    this.server.setAttribute(this.objectName, new Attribute(attrName, args[0]));
                    return null;
                }
                String[] signature = null;
                if (args != null) {
                    signature = new String[args.length];
                    Class<?>[] sign = method.getParameterTypes();
                    int i = 0;
                    while (i < sign.length) {
                        signature[i] = sign[i].getName();
                        ++i;
                    }
                }
                return this.server.invoke(this.objectName, methodName, args, signature);
            }
            catch (InstanceNotFoundException e) {
                throw new RuntimeException("Instance not found: " + e.toString());
            }
            catch (AttributeNotFoundException e) {
                throw new RuntimeException("Attribute not found: " + e.toString());
            }
            catch (InvalidAttributeValueException e) {
                throw new RuntimeException("Invalid attribute value: " + e.toString());
            }
            catch (MBeanException e) {
                throw e.getTargetException();
            }
            catch (ReflectionException e) {
                Exception target = e.getTargetException();
                if (target instanceof RuntimeException) {
                    throw target;
                }
                throw new RuntimeException(target.toString());
            }
            catch (RuntimeOperationsException e) {
                throw e.getTargetException();
            }
            catch (RuntimeMBeanException e) {
                throw e.getTargetException();
            }
            catch (RuntimeErrorException e) {
                throw e.getTargetError();
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

