/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.util.Iterator;
import java.util.TreeSet;
import org.jboss.mx.util.SchedulableRunnable;
import org.jboss.mx.util.ThreadPool;

public class RunnableScheduler
implements Runnable {
    private TreeSet runnables = new TreeSet();
    private ThreadPool threadPool;
    private Thread controller = null;

    public synchronized void start() {
        if (this.controller != null) {
            return;
        }
        this.controller = new Thread(this);
        this.controller.start();
    }

    public synchronized void stop() {
        if (this.controller == null) {
            return;
        }
        this.controller.interrupt();
        this.controller = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.threadPool = new ThreadPool();
        this.threadPool.setActive(true);
        try {
            try {
                while (true) {
                    this.runOutstanding();
                    this.waitOutstanding();
                }
            }
            catch (InterruptedException weAreDone) {
                Object var3_2 = null;
                this.threadPool.setActive(false);
                this.threadPool = null;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.threadPool.setActive(false);
            this.threadPool = null;
            throw throwable;
        }
    }

    synchronized void add(SchedulableRunnable runnable) {
        this.runnables.add(runnable);
        this.notifyAll();
    }

    synchronized void remove(SchedulableRunnable runnable) {
        this.runnables.remove(runnable);
    }

    synchronized boolean contains(SchedulableRunnable runnable) {
        return this.runnables.contains(runnable);
    }

    private synchronized void runOutstanding() {
        long current = System.currentTimeMillis();
        Iterator iterator = this.runnables.iterator();
        while (iterator.hasNext()) {
            SchedulableRunnable next = (SchedulableRunnable)iterator.next();
            if (next.getNextRun() > current) break;
            iterator.remove();
            this.threadPool.run(next);
        }
    }

    private synchronized void waitOutstanding() throws InterruptedException {
        if (this.runnables.size() == 0) {
            this.wait();
        } else {
            SchedulableRunnable next = (SchedulableRunnable)this.runnables.first();
            long wait = next.getNextRun() - System.currentTimeMillis();
            if (wait > 0L) {
                this.wait(wait);
            }
        }
    }
}

