/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.BooleanValueExp;
import javax.management.InvalidApplicationException;
import javax.management.NumberValueExp;
import javax.management.ObjectName;
import javax.management.StringValueExp;
import javax.management.ValueExp;
import javax.management.ValueExpSupport;

public class AttributeValueExp
extends ValueExpSupport {
    private static final long serialVersionUID = -7768025046539163385L;
    private String attr;

    public AttributeValueExp() {
    }

    public AttributeValueExp(String attr) {
        this.attr = attr;
    }

    public String getAttributeName() {
        return this.attr;
    }

    public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        Object object = this.getAttribute(name);
        if (object instanceof String) {
            return new StringValueExp((String)object);
        }
        if (object instanceof Boolean) {
            return new BooleanValueExp((Boolean)object);
        }
        if (object instanceof Number) {
            return new NumberValueExp((Number)object);
        }
        throw new BadAttributeValueExpException(object);
    }

    public String toString() {
        return this.attr;
    }

    protected Object getAttribute(ObjectName name) {
        try {
            return this.getMBeanServer().getAttribute(name, this.attr);
        }
        catch (Exception e) {
            return null;
        }
    }
}

