/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;

public class MBeanConstructorInfo
extends MBeanFeatureInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4433990064191844427L;
    protected MBeanParameterInfo[] signature = null;

    public MBeanConstructorInfo(String description, Constructor constructor) {
        super(constructor.getName(), description);
        Class<?>[] sign = constructor.getParameterTypes();
        this.signature = new MBeanParameterInfo[sign.length];
        int i = 0;
        while (i < sign.length) {
            String name = sign[i].getName();
            this.signature[i] = new MBeanParameterInfo(name, name, "MBean Constructor Parameter.");
            ++i;
        }
    }

    public MBeanConstructorInfo(String name, String description, MBeanParameterInfo[] signature) {
        super(name, description);
        this.signature = null == signature ? new MBeanParameterInfo[]{} : (MBeanParameterInfo[])signature.clone();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(this.getClass().getName()).append(":");
        buffer.append(" name=").append(this.getName());
        buffer.append(" description=").append(this.getDescription());
        buffer.append(" signature=").append(Arrays.asList(this.signature));
        return buffer.toString();
    }

    public MBeanParameterInfo[] getSignature() {
        return (MBeanParameterInfo[])this.signature.clone();
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        MBeanConstructorInfo clone = (MBeanConstructorInfo)super.clone();
        clone.signature = (MBeanParameterInfo[])this.signature.clone();
        return clone;
    }
}

