/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.management.JMRuntimeException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;

public class MBeanOperationInfo
extends MBeanFeatureInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6178860474881375330L;
    public static final int INFO = 0;
    public static final int ACTION = 1;
    public static final int ACTION_INFO = 2;
    public static final int UNKNOWN = 3;
    private int impact = 3;
    private MBeanParameterInfo[] signature = null;
    private String type = null;

    public MBeanOperationInfo(String description, Method method) {
        super(method.getName(), description);
        this.type = method.getReturnType().getName();
        Class<?>[] sign = method.getParameterTypes();
        this.signature = new MBeanParameterInfo[sign.length];
        int i = 0;
        while (i < sign.length) {
            String name = sign[i].getName();
            this.signature[i] = new MBeanParameterInfo(name, name, "MBean Operation Parameter.");
            ++i;
        }
    }

    public MBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String returnType, int impact) {
        super(name, description);
        this.signature = null == signature ? new MBeanParameterInfo[]{} : (MBeanParameterInfo[])signature.clone();
        this.type = returnType;
        this.impact = impact;
    }

    public String getReturnType() {
        return this.type;
    }

    public MBeanParameterInfo[] getSignature() {
        return (MBeanParameterInfo[])this.signature.clone();
    }

    public int getImpact() {
        if (this.impact != 1 && this.impact != 0 && this.impact != 2 && this.impact != 3) {
            throw new JMRuntimeException("Invalid impact value (" + this.impact + "). The impact must be either ACTION, INFO, ACTION_INFO or UNKNOWN.");
        }
        return this.impact;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(this.getClass().getName()).append(":");
        buffer.append(" name=").append(this.getName());
        buffer.append(" description=").append(this.getDescription());
        buffer.append(" signature=").append(Arrays.asList(this.signature));
        buffer.append(" returnType=").append(this.getReturnType());
        buffer.append(" impact=");
        switch (this.impact) {
            case 1: {
                buffer.append("ACTION");
                break;
            }
            case 2: {
                buffer.append("ACTION_INFO");
                break;
            }
            case 0: {
                buffer.append("INFO");
                break;
            }
            default: {
                buffer.append("UNKNOWN");
            }
        }
        return buffer.toString();
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        MBeanOperationInfo clone = (MBeanOperationInfo)super.clone();
        clone.signature = (MBeanParameterInfo[])this.signature.clone();
        clone.type = this.type;
        clone.impact = this.impact;
        return clone;
    }
}

