/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.monitor.CounterMonitorMBean;
import javax.management.monitor.Monitor;

public class CounterMonitor
extends Monitor
implements CounterMonitorMBean {
    int THRESHOLD_EXCEEDED_NOTIFIED = 16;
    int THRESHOLD_ERROR_NOTIFIED = 32;
    private Number derivedGauge = new Integer(0);
    private Number lastValue = null;
    private long derivedGaugeTimeStamp = 0L;
    Number offset = new Integer(0);
    Number modulus = new Integer(0);
    Number threshold = new Integer(0);
    Number initialThreshold = new Integer(0);
    boolean differenceMode = false;
    boolean notify = false;

    public CounterMonitor() {
        this.dbgTag = "CounterMonitor";
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] result = new MBeanNotificationInfo[1];
        String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.counter.threshold"};
        result[0] = new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the Counter Monitor Service MBean");
        return result;
    }

    public Number getDerivedGauge() {
        return this.derivedGauge;
    }

    public long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimeStamp;
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public void setDifferenceMode(boolean value) {
        this.differenceMode = value;
    }

    public Number getModulus() {
        return this.modulus;
    }

    public void setModulus(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null modulus");
        }
        if (value.longValue() < 0L) {
            throw new IllegalArgumentException("Negative modulus");
        }
        this.modulus = value;
        this.alreadyNotified = 0;
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean value) {
        this.notify = value;
    }

    public Number getOffset() {
        return this.offset;
    }

    public void setOffset(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null offset");
        }
        if (value.longValue() < 0L) {
            throw new IllegalArgumentException("Negative offset");
        }
        this.offset = value;
        this.alreadyNotified = 0;
    }

    public Number getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null threshold");
        }
        if (value.longValue() < 0L) {
            throw new IllegalArgumentException("Negative threshold");
        }
        this.threshold = value;
        this.initialThreshold = value;
        this.alreadyNotified = 0;
    }

    public synchronized void start() {
        this.lastValue = null;
        this.derivedGauge = new Integer(0);
        this.derivedGaugeTimeStamp = System.currentTimeMillis();
        super.start();
    }

    void monitor(MBeanAttributeInfo attributeInfo, Object value) throws Exception {
        if (!(value instanceof Byte || value instanceof Integer || value instanceof Short || value instanceof Long)) {
            this.sendAttributeTypeErrorNotification("Attribute is not an integer type");
            return;
        }
        if (this.threshold.getClass() != value.getClass() || this.offset.longValue() != 0L && this.offset.getClass() != value.getClass() || this.modulus.longValue() != 0L && this.modulus.getClass() != value.getClass()) {
            this.sendThresholdErrorNotification(value);
            return;
        }
        Number number = (Number)value;
        if (this.differenceMode) {
            this.derivedGauge = this.lastValue == null ? (Number)this.getZero(number) : (Number)this.sub(number, this.lastValue);
            if (this.derivedGauge.longValue() < 0L && this.modulus.longValue() != 0L) {
                this.derivedGauge = this.add(this.derivedGauge, this.modulus);
            }
        } else {
            this.derivedGauge = number;
        }
        this.derivedGaugeTimeStamp = System.currentTimeMillis();
        if (this.derivedGauge.longValue() >= this.threshold.longValue()) {
            if ((this.alreadyNotified & this.THRESHOLD_EXCEEDED_NOTIFIED) == 0) {
                this.sendThresholdExceededNotification(this.derivedGauge);
                this.alreadyNotified |= this.THRESHOLD_EXCEEDED_NOTIFIED;
                if (this.offset.longValue() != 0L) {
                    while (this.threshold.longValue() <= this.derivedGauge.longValue()) {
                        this.threshold = this.add(this.threshold, this.offset);
                    }
                    this.alreadyNotified &= ~this.THRESHOLD_EXCEEDED_NOTIFIED;
                }
            }
        } else if (this.derivedGauge.longValue() < this.threshold.longValue() && this.offset.longValue() == 0L) {
            this.alreadyNotified &= ~this.THRESHOLD_EXCEEDED_NOTIFIED;
        }
        if (this.differenceMode && this.lastValue != null && this.lastValue.longValue() > number.longValue()) {
            this.threshold = this.initialThreshold;
            this.alreadyNotified &= ~this.THRESHOLD_EXCEEDED_NOTIFIED;
        }
        if (!this.differenceMode && this.modulus.longValue() != 0L && number.longValue() >= this.modulus.longValue()) {
            this.threshold = this.initialThreshold;
            this.alreadyNotified &= ~this.THRESHOLD_EXCEEDED_NOTIFIED;
        }
        this.lastValue = number;
    }

    Number getZero(Number value) {
        if (value instanceof Byte) {
            return new Byte(0);
        }
        if (value instanceof Integer) {
            return new Integer(0);
        }
        if (value instanceof Short) {
            return new Short(0);
        }
        return new Long(0L);
    }

    Number add(Number value1, Number value2) {
        if (value1 instanceof Byte) {
            return new Byte((byte)(value1.byteValue() + value2.byteValue()));
        }
        if (value1 instanceof Integer) {
            return new Integer(value1.intValue() + value2.intValue());
        }
        if (value1 instanceof Short) {
            return new Short((short)(value1.shortValue() + value2.shortValue()));
        }
        return new Long(value1.longValue() + value2.longValue());
    }

    Number sub(Number value1, Number value2) {
        if (value1 instanceof Byte) {
            return new Byte((byte)(value1.byteValue() - value2.byteValue()));
        }
        if (value1 instanceof Integer) {
            return new Integer(value1.intValue() - value2.intValue());
        }
        if (value1 instanceof Short) {
            return new Short((short)(value1.shortValue() - value2.shortValue()));
        }
        return new Long(value1.longValue() - value2.longValue());
    }

    void sendThresholdExceededNotification(Object value) {
        if (this.notify) {
            this.sendNotification("jmx.monitor.counter.threshold", this.derivedGaugeTimeStamp, "threshold exceeded", this.observedAttribute, value, this.threshold);
        }
    }

    void sendThresholdErrorNotification(Object value) {
        if ((this.alreadyNotified & this.THRESHOLD_ERROR_NOTIFIED) == 0) {
            this.sendNotification("jmx.monitor.error.threshold", this.derivedGaugeTimeStamp, "Threshold, offset or modulus not the correct type", this.observedAttribute, null, null);
            this.alreadyNotified |= this.THRESHOLD_ERROR_NOTIFIED;
        }
    }
}

