/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.io.Serializable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.MonitorNotification;
import org.jboss.mx.util.RunnableScheduler;
import org.jboss.mx.util.SchedulableRunnable;

public abstract class Monitor
extends NotificationBroadcasterSupport
implements MonitorMBean,
MBeanRegistration,
Serializable {
    protected final int RESET_FLAGS_ALREADY_NOTIFIED = 0;
    protected final int RUNTIME_ERROR_NOTIFIED = 1;
    protected final int OBSERVED_OBJECT_ERROR_NOTIFIED = 2;
    protected final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 4;
    protected final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 8;
    long granularityPeriod = 10000L;
    String observedAttribute = null;
    ObjectName observedObject = null;
    boolean active = false;
    protected MBeanServer server;
    ObjectName objectName;
    protected int alreadyNotified = 0;
    protected String dbgTag = null;
    private MonitorRunnable monitorRunnable;
    private long sequenceNumber;
    static RunnableScheduler scheduler = new RunnableScheduler();

    public long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    public String getObservedAttribute() {
        return this.observedAttribute;
    }

    public ObjectName getObservedObject() {
        return this.observedObject;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setGranularityPeriod(long period) throws IllegalArgumentException {
        if (period <= 0L) {
            throw new IllegalArgumentException("Period must be positive.");
        }
        this.granularityPeriod = period;
    }

    public void setObservedAttribute(String attribute) {
        this.observedAttribute = attribute;
        this.alreadyNotified = 0;
    }

    public void setObservedObject(ObjectName object) {
        this.observedObject = object;
        this.alreadyNotified = 0;
    }

    public synchronized void start() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.monitorRunnable = new MonitorRunnable(this);
    }

    public synchronized void stop() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.monitorRunnable.setScheduler(null);
        this.monitorRunnable = null;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName objectName) throws Exception {
        this.server = server;
        this.objectName = objectName;
        return objectName;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public void postDeregister() {
    }

    void runMonitor() {
        try {
            MBeanInfo mbeanInfo = null;
            try {
                mbeanInfo = this.server.getMBeanInfo(this.observedObject);
            }
            catch (InstanceNotFoundException e) {
                this.sendObjectErrorNotification("The observed object is not registered.");
                return;
            }
            MBeanAttributeInfo[] mbeanAttributeInfo = mbeanInfo.getAttributes();
            MBeanAttributeInfo attributeInfo = null;
            int i = 0;
            while (i < mbeanAttributeInfo.length) {
                if (mbeanAttributeInfo[i].getName().equals(this.observedAttribute)) {
                    attributeInfo = mbeanAttributeInfo[i];
                    break;
                }
                ++i;
            }
            if (attributeInfo == null) {
                this.sendAttributeErrorNotification("The observed attribute does not exist");
                return;
            }
            if (!attributeInfo.isReadable()) {
                this.sendAttributeErrorNotification("Attribute not readable.");
                return;
            }
            Object value = null;
            try {
                value = this.server.getAttribute(this.observedObject, this.observedAttribute);
            }
            catch (InstanceNotFoundException e) {
                this.sendObjectErrorNotification("The observed object is not registered.");
                return;
            }
            if (value == null) {
                this.sendAttributeTypeErrorNotification("Attribute is null");
                return;
            }
            this.monitor(attributeInfo, value);
        }
        catch (Exception e) {
            this.sendRuntimeErrorNotification("General error: " + e.toString());
        }
    }

    abstract void monitor(MBeanAttributeInfo var1, Object var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNotification(String type, long timestamp, String message, String attribute, Object gauge, Object trigger) {
        long seq = 0L;
        Monitor monitor = this;
        synchronized (monitor) {
            seq = ++this.sequenceNumber;
        }
        if (timestamp == 0L) {
            timestamp = System.currentTimeMillis();
        }
        this.sendNotification(new MonitorNotification(type, this.objectName, seq, timestamp, message, gauge, attribute, this.observedObject, trigger));
    }

    void sendRuntimeErrorNotification(String message) {
        if ((this.alreadyNotified & 1) == 0) {
            this.sendNotification("jmx.monitor.error.runtime", 0L, message, this.observedAttribute, null, null);
        }
        this.alreadyNotified |= 1;
    }

    void sendObjectErrorNotification(String message) {
        if ((this.alreadyNotified & 2) == 0) {
            this.sendNotification("jmx.monitor.error.mbean", 0L, message, this.observedAttribute, null, null);
        }
        this.alreadyNotified |= 2;
    }

    void sendAttributeErrorNotification(String message) {
        if ((this.alreadyNotified & 4) == 0) {
            this.sendNotification("jmx.monitor.error.attribute", 0L, message, this.observedAttribute, null, null);
        }
        this.alreadyNotified |= 4;
    }

    void sendAttributeTypeErrorNotification(String message) {
        if ((this.alreadyNotified & 8) == 0) {
            this.sendNotification("jmx.monitor.error.type", 0L, message, this.observedAttribute, null, null);
        }
        this.alreadyNotified |= 8;
    }

    static {
        scheduler.start();
    }

    private class MonitorRunnable
    extends SchedulableRunnable {
        private Monitor monitor;

        public MonitorRunnable(Monitor monitor) {
            this.monitor = monitor;
            this.setScheduler(scheduler);
        }

        public void doRun() {
            this.monitor.runMonitor();
            this.setNextRun(System.currentTimeMillis() + this.monitor.granularityPeriod);
        }
    }
}

