/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class CompositeType
extends OpenType {
    private TreeMap nameToDescription;
    private TreeMap nameToType;
    private transient int cachedHashCode = 0;
    private transient String cachedToString = null;
    private static final long serialVersionUID = -5366242454346948798L;
    static /* synthetic */ Class class$javax$management$openmbean$CompositeData;

    public CompositeType(String typeName, String description, String[] itemNames, String[] itemDescriptions, OpenType[] itemTypes) throws OpenDataException {
        super((class$javax$management$openmbean$CompositeData == null ? (class$javax$management$openmbean$CompositeData = CompositeType.class$("javax.management.openmbean.CompositeData")) : class$javax$management$openmbean$CompositeData).getName(), typeName, description);
        if (itemNames == null) {
            throw new IllegalArgumentException("null itemNames");
        }
        if (itemDescriptions == null) {
            throw new IllegalArgumentException("null itemDescriptions");
        }
        if (itemTypes == null) {
            throw new IllegalArgumentException("null itemTypes");
        }
        if (itemNames.length != itemDescriptions.length) {
            throw new IllegalArgumentException("wrong number of itemDescriptions");
        }
        if (itemNames.length != itemTypes.length) {
            throw new IllegalArgumentException("wrong number of itemTypes");
        }
        this.nameToDescription = new TreeMap();
        this.nameToType = new TreeMap();
        int i = 0;
        while (i < itemNames.length) {
            if (itemNames[i] == null) {
                throw new IllegalArgumentException("null item name " + i);
            }
            String itemName = itemNames[i].trim();
            if (itemName.length() == 0) {
                throw new IllegalArgumentException("empty item name " + i);
            }
            if (this.nameToDescription.containsKey(itemName)) {
                throw new OpenDataException("duplicate item name " + itemName);
            }
            if (itemDescriptions[i] == null) {
                throw new IllegalArgumentException("null item description " + i);
            }
            String itemDescription = itemDescriptions[i].trim();
            if (itemDescription.length() == 0) {
                throw new IllegalArgumentException("empty item description " + i);
            }
            if (itemTypes[i] == null) {
                throw new IllegalArgumentException("null item type " + i);
            }
            this.nameToDescription.put(itemName, itemDescription);
            this.nameToType.put(itemName, itemTypes[i]);
            ++i;
        }
    }

    public boolean containsKey(String itemName) {
        if (itemName == null || itemName.length() == 0) {
            return false;
        }
        return this.nameToDescription.containsKey(itemName);
    }

    public String getDescription(String itemName) {
        return (String)this.nameToDescription.get(itemName);
    }

    public OpenType getType(String itemName) {
        return (OpenType)this.nameToType.get(itemName);
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.nameToDescription.keySet());
    }

    public boolean isValue(Object obj) {
        if (obj == null || !(obj instanceof CompositeData)) {
            return false;
        }
        return this.equals(((CompositeData)obj).getCompositeType());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CompositeType)) {
            return false;
        }
        CompositeType other = (CompositeType)obj;
        if (!this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        Iterator thisNames = this.keySet().iterator();
        Iterator otherNames = other.keySet().iterator();
        while (thisNames.hasNext() && otherNames.hasNext()) {
            String otherName;
            String thisName = (String)thisNames.next();
            if (!thisName.equals(otherName = (String)otherNames.next())) {
                return false;
            }
            if (this.getType(thisName).equals(other.getType(otherName))) continue;
            return false;
        }
        return !thisNames.hasNext() && !otherNames.hasNext();
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        this.cachedHashCode = this.getTypeName().hashCode();
        Iterator i = this.nameToType.values().iterator();
        while (i.hasNext()) {
            this.cachedHashCode += i.next().hashCode();
        }
        Iterator i2 = this.nameToDescription.keySet().iterator();
        while (i2.hasNext()) {
            this.cachedHashCode += i2.next().hashCode();
        }
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append("\n");
        Iterator thisNames = this.keySet().iterator();
        while (thisNames.hasNext()) {
            String thisName = (String)thisNames.next();
            buffer.append("name=");
            buffer.append(thisName);
            buffer.append(" type=");
            buffer.append(this.getType(thisName));
            if (!thisNames.hasNext()) continue;
            buffer.append("\n");
        }
        this.cachedToString = buffer.toString();
        return this.cachedToString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

