/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Arrays;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanInfo;
import javax.management.openmbean.OpenMBeanOperationInfo;

public class OpenMBeanInfoSupport
extends MBeanInfo
implements OpenMBeanInfo,
Serializable {
    private static final long serialVersionUID = 4349395935420511492L;
    private transient int cachedHashCode;
    private transient String cachedToString;

    private static MBeanAttributeInfo[] convertArray(OpenMBeanAttributeInfo[] array) {
        if (array == null) {
            return null;
        }
        MBeanAttributeInfo[] result = new MBeanAttributeInfo[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    private static MBeanConstructorInfo[] convertArray(OpenMBeanConstructorInfo[] array) {
        if (array == null) {
            return null;
        }
        MBeanConstructorInfo[] result = new MBeanConstructorInfo[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    private static MBeanOperationInfo[] convertArray(OpenMBeanOperationInfo[] array) {
        if (array == null) {
            return null;
        }
        MBeanOperationInfo[] result = new MBeanOperationInfo[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public OpenMBeanInfoSupport(String className, String description, OpenMBeanAttributeInfo[] attributes, OpenMBeanConstructorInfo[] constructors, OpenMBeanOperationInfo[] operations, MBeanNotificationInfo[] notifications) {
        super(className, description, OpenMBeanInfoSupport.convertArray(attributes), OpenMBeanInfoSupport.convertArray(constructors), OpenMBeanInfoSupport.convertArray(operations), notifications);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof OpenMBeanInfoSupport)) {
            return false;
        }
        OpenMBeanInfo other = (OpenMBeanInfo)obj;
        if (!this.getClassName().equals(other.getClassName())) {
            return false;
        }
        if (!this.compareArray(this.getAttributes(), other.getAttributes())) {
            return false;
        }
        if (!this.compareArray(this.getConstructors(), other.getConstructors())) {
            return false;
        }
        if (!this.compareArray(this.getNotifications(), other.getNotifications())) {
            return false;
        }
        return this.compareArray(this.getOperations(), other.getOperations());
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        this.cachedHashCode = this.getClassName().hashCode();
        int i = 0;
        while (i < this.attributes.length) {
            this.cachedHashCode += this.attributes[i].hashCode();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.constructors.length) {
            this.cachedHashCode += this.constructors[i2].hashCode();
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.notifications.length) {
            this.cachedHashCode += this.notifications[i3].hashCode();
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.operations.length) {
            this.cachedHashCode += this.operations[i4].hashCode();
            ++i4;
        }
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append(": className=");
        buffer.append(this.getClassName());
        buffer.append(", attributes=");
        buffer.append(Arrays.asList(this.attributes));
        buffer.append(", constructors=");
        buffer.append(Arrays.asList(this.constructors));
        buffer.append(", notifications=");
        buffer.append(Arrays.asList(this.notifications));
        buffer.append(", operations=");
        buffer.append(Arrays.asList(this.operations));
        this.cachedToString = buffer.toString();
        return this.cachedToString;
    }

    private boolean compareArray(Object[] one, Object[] two) {
        if (one.length != two.length) {
            return false;
        }
        return Arrays.asList(one).containsAll(Arrays.asList(two));
    }
}

