/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Arrays;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;

public class OpenMBeanOperationInfoSupport
extends MBeanOperationInfo
implements OpenMBeanOperationInfo,
Serializable {
    private static final long serialVersionUID = 4996859732565369366L;
    private OpenType returnOpenType;
    private transient int cachedHashCode;
    private transient String cachedToString;

    private static MBeanParameterInfo[] convertArray(OpenMBeanParameterInfo[] array) {
        if (array == null) {
            return null;
        }
        MBeanParameterInfo[] result = new MBeanParameterInfo[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public OpenMBeanOperationInfoSupport(String name, String description, OpenMBeanParameterInfo[] signature, OpenType returnOpenType, int impact) {
        super(name, description, OpenMBeanOperationInfoSupport.convertArray(signature), returnOpenType == null ? null : returnOpenType.getClassName(), impact);
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("empty name");
        }
        if (description == null) {
            throw new IllegalArgumentException("null description");
        }
        if (description.trim().length() == 0) {
            throw new IllegalArgumentException("empty description");
        }
        if (returnOpenType == null) {
            throw new IllegalArgumentException("null return open type");
        }
        if (impact != 1 && impact != 2 && impact != 0) {
            throw new IllegalArgumentException("Invalid action");
        }
        this.returnOpenType = returnOpenType;
    }

    public OpenType getReturnOpenType() {
        return this.returnOpenType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof OpenMBeanOperationInfoSupport)) {
            return false;
        }
        OpenMBeanOperationInfo other = (OpenMBeanOperationInfo)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getReturnOpenType().equals(other.getReturnOpenType())) {
            return false;
        }
        if (!Arrays.asList(this.getSignature()).equals(Arrays.asList(other.getSignature()))) {
            return false;
        }
        return this.getImpact() == other.getImpact();
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        this.cachedHashCode = this.getName().hashCode();
        this.cachedHashCode += this.getReturnOpenType().hashCode();
        this.cachedHashCode += Arrays.asList(this.getSignature()).hashCode();
        this.cachedHashCode += this.getImpact();
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append(": name=");
        buffer.append(this.getName());
        buffer.append(", returnOpenType=");
        buffer.append(this.getReturnOpenType());
        buffer.append(", signature=");
        buffer.append(Arrays.asList(this.getSignature()));
        buffer.append(", impact=");
        switch (this.getImpact()) {
            case 1: {
                buffer.append("ACTION");
                break;
            }
            case 2: {
                buffer.append("ACTION_INFO");
                break;
            }
            case 0: {
                buffer.append("INFO");
                break;
            }
            default: {
                buffer.append("UNKNOWN");
            }
        }
        this.cachedToString = buffer.toString();
        return this.cachedToString;
    }
}

