/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationServiceMBean;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupportMBean;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.Role;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;
import javax.management.relation.RoleUnresolved;
import javax.management.relation.RoleUnresolvedList;
import javax.management.relation.RoleValidator;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;

public class RelationSupport
implements RelationSupportMBean,
MBeanRegistration {
    String relationId;
    ObjectName relationService;
    private RelationServiceMBean serviceProxy;
    MBeanServer server;
    String relationTypeName;
    HashMap roles;
    Boolean registered;
    static /* synthetic */ Class class$javax$management$relation$RelationServiceMBean;

    public RelationSupport(String relationId, ObjectName relationService, String relationTypeName, RoleList roleList) throws IllegalArgumentException, InvalidRoleValueException {
        this.init(relationId, relationService, null, relationTypeName, roleList);
    }

    public RelationSupport(String relationId, ObjectName relationService, MBeanServer mbeanServer, String relationTypeName, RoleList roleList) throws IllegalArgumentException, InvalidRoleValueException {
        this.init(relationId, relationService, mbeanServer, relationTypeName, roleList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleResult getAllRoles() throws RelationServiceNotRegisteredException {
        RoleList resolvedResult = new RoleList();
        RoleUnresolvedList unresolvedResult = new RoleUnresolvedList();
        RoleResult result = new RoleResult(resolvedResult, unresolvedResult);
        HashMap hashMap = this.roles;
        synchronized (hashMap) {
            Iterator iterator = this.roles.values().iterator();
            while (iterator.hasNext()) {
                Role role = (Role)iterator.next();
                int status = this.checkRoleReadable(role);
                if (status == 0) {
                    resolvedResult.add(role);
                    continue;
                }
                unresolvedResult.add(new RoleUnresolved(role.getRoleName(), role.getRoleValue(), status));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getReferencedMBeans() {
        HashMap<ObjectName, ArrayList<String>> result = new HashMap<ObjectName, ArrayList<String>>();
        HashMap hashMap = this.roles;
        synchronized (hashMap) {
            Iterator iterator = this.roles.values().iterator();
            while (iterator.hasNext()) {
                Role role = (Role)iterator.next();
                String roleName = role.getRoleName();
                ArrayList mbeans = (ArrayList)role.getRoleValue();
                Iterator mbeanIterator = mbeans.iterator();
                while (mbeanIterator.hasNext()) {
                    ObjectName mbean = (ObjectName)mbeanIterator.next();
                    ArrayList<String> resultRoles = (ArrayList<String>)result.get(mbean);
                    if (resultRoles == null) {
                        resultRoles = new ArrayList<String>();
                        result.put(mbean, resultRoles);
                    }
                    resultRoles.add(roleName);
                }
            }
        }
        return result;
    }

    public String getRelationId() {
        return this.relationId;
    }

    public ObjectName getRelationServiceName() {
        return this.relationService;
    }

    public String getRelationTypeName() {
        return this.relationTypeName;
    }

    public List getRole(String roleName) throws IllegalArgumentException, RoleNotFoundException, RelationServiceNotRegisteredException {
        if (roleName == null) {
            throw new IllegalArgumentException("null role name");
        }
        this.validateRoleReadable(roleName);
        Role role = this.validateRoleFound(roleName);
        return role.getRoleValue();
    }

    public Integer getRoleCardinality(String roleName) throws IllegalArgumentException, RoleNotFoundException {
        if (roleName == null) {
            throw new IllegalArgumentException("null role name");
        }
        Role role = this.validateRoleFound(roleName);
        return new Integer(role.getRoleValue().size());
    }

    public RoleResult getRoles(String[] roleNames) throws IllegalArgumentException, RelationServiceNotRegisteredException {
        RoleList resolvedResult = new RoleList();
        RoleUnresolvedList unresolvedResult = new RoleUnresolvedList();
        RoleResult result = new RoleResult(resolvedResult, unresolvedResult);
        int i = 0;
        while (i < roleNames.length) {
            Role role = (Role)this.roles.get(roleNames[i]);
            int status = this.checkRoleReadable(role);
            if (status == 0) {
                resolvedResult.add(role);
            } else {
                unresolvedResult.add(new RoleUnresolved(role.getRoleName(), role.getRoleValue(), status));
            }
            ++i;
        }
        return result;
    }

    public void handleMBeanUnregistration(ObjectName objectName, String roleName) throws RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        this.checkRegistered();
        Role role = this.validateRoleFound(roleName);
        ArrayList values = (ArrayList)role.getRoleValue();
        ArrayList oldRoleValue = new ArrayList(values);
        if (!values.remove(objectName)) {
            throw new InvalidRoleValueException(roleName + " " + objectName.toString());
        }
        this.updateRole(role, oldRoleValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleList retrieveAllRoles() {
        RoleList result = new RoleList(this.roles.size());
        HashMap hashMap = this.roles;
        synchronized (hashMap) {
            Iterator iterator = this.roles.values().iterator();
            while (iterator.hasNext()) {
                result.add((Role)iterator.next());
            }
        }
        return result;
    }

    public void setRole(Role role) throws IllegalArgumentException, InvalidRoleValueException, RoleNotFoundException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (role == null) {
            throw new IllegalArgumentException("null role");
        }
        Role copy = (Role)role.clone();
        this.checkRegistered();
        RoleValidator.validateRole(this.relationService, this.server, this.relationTypeName, copy, true);
        Role oldRole = (Role)this.roles.get(role.getRoleName());
        ArrayList oldRoleValue = (ArrayList)oldRole.getRoleValue();
        this.updateRole(copy, oldRoleValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleResult setRoles(RoleList roleList) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (roleList == null) {
            throw new IllegalArgumentException("null role list");
        }
        RoleList copy = new RoleList(roleList);
        this.checkRegistered();
        RoleResult result = RoleValidator.checkRoles(this.relationService, this.server, this.relationTypeName, copy, true);
        RoleList roleList2 = result.getRoles();
        synchronized (roleList2) {
            Iterator iterator = result.getRoles().iterator();
            while (iterator.hasNext()) {
                Role role = (Role)iterator.next();
                Role oldRole = (Role)this.roles.get(role.getRoleName());
                ArrayList oldRoleValue = (ArrayList)oldRole.getRoleValue();
                this.updateRole(role, oldRoleValue);
            }
        }
        return result;
    }

    public Boolean isInRelationService() {
        return this.registered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelationServiceManagementFlag(Boolean value) {
        Boolean bl = this.registered;
        synchronized (bl) {
            this.registered = new Boolean(value);
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName objectName) throws Exception {
        this.server = server;
        return objectName;
    }

    public void postRegister(Boolean registered) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.server = null;
    }

    private void init(String relationId, ObjectName relationService, MBeanServer mbeanServer, String relationTypeName, RoleList roleList) throws IllegalArgumentException, InvalidRoleValueException {
        if (relationId == null) {
            throw new IllegalArgumentException("null relation id");
        }
        if (relationService == null) {
            throw new IllegalArgumentException("null relation service");
        }
        if (relationTypeName == null) {
            throw new IllegalArgumentException("null relation type name");
        }
        this.relationId = relationId;
        this.relationTypeName = relationTypeName;
        this.relationService = relationService;
        if (mbeanServer != null) {
            this.server = mbeanServer;
        }
        this.registered = new Boolean(false);
        if (roleList == null) {
            this.roles = new HashMap();
        } else {
            Object[] roleArray = roleList.toArray();
            this.roles = new HashMap(roleArray.length);
            int i = 0;
            while (i < roleArray.length) {
                Role role = (Role)roleArray[i];
                if (this.roles.containsKey(role.getRoleName())) {
                    throw new IllegalArgumentException("duplicate role name");
                }
                this.roles.put(role.getRoleName(), role);
                ++i;
            }
        }
    }

    private void checkRegistered() throws RelationNotFoundException {
        if (!this.isInRelationService().booleanValue()) {
            throw new RelationNotFoundException("not registered with relation service");
        }
    }

    private int checkRoleReadable(Role role) throws RelationServiceNotRegisteredException {
        this.checkServiceProxy();
        try {
            return this.serviceProxy.checkRoleReading(role.getRoleName(), this.relationTypeName);
        }
        catch (RelationTypeNotFoundException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private int checkRoleWritable(Role role, boolean initFlag) throws RelationServiceNotRegisteredException, RelationTypeNotFoundException {
        this.checkServiceProxy();
        try {
            return this.serviceProxy.checkRoleWriting(role, this.relationTypeName, new Boolean(initFlag));
        }
        catch (RelationTypeNotFoundException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void updateRole(Role role, ArrayList oldRoleValue) {
        this.roles.put(role.getRoleName(), role);
        try {
            this.checkServiceProxy();
            this.serviceProxy.updateRoleMap(this.relationId, role, oldRoleValue);
            this.serviceProxy.sendRoleUpdateNotification(this.relationId, role, oldRoleValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    private Role validateRoleFound(String roleName) throws RoleNotFoundException {
        Role result = (Role)this.roles.get(roleName);
        if (result == null) {
            throw new RoleNotFoundException(roleName);
        }
        return result;
    }

    private void validateRoleReadable(String roleName) throws RoleNotFoundException, RelationServiceNotRegisteredException {
        int status = 0;
        this.checkServiceProxy();
        try {
            status = this.serviceProxy.checkRoleReading(roleName, this.relationTypeName);
        }
        catch (RelationTypeNotFoundException e) {
            throw new RuntimeException(e.toString());
        }
        if (status == 3) {
            throw new RoleNotFoundException(roleName);
        }
        if (status == 6) {
            throw new RoleNotFoundException(roleName + " is not readable");
        }
    }

    private Role validateRoleWritable(String roleName, boolean initFlag) throws RoleNotFoundException, RelationServiceNotRegisteredException, RelationTypeNotFoundException {
        Role result = this.validateRoleFound(roleName);
        if (this.checkRoleWritable(result, initFlag) != 0) {
            throw new RoleNotFoundException("role not writable");
        }
        return result;
    }

    private void checkServiceProxy() throws RelationServiceNotRegisteredException {
        if (this.serviceProxy == null) {
            try {
                this.serviceProxy = (RelationServiceMBean)MBeanProxy.get(class$javax$management$relation$RelationServiceMBean == null ? (class$javax$management$relation$RelationServiceMBean = RelationSupport.class$("javax.management.relation.RelationServiceMBean")) : class$javax$management$relation$RelationServiceMBean, this.relationService, this.server);
            }
            catch (MBeanProxyCreationException e) {
                throw new RelationServiceNotRegisteredException(e.toString());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

