/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.RelationType;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;
import org.jboss.mx.util.Serialization;

public class RelationTypeSupport
implements RelationType {
    private String name;
    private HashMap roleInfos;
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$lang$String;

    protected RelationTypeSupport(String name) {
        this.name = name;
        this.roleInfos = new HashMap();
    }

    public RelationTypeSupport(String name, RoleInfo[] infos) throws IllegalArgumentException, InvalidRelationTypeException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (infos == null) {
            throw new IllegalArgumentException("No role information");
        }
        if (infos.length == 0) {
            throw new InvalidRelationTypeException("No role information");
        }
        this.name = name;
        this.roleInfos = new HashMap();
        int i = 0;
        while (i < infos.length) {
            if (infos[i] == null) {
                throw new InvalidRelationTypeException("Null role");
            }
            if (this.roleInfos.containsKey(infos[i].getName())) {
                throw new InvalidRelationTypeException("Duplicate role name" + infos[i].getName());
            }
            this.roleInfos.put(infos[i].getName(), infos[i]);
            ++i;
        }
    }

    public String getRelationTypeName() {
        return this.name;
    }

    public List getRoleInfos() {
        return new ArrayList(this.roleInfos.values());
    }

    public RoleInfo getRoleInfo(String roleInfoName) throws RoleInfoNotFoundException {
        if (roleInfoName == null) {
            throw new IllegalArgumentException("Null role info name");
        }
        RoleInfo result = (RoleInfo)this.roleInfos.get(roleInfoName);
        if (result == null) {
            throw new RoleInfoNotFoundException(roleInfoName);
        }
        return result;
    }

    protected void addRoleInfo(RoleInfo roleInfo) throws IllegalArgumentException, InvalidRelationTypeException {
        if (roleInfo == null) {
            throw new IllegalArgumentException("No role information");
        }
        String newName = roleInfo.getName();
        if (this.roleInfos.containsKey(newName)) {
            throw new InvalidRelationTypeException("Duplicate role name");
        }
        this.roleInfos.put(newName, roleInfo);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = ois.readFields();
        switch (Serialization.version) {
            case 10: {
                this.roleInfos = (HashMap)getField.get("myRoleName2InfoMap", null);
                this.name = (String)getField.get("myTypeName", null);
                break;
            }
            default: {
                this.roleInfos = (HashMap)getField.get("roleName2InfoMap", null);
                this.name = (String)getField.get("typeName", null);
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField putField = oos.putFields();
        switch (Serialization.version) {
            case 10: {
                putField.put("myTypeName", this.name);
                putField.put("myRoleName2InfoMap", this.roleInfos);
                break;
            }
            default: {
                putField.put("typeName", this.name);
                putField.put("roleName2InfoMap", this.roleInfos);
            }
        }
        oos.writeFields();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        switch (Serialization.version) {
            case 10: {
                serialVersionUID = -8179019472410837190L;
                serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myIsInRelServFlg", Boolean.TYPE), new ObjectStreamField("myRoleName2InfoMap", class$java$util$HashMap == null ? (class$java$util$HashMap = RelationTypeSupport.class$("java.util.HashMap")) : class$java$util$HashMap), new ObjectStreamField("myTypeName", class$java$lang$String == null ? (class$java$lang$String = RelationTypeSupport.class$("java.lang.String")) : class$java$lang$String)};
                break;
            }
            default: {
                serialVersionUID = 4611072955724144607L;
                serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("isInRelationService", Boolean.TYPE), new ObjectStreamField("roleName2InfoMap", class$java$util$HashMap == null ? (class$java$util$HashMap = RelationTypeSupport.class$("java.util.HashMap")) : class$java$util$HashMap), new ObjectStreamField("typeName", class$java$lang$String == null ? (class$java$lang$String = RelationTypeSupport.class$("java.lang.String")) : class$java$lang$String)};
            }
        }
    }
}

