/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import javax.management.NotCompliantMBeanException;
import javax.management.relation.InvalidRoleInfoException;
import org.jboss.mx.metadata.MBeanCapability;
import org.jboss.mx.util.Serialization;

public class RoleInfo
implements Serializable {
    public static int ROLE_CARDINALITY_INFINITY = -1;
    private String name;
    private String referencedMBeanClassName;
    boolean isReadable;
    boolean isWritable;
    int minDegree;
    int maxDegree;
    String description;
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$java$lang$String;

    public RoleInfo(RoleInfo other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("Null role info");
        }
        this.name = other.name;
        this.referencedMBeanClassName = other.referencedMBeanClassName;
        this.isReadable = other.isReadable;
        this.isWritable = other.isWritable;
        this.minDegree = other.minDegree;
        this.maxDegree = other.maxDegree;
        this.description = other.description;
    }

    public RoleInfo(String name, String className) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        this(name, className, true, true);
    }

    public RoleInfo(String name, String className, boolean readable, boolean writable) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        this.name = name;
        this.referencedMBeanClassName = className;
        this.isReadable = readable;
        this.isWritable = writable;
        this.minDegree = 1;
        this.maxDegree = 1;
        this.checkClass();
    }

    public RoleInfo(String name, String className, boolean readable, boolean writable, int minDegree, int maxDegree, String description) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException, InvalidRoleInfoException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (maxDegree < minDegree && maxDegree != ROLE_CARDINALITY_INFINITY) {
            throw new InvalidRoleInfoException("maximum less than minimum");
        }
        if (minDegree == ROLE_CARDINALITY_INFINITY && maxDegree != ROLE_CARDINALITY_INFINITY) {
            throw new InvalidRoleInfoException("maximum less than minimum");
        }
        this.name = name;
        this.referencedMBeanClassName = className;
        this.minDegree = minDegree;
        this.maxDegree = maxDegree;
        this.isReadable = readable;
        this.isWritable = writable;
        this.description = description;
        this.checkClass();
    }

    public boolean checkMinDegree(int value) {
        return value >= this.minDegree || this.minDegree == ROLE_CARDINALITY_INFINITY;
    }

    public boolean checkMaxDegree(int value) {
        return value <= this.maxDegree || this.maxDegree == ROLE_CARDINALITY_INFINITY;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMinDegree() {
        return this.minDegree;
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public String getName() {
        return this.name;
    }

    public String getRefMBeanClassName() {
        return this.referencedMBeanClassName;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("RoleInfo for name: (");
        buffer.append(this.name);
        buffer.append(") class name: (");
        buffer.append(this.referencedMBeanClassName);
        buffer.append(") description: (");
        buffer.append(this.description);
        buffer.append(") readable: (");
        buffer.append(this.isReadable);
        buffer.append(") writable: (");
        buffer.append(this.isWritable);
        buffer.append(") minimum degree: (");
        buffer.append(this.minDegree);
        buffer.append(") maximum degree: (");
        buffer.append(this.maxDegree);
        buffer.append(")");
        return buffer.toString();
    }

    private void checkClass() throws ClassNotFoundException, NotCompliantMBeanException {
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.referencedMBeanClassName);
        MBeanCapability.of(clazz);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        switch (Serialization.version) {
            case 10: {
                ObjectInputStream.GetField getField = ois.readFields();
                this.description = (String)getField.get("myDescription", null);
                this.isReadable = getField.get("myIsReadableFlg", false);
                this.isWritable = getField.get("myIsWritableFlg", false);
                this.maxDegree = getField.get("myMaxDegree", 1);
                this.minDegree = getField.get("myMinDegree", 1);
                this.name = (String)getField.get("myName", null);
                this.referencedMBeanClassName = (String)getField.get("myRefMBeanClassName", null);
                break;
            }
            default: {
                ois.defaultReadObject();
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        switch (Serialization.version) {
            case 10: {
                ObjectOutputStream.PutField putField = oos.putFields();
                putField.put("myDescription", this.description);
                putField.put("myIsReadableFlg", this.isReadable);
                putField.put("myIsWritableFlg", this.isWritable);
                putField.put("myMaxDegree", this.maxDegree);
                putField.put("myMinDegree", this.minDegree);
                putField.put("myName", this.name);
                putField.put("myRefMBeanClassName", this.referencedMBeanClassName);
                oos.writeFields();
                break;
            }
            default: {
                oos.defaultWriteObject();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        switch (Serialization.version) {
            case 10: {
                serialVersionUID = 7227256952085334351L;
                serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myDescription", class$java$lang$String == null ? (class$java$lang$String = RoleInfo.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("myIsReadableFlg", Boolean.TYPE), new ObjectStreamField("myIsWritableFlg", Boolean.TYPE), new ObjectStreamField("myMaxDegree", Integer.TYPE), new ObjectStreamField("myMinDegree", Integer.TYPE), new ObjectStreamField("myName", class$java$lang$String == null ? (class$java$lang$String = RoleInfo.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("myRefMBeanClassName", class$java$lang$String == null ? (class$java$lang$String = RoleInfo.class$("java.lang.String")) : class$java$lang$String)};
                break;
            }
            default: {
                serialVersionUID = 2504952983494636987L;
                serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("description", class$java$lang$String == null ? (class$java$lang$String = RoleInfo.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("isReadable", Boolean.TYPE), new ObjectStreamField("isWritable", Boolean.TYPE), new ObjectStreamField("maxDegree", Integer.TYPE), new ObjectStreamField("minDegree", Integer.TYPE), new ObjectStreamField("name", class$java$lang$String == null ? (class$java$lang$String = RoleInfo.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("referencedMBeanClassName", class$java$lang$String == null ? (class$java$lang$String = RoleInfo.class$("java.lang.String")) : class$java$lang$String)};
            }
        }
    }
}

