/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import javax.management.Descriptor;

public class Invocation {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int OPERATION = 16;
    public static final int ATTRIBUTE = 32;
    private Object sx;
    private Object tx;
    private int type;
    private int impact;
    private Object[] args;
    private String name;
    private String[] signature;
    private String fullName;
    private Descriptor[] descriptors;
    private Object resource;

    public Invocation(String name, int type, int impact, Object[] args, String[] signature, Descriptor[] descriptors, Object resource) {
        this.name = name;
        this.type = type;
        this.impact = impact;
        this.args = args;
        this.signature = signature;
        this.descriptors = descriptors;
        this.resource = resource;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Descriptor[] getDescriptors() {
        return this.descriptors;
    }

    public int getInvocationType() {
        return this.type;
    }

    public int getImpact() {
        return this.impact;
    }

    public String getName() {
        return this.name;
    }

    public Object getResource() {
        return this.resource;
    }

    public String[] getSignature() {
        return this.signature;
    }

    public String getOperationWithSignature() {
        if (this.signature == null && this.type == 16) {
            return this.name;
        }
        if (this.fullName != null) {
            return this.fullName;
        }
        StringBuffer strBuf = new StringBuffer(1000);
        if (this.type == 32 && this.impact == 1) {
            strBuf.append("get");
        }
        if (this.type == 32 && this.impact == 2) {
            strBuf.append("set");
        }
        strBuf.append(this.name);
        if (this.signature != null) {
            int i = 0;
            while (i < this.signature.length) {
                strBuf.append(this.signature[i]);
                ++i;
            }
        }
        this.fullName = strBuf.toString();
        return this.fullName;
    }
}

