/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import javax.management.Attribute;
import javax.management.Descriptor;
import javax.management.MBeanInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.interceptor.Invocation;
import org.jboss.mx.interceptor.InvocationException;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jboss.mx.modelmbean.ModelMBeanInvoker;
import org.jboss.mx.server.MBeanInvoker;

public class MBeanAttributeInterceptor
extends AbstractInterceptor
implements ModelMBeanConstants {
    private ModelMBeanInfo modelIinfo = null;

    public MBeanAttributeInterceptor(MBeanInfo info, MBeanInvoker invoker) {
        super(info, invoker);
        this.modelIinfo = (ModelMBeanInfo)((Object)info);
    }

    public Object invoke(Invocation invocation) throws InvocationException {
        if (invocation.getInvocationType() == 16) {
            return this.getNext().invoke(invocation);
        }
        try {
            String attrName = invocation.getName();
            Descriptor d = this.modelIinfo.getDescriptor(attrName, "attribute");
            if (invocation.getImpact() == 2) {
                Object value = invocation.getArgs()[0];
                Object oldValue = d.getFieldValue("value");
                String setMethod = (String)d.getFieldValue("setMethod");
                if (setMethod != null) {
                    this.invoker.invoke(setMethod, new Object[]{value}, invocation.getSignature());
                }
                d.setField("value", value);
                d.setField("lastUpdatedTimeStamp", "" + System.currentTimeMillis() / 1000L);
                this.modelIinfo.setDescriptor(d, "attribute");
                ((ModelMBeanInvoker)this.invoker).sendAttributeChangeNotification(new Attribute(attrName, oldValue), new Attribute(attrName, value));
            } else {
                String getMethod = (String)d.getFieldValue("getMethod");
                if (getMethod != null) {
                    long limit;
                    String timeLimit = (String)d.getFieldValue("currencyTimeLimit");
                    long l = limit = timeLimit == null ? 0L : Long.parseLong(timeLimit);
                    if (limit == -1L) {
                        return d.getFieldValue("value");
                    }
                    if (limit > 0L) {
                        long lastUpdate;
                        String timeStamp = (String)d.getFieldValue("lastUpdatedTimeStamp");
                        long l2 = lastUpdate = timeStamp == null ? 0L : Long.parseLong(timeStamp);
                        if (System.currentTimeMillis() < lastUpdate * 1000L + limit * 1000L) {
                            return d.getFieldValue("value");
                        }
                    }
                    Object value = this.invoker.invoke(getMethod, new Object[0], new String[0]);
                    d.setField("value", value);
                    d.setField("lastUpdatedTimeStamp", "" + System.currentTimeMillis() / 1000L);
                    this.modelIinfo.setDescriptor(d, "attribute");
                } else {
                    Object defaultValue = d.getFieldValue("default");
                    String timeStamp = (String)d.getFieldValue("lastUpdatedTimeStamp");
                    if (defaultValue != null && timeStamp == null) {
                        d.setField("value", defaultValue);
                        d.setField("lastUpdatedTimeStamp", "" + System.currentTimeMillis() / 1000L);
                        this.modelIinfo.setDescriptor(d, "attribute");
                    }
                }
            }
            return d.getFieldValue("value");
        }
        catch (Throwable t) {
            throw new InvocationException(t);
        }
    }
}

