/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.interceptor.Invocation;
import org.jboss.mx.interceptor.InvocationException;
import org.jboss.mx.interceptor.StandardMBeanInterceptor;
import org.jboss.mx.server.MBeanInvoker;

public class ModelMBeanInterceptor
extends AbstractInterceptor {
    private Map methodMap = new HashMap();

    public ModelMBeanInterceptor(MBeanInfo info, MBeanInvoker invoker) throws ReflectionException {
        super(info, invoker);
        MBeanOperationInfo[] operations = info.getOperations();
        Object resource = invoker.getResource();
        StringBuffer paramBuffer = new StringBuffer();
        int i = 0;
        while (i < operations.length) {
            String name = operations[i].getName();
            try {
                MBeanParameterInfo[] params = operations[i].getSignature();
                paramBuffer.setLength(0);
                int j = 0;
                while (j < params.length) {
                    paramBuffer.append(params[j].getType());
                    ++j;
                }
                Class<?> resourceClass = resource.getClass();
                ClassLoader resourceLoader = resourceClass.getClassLoader();
                Class[] opSig = StandardMBeanInterceptor.getSignatureAsClassArray(params, resourceLoader);
                Method opMethod = resourceClass.getMethod(name, opSig);
                this.methodMap.put(name + paramBuffer.toString(), opMethod);
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException(e, "Unable to load operation " + name + " parameter type: " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException(e);
            }
            ++i;
        }
    }

    public Object invoke(Invocation invocation) throws InvocationException {
        try {
            Object resource = invocation.getResource();
            if (resource == null) {
                String msg = "No resource found in: " + invocation.getName();
                new InvocationException(new NullPointerException(msg), msg);
            }
            Method m = (Method)this.methodMap.get(invocation.getOperationWithSignature());
            return m.invoke(resource, invocation.getArgs());
        }
        catch (IllegalAccessException e) {
            throw new InvocationException(e, "Illegal access to method " + invocation.getName());
        }
        catch (IllegalArgumentException e) {
            throw new InvocationException(e, "Illegal operation arguments in " + invocation.getName() + ": " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                Exception e2 = (Exception)e.getTargetException();
                throw new InvocationException(e2, "Operation " + invocation.getName() + " on MBean " + this.info.getClassName() + " has thrown an exception: " + e2.toString());
            }
            Error err = (Error)e.getTargetException();
            throw new InvocationException(err, "Operation " + invocation.getName() + " on MBean " + this.info.getClassName() + " has thrown an error: " + err.toString());
        }
        catch (NullPointerException e) {
            String msg = "Operation " + invocation.getName() + " is not a declared management operation.";
            NullPointerException npe = new NullPointerException(msg);
            throw new InvocationException(npe, msg);
        }
    }
}

