/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import javax.management.Attribute;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import org.jboss.mx.capability.DispatcherFactory;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.interceptor.Invocation;
import org.jboss.mx.interceptor.InvocationException;
import org.jboss.mx.server.MBeanInvoker;

public class ObjectReferenceInterceptor
extends AbstractInterceptor {
    private DynamicMBean dynmicMBean;

    public ObjectReferenceInterceptor(MBeanInfo info, MBeanInvoker invoker) throws ReflectionException {
        super(info, invoker);
        try {
            ModelMBeanInfo modelInfo = (ModelMBeanInfo)((Object)info);
            ModelMBeanInfoSupport support = new ModelMBeanInfoSupport(modelInfo);
            Object resource = invoker.getResource();
            this.dynmicMBean = DispatcherFactory.create(support, resource);
        }
        catch (IntrospectionException e) {
            throw new ReflectionException(e);
        }
    }

    public Object invoke(Invocation invocation) throws InvocationException {
        try {
            if (invocation.getInvocationType() == 16) {
                return this.dynmicMBean.invoke(invocation.getName(), invocation.getArgs(), invocation.getSignature());
            }
            if (invocation.getImpact() == 2) {
                this.dynmicMBean.setAttribute(new Attribute(invocation.getName(), invocation.getArgs()[0]));
                return null;
            }
            return this.dynmicMBean.getAttribute(invocation.getName());
        }
        catch (Throwable t) {
            throw new InvocationException(t);
        }
    }
}

