/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.PersistentMBean;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.interceptor.Invocation;
import org.jboss.mx.interceptor.InvocationException;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jboss.mx.server.MBeanInvoker;
import org.jboss.mx.service.ServiceConstants;

public class PersistenceInterceptor2
extends AbstractInterceptor
implements ModelMBeanConstants,
ServiceConstants {
    private HashMap attrPersistencePolicies = new HashMap();
    private HashMap timerTaskMap = new HashMap();
    private String mbeanPersistencePolicy;
    private PersistentMBean callback;

    public PersistenceInterceptor2(MBeanInfo info, MBeanInvoker invoker) {
        super(info, invoker);
        this.callback = (PersistentMBean)((Object)invoker);
        Descriptor[] descriptors = invoker.getDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            String policy = (String)descriptors[i].getFieldValue("persistPolicy");
            String persistPeriod = (String)descriptors[i].getFieldValue("persistPeriod");
            String type = (String)descriptors[i].getFieldValue("descriptorType");
            if (type.equalsIgnoreCase("MBean")) {
                if (policy == null) {
                    policy = "Never";
                }
                this.mbeanPersistencePolicy = policy;
                if (this.mbeanPersistencePolicy.equalsIgnoreCase("OnTimer") || this.mbeanPersistencePolicy.equalsIgnoreCase("NoMoreOftenThan")) {
                    boolean isNoMoreOftenThan = this.mbeanPersistencePolicy.equalsIgnoreCase("NoMoreOftenThan");
                    this.schedulePersistenceNotifications(Long.parseLong(persistPeriod), "MBean", isNoMoreOftenThan);
                }
            } else if (policy != null) {
                String name = (String)descriptors[i].getFieldValue("name");
                this.attrPersistencePolicies.put(name, policy);
                if (policy.equalsIgnoreCase("OnTimer") || policy.equalsIgnoreCase("NoMoreOftenThan")) {
                    boolean isNoMoreOftenThan = policy.equalsIgnoreCase("NoMoreOftenThan");
                    this.schedulePersistenceNotifications(Long.parseLong(persistPeriod), name, isNoMoreOftenThan);
                }
            }
            ++i;
        }
    }

    public Object invoke(Invocation invocation) throws InvocationException {
        PersistenceTimerTask task;
        Object returnValue = this.getNext().invoke(invocation);
        int type = invocation.getInvocationType();
        int impact = invocation.getImpact();
        if (type == 16 || impact == 1) {
            return returnValue;
        }
        String attrName = invocation.getName();
        String policy = (String)this.attrPersistencePolicies.get(attrName);
        if (policy == null) {
            policy = this.mbeanPersistencePolicy;
        }
        if (policy.equalsIgnoreCase("OnUpdate")) {
            try {
                this.callback.store();
            }
            catch (Throwable t) {
                throw new InvocationException(t, "Cannot persist the MBean data.");
            }
        } else if (policy.equalsIgnoreCase("NoMoreOftenThan") && (task = (PersistenceTimerTask)this.timerTaskMap.get(attrName)) != null) {
            task.setHasUpdated(true);
        }
        return returnValue;
    }

    private void schedulePersistenceNotifications(long persistPeriod, String name, boolean isNoMoreOftenThan) {
        PersistenceTimerTask task = new PersistenceTimerTask(name, isNoMoreOftenThan);
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate((TimerTask)task, 0L, persistPeriod);
        this.timerTaskMap.put(name, task);
    }

    private class PersistenceTimerTask
    extends TimerTask {
        boolean noMoreOftenThan;
        boolean hasUpdated;
        String name;

        PersistenceTimerTask(String name, boolean noMoreOftenThan) {
            this.name = name;
            this.noMoreOftenThan = noMoreOftenThan;
        }

        synchronized void setHasUpdated(boolean flag) {
            this.hasUpdated = flag;
        }

        public void run() {
            try {
                boolean doStore;
                boolean bl = doStore = this.noMoreOftenThan && this.hasUpdated || !this.noMoreOftenThan;
                if (doStore) {
                    PersistenceInterceptor2.this.callback.store();
                    this.setHasUpdated(false);
                }
            }
            catch (MBeanException e) {
            }
            catch (InstanceNotFoundException e) {}
        }
    }
}

