/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.loading.DefaultLoaderRepository;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.interceptor.Invocation;
import org.jboss.mx.interceptor.InvocationException;
import org.jboss.mx.server.MBeanInvoker;
import org.jboss.mx.server.StandardMBeanInvoker;

public class StandardMBeanInterceptor
extends AbstractInterceptor {
    private Map methodMap = new HashMap();
    private Class invocationInterface = null;

    public StandardMBeanInterceptor(MBeanInfo info, MBeanInvoker invoker) throws ReflectionException {
        super(info, invoker);
        Object resource = invoker.getResource();
        this.invocationInterface = StandardMBeanInvoker.getMBeanInterface(resource);
        MBeanOperationInfo[] operations = info.getOperations();
        StringBuffer paramBuffer = new StringBuffer();
        int i = 0;
        while (i < operations.length) {
            String name = operations[i].getName();
            try {
                MBeanParameterInfo[] params = operations[i].getSignature();
                int j = 0;
                while (j < params.length) {
                    paramBuffer.append(params[j].getType());
                    ++j;
                }
                Class<?> resourceClass = resource.getClass();
                ClassLoader resourceLoader = resourceClass.getClassLoader();
                Class[] opSig = StandardMBeanInterceptor.getSignatureAsClassArray(params, resourceLoader);
                Method opMethod = this.invocationInterface.getMethod(name, opSig);
                this.methodMap.put(name + paramBuffer.toString(), opMethod);
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException(e, "Unable to load operation " + name + " parameter type: " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException(e);
            }
            ++i;
        }
        MBeanAttributeInfo[] attributes = info.getAttributes();
        int i2 = 0;
        while (i2 < attributes.length) {
            String name = attributes[i2].getName();
            String type = attributes[i2].getType();
            try {
                boolean isReadable = attributes[i2].isReadable();
                boolean isWritable = attributes[i2].isWritable();
                boolean isIs = attributes[i2].isIs();
                if (isReadable) {
                    if (isIs) {
                        this.methodMap.put("get" + name, this.invocationInterface.getMethod("is" + name, null));
                    } else {
                        this.methodMap.put("get" + name, this.invocationInterface.getMethod("get" + name, null));
                    }
                }
                if (isWritable) {
                    this.methodMap.put("set" + name + type, this.invocationInterface.getMethod("set" + name, StandardMBeanInterceptor.getSignatureAsClassArray(new String[]{type}, resource.getClass().getClassLoader())));
                }
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException(e, "Unable to load type for attribute " + name + ": " + type);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException(e);
            }
            ++i2;
        }
    }

    public static Class[] getSignatureAsClassArray(String[] signature, ClassLoader cl) throws ClassNotFoundException {
        Class[] sign = new Class[signature.length];
        int i = 0;
        while (i < signature.length) {
            try {
                sign[i] = StandardMBeanInterceptor.getClassForType(signature[i], cl);
            }
            catch (ClassNotFoundException e) {
                DefaultLoaderRepository.loadClass(signature[i]);
            }
            ++i;
        }
        return sign;
    }

    public static Class[] getSignatureAsClassArray(MBeanParameterInfo[] signature, ClassLoader cl) throws ClassNotFoundException {
        Class[] sign = new Class[signature.length];
        int i = 0;
        while (i < signature.length) {
            try {
                String type = signature[i].getType();
                sign[i] = StandardMBeanInterceptor.getClassForType(type, cl);
            }
            catch (ClassNotFoundException e) {
                DefaultLoaderRepository.loadClass(signature[i].getName());
            }
            ++i;
        }
        return sign;
    }

    public static Class getClassForType(String type, ClassLoader cl) throws ClassNotFoundException {
        if (Integer.TYPE.getName().equals(type)) {
            return Integer.TYPE;
        }
        if (Float.TYPE.getName().equals(type)) {
            return Float.TYPE;
        }
        if (Double.TYPE.getName().equals(type)) {
            return Double.TYPE;
        }
        if (Long.TYPE.getName().equals(type)) {
            return Long.TYPE;
        }
        if (Byte.TYPE.getName().equals(type)) {
            return Byte.TYPE;
        }
        if (Boolean.TYPE.getName().equals(type)) {
            return Boolean.TYPE;
        }
        if (Character.TYPE.getName().equals(type)) {
            return Character.TYPE;
        }
        if (Void.TYPE.getName().equals(type)) {
            return Void.TYPE;
        }
        if (Short.TYPE.getName().equals(type)) {
            return Short.TYPE;
        }
        return cl.loadClass(type);
    }

    public Object invoke(Invocation invocation) throws InvocationException {
        Method method = null;
        try {
            method = (Method)this.methodMap.get(invocation.getOperationWithSignature());
            Object resource = invocation.getResource();
            return method.invoke(resource, invocation.getArgs());
        }
        catch (IllegalAccessException e) {
            throw new InvocationException(new ReflectionException(e, "Illegal access to method " + method.getName()));
        }
        catch (IllegalArgumentException e) {
            throw new InvocationException(new ReflectionException(e, "Illegal arguments for " + (invocation.getInvocationType() == 32 ? "attribute " : "operation ") + invocation.getName() + ": " + e.getMessage()));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)e.getTargetException();
                throw new InvocationException(new RuntimeMBeanException(re, "RuntimeException thrown by " + (invocation.getInvocationType() == 32 ? "attribute " : "operation ") + invocation.getName() + " in MBean " + this.info.getClassName() + ": " + e.getTargetException().toString()));
            }
            if (e.getTargetException() instanceof Exception) {
                throw new InvocationException(new MBeanException((Exception)e.getTargetException(), "Exception thrown by " + (invocation.getInvocationType() == 32 ? "attribute " : "operation ") + invocation.getName() + " in MBean " + this.info.getClassName() + ": " + e.getTargetException().toString()));
            }
            if (e.getTargetException() instanceof Error) {
                throw new InvocationException(new RuntimeErrorException((Error)e.getTargetException(), "Error thrown by " + (invocation.getInvocationType() == 32 ? "attribute " : "operation ") + invocation.getName() + " in MBean " + this.info.getClassName() + ": " + e.getTargetException().toString()));
            }
            throw new InvocationException(e.getTargetException());
        }
        catch (NullPointerException e) {
            if (invocation.getInvocationType() == 32) {
                throw new InvocationException(new AttributeNotFoundException("Attribute '" + invocation.getName() + "' not found on " + this.info.getClassName()));
            }
            NullPointerException ex = new NullPointerException("Operation '" + invocation.getName() + "' not found on " + this.info.getClassName());
            throw new InvocationException(new ReflectionException(ex));
        }
    }
}

