/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.UnifiedClassLoader;

public class ClassLoaderUtils {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$mx$loading$ClassLoaderUtils == null ? (class$org$jboss$mx$loading$ClassLoaderUtils = ClassLoaderUtils.class$("org.jboss.mx.loading.ClassLoaderUtils")) : class$org$jboss$mx$loading$ClassLoaderUtils));
    static /* synthetic */ Class class$org$jboss$mx$loading$ClassLoaderUtils;

    public static void displayClassInfo(Class clazz, StringBuffer results) {
        ClassLoader cl = clazz.getClassLoader();
        results.append("\n" + clazz.getName() + "(" + Integer.toHexString(clazz.hashCode()) + ").ClassLoader=" + cl);
        ClassLoader parent = cl;
        while (parent != null) {
            results.append("\n.." + parent);
            URL[] urls = ClassLoaderUtils.getClassLoaderURLs(parent);
            int length = urls != null ? urls.length : 0;
            int u = 0;
            while (u < length) {
                results.append("\n...." + urls[u]);
                ++u;
            }
            if (parent == null) continue;
            parent = parent.getParent();
        }
        CodeSource clazzCS = clazz.getProtectionDomain().getCodeSource();
        if (clazzCS != null) {
            results.append("\n++++CodeSource: " + clazzCS);
        } else {
            results.append("\n++++Null CodeSource");
        }
        results.append("\nImplemented Interfaces:");
        Class<?>[] ifaces = clazz.getInterfaces();
        int i = 0;
        while (i < ifaces.length) {
            Class<?> iface = ifaces[i];
            results.append("\n++" + iface + "(" + Integer.toHexString(iface.hashCode()) + ")");
            ClassLoader loader = ifaces[i].getClassLoader();
            results.append("\n++++ClassLoader: " + loader);
            ProtectionDomain pd = ifaces[i].getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            if (cs != null) {
                results.append("\n++++CodeSource: " + cs);
            } else {
                results.append("\n++++Null CodeSource");
            }
            ++i;
        }
    }

    public static URL[] getClassLoaderURLs(ClassLoader cl) {
        URL[] urls = new URL[]{};
        try {
            Class<?> returnType = urls.getClass();
            Class[] parameterTypes = new Class[]{};
            Method getURLs = cl.getClass().getMethod("getURLs", parameterTypes);
            if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                Object[] args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
        }
        catch (Exception ignore) {}
        return urls;
    }

    public static URLClassLoader[] getClassLoaderStack(ClassLoader cl) {
        ArrayList<ClassLoader> stack = new ArrayList<ClassLoader>();
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                stack.add(cl);
            }
            cl = cl.getParent();
        }
        URLClassLoader[] ucls = new URLClassLoader[stack.size()];
        stack.toArray(ucls);
        return ucls;
    }

    public static String getPackageName(String className) {
        int startIndex = 0;
        if (className.length() > 0 && className.charAt(0) == '[') {
            startIndex = className.indexOf(76) + 1;
        }
        String pkgName = "";
        int endIndex = className.lastIndexOf(46);
        if (endIndex > 0) {
            pkgName = className.substring(startIndex, endIndex);
        }
        return pkgName;
    }

    public static String[] updatePackageMap(UnifiedClassLoader cl, HashMap packagesMap) throws Exception {
        URL url = cl.getURL();
        ClassPathIterator cpi = new ClassPathIterator(url);
        HashSet pkgNameSet = new HashSet();
        return ClassLoaderUtils.updatePackageMap(cl, packagesMap, cpi, pkgNameSet);
    }

    public static String[] updatePackageMap(UnifiedClassLoader cl, HashMap packagesMap, URL url, String[] prevPkgNames) throws Exception {
        ClassPathIterator cpi = new ClassPathIterator(url);
        HashSet<String> pkgNameSet = new HashSet<String>(Arrays.asList(prevPkgNames));
        return ClassLoaderUtils.updatePackageMap(cl, packagesMap, cpi, pkgNameSet);
    }

    /*
     * WARNING - void declaration
     */
    static String[] updatePackageMap(UnifiedClassLoader cl, HashMap packagesMap, ClassPathIterator cpi, HashSet pkgNameSet) throws Exception {
        ClassPathEntry entry;
        boolean trace = log.isTraceEnabled();
        while ((entry = cpi.getNextEntry()) != null) {
            void var5_5;
            String name = var5_5.getName();
            if (name.equals("META-INF/INDEX.LIST")) {
                ClassLoaderUtils.readJarIndex(cl, cpi, packagesMap, pkgNameSet);
                break;
            }
            if (var5_5.isDirectory()) continue;
            String pkgName = var5_5.toPackageName();
            ClassLoaderUtils.addPackage(pkgName, packagesMap, pkgNameSet, cl, trace);
        }
        cpi.close();
        String[] pkgNames = new String[pkgNameSet.size()];
        pkgNameSet.toArray(pkgNames);
        return pkgNames;
    }

    /*
     * WARNING - void declaration
     */
    private static void readJarIndex(UnifiedClassLoader cl, ClassPathIterator cpi, HashMap packagesMap, HashSet pkgNameSet) throws Exception {
        String line;
        boolean trace = log.isTraceEnabled();
        InputStream zis = cpi.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(zis));
        while ((line = br.readLine()) != null) {
            void var7_7;
            if (var7_7.length() == 0) break;
        }
        String jarName = br.readLine();
        if (trace) {
            log.trace((Object)("Reading INDEX.LIST for jar: " + jarName));
        }
        while ((line = br.readLine()) != null) {
            if (line.length() == 0) break;
            String pkgName = line.replace('/', '.');
            ClassLoaderUtils.addPackage(pkgName, packagesMap, pkgNameSet, cl, trace);
        }
        br.close();
    }

    private static void addPackage(String pkgName, HashMap packagesMap, HashSet pkgNameSet, UnifiedClassLoader cl, boolean trace) {
        if (pkgName.startsWith("META-INF") || pkgName.startsWith("WEB-INF")) {
            return;
        }
        HashSet<UnifiedClassLoader> pkgSet = (HashSet<UnifiedClassLoader>)packagesMap.get(pkgName);
        if (pkgSet == null) {
            pkgSet = new HashSet<UnifiedClassLoader>();
            packagesMap.put(pkgName, pkgSet);
        }
        if (!pkgSet.contains(cl)) {
            pkgSet.add(cl);
            pkgNameSet.add(pkgName);
            if (pkgSet.size() > 1) {
                log.debug((Object)("Multiple class loaders found for pkg: " + pkgName));
            }
            if (trace) {
                log.trace((Object)("Indexed pkg: " + pkgName + ", UCL: " + cl));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ClassPathIterator {
        ZipInputStream zis;
        FileIterator fileIter;
        File file;
        int rootLength;

        ClassPathIterator(URL url) throws IOException {
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                File tmp = new File(url.getFile());
                String name = tmp.getName();
                if (tmp.isDirectory()) {
                    this.rootLength = tmp.getPath().length() + 1;
                    this.fileIter = new FileIterator(tmp, new ClassFilter());
                } else {
                    FileInputStream is = new FileInputStream(tmp);
                    this.zis = new ZipInputStream(is);
                }
            } else {
                InputStream is = url.openStream();
                this.zis = new ZipInputStream(is);
            }
        }

        ClassPathEntry getNextEntry() throws IOException {
            ClassPathEntry entry = null;
            if (this.zis != null) {
                ZipEntry zentry = this.zis.getNextEntry();
                if (zentry != null) {
                    entry = new ClassPathEntry(zentry);
                }
            } else {
                File fentry = this.fileIter.getNextEntry();
                if (fentry != null) {
                    entry = new ClassPathEntry(fentry, this.rootLength);
                }
                this.file = fentry;
            }
            return entry;
        }

        InputStream getInputStream() throws IOException {
            InputStream is = this.zis;
            if (this.zis == null) {
                is = new FileInputStream(this.file);
            }
            return is;
        }

        void close() throws IOException {
            if (this.zis != null) {
                this.zis.close();
            }
        }
    }

    static class ClassPathEntry {
        String name;
        ZipEntry zipEntry;
        File fileEntry;

        ClassPathEntry(ZipEntry zipEntry) {
            this.zipEntry = zipEntry;
            this.name = zipEntry.getName();
        }

        ClassPathEntry(File fileEntry, int rootLength) {
            this.fileEntry = fileEntry;
            this.name = fileEntry.getPath().substring(rootLength);
        }

        String getName() {
            return this.name;
        }

        String toPackageName() {
            String pkgName = this.name;
            char separatorChar = this.zipEntry != null ? (char)'/' : (char)File.separatorChar;
            int index = this.name.lastIndexOf(separatorChar);
            if (index > 0) {
                pkgName = this.name.substring(0, index);
                pkgName = pkgName.replace(separatorChar, '.');
            } else {
                pkgName = "";
            }
            return pkgName;
        }

        boolean isDirectory() {
            boolean isDirectory = false;
            isDirectory = this.zipEntry != null ? this.zipEntry.isDirectory() : this.fileEntry.isDirectory();
            return isDirectory;
        }
    }

    static class ClassFilter
    implements FileFilter {
        ClassFilter() {
        }

        public boolean accept(File file) {
            boolean accept = file.isDirectory() || file.getName().endsWith(".class");
            return accept;
        }
    }

    static class FileIterator {
        LinkedList subDirectories = new LinkedList();
        FileFilter filter;
        File[] currentListing;
        int index = 0;

        FileIterator(File start) {
            this.currentListing = start.listFiles();
        }

        FileIterator(File start, FileFilter filter) {
            this.currentListing = start.listFiles(filter);
            this.filter = filter;
        }

        File getNextEntry() {
            File next = null;
            if (this.index >= this.currentListing.length && this.subDirectories.size() > 0) {
                do {
                    File nextDir = (File)this.subDirectories.removeFirst();
                    this.currentListing = nextDir.listFiles(this.filter);
                } while (this.currentListing.length == 0 && this.subDirectories.size() > 0);
                this.index = 0;
            }
            if (this.index < this.currentListing.length && (next = this.currentListing[this.index++]).isDirectory()) {
                this.subDirectories.addLast(next);
            }
            return next;
        }
    }
}

