/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.LoadMgr;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.loading.UnifiedClassLoader3;
import org.jboss.mx.loading.UnifiedLoaderRepository3;

public class HeirarchicalLoaderRepository3
extends UnifiedLoaderRepository3 {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$mx$loading$HeirarchicalLoaderRepository3 == null ? (class$org$jboss$mx$loading$HeirarchicalLoaderRepository3 = HeirarchicalLoaderRepository3.class$("org.jboss.mx.loading.HeirarchicalLoaderRepository3")) : class$org$jboss$mx$loading$HeirarchicalLoaderRepository3));
    private static ObjectName DEFAULT_LOADER_NAME;
    private UnifiedLoaderRepository3 parentRepository;
    private boolean java2ParentDelegaton;
    static /* synthetic */ Class class$org$jboss$mx$loading$HeirarchicalLoaderRepository3;
    static /* synthetic */ Class class$org$jboss$mx$loading$UnifiedClassLoader3;

    public HeirarchicalLoaderRepository3(MBeanServer server) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        this(server, DEFAULT_LOADER_NAME);
    }

    public HeirarchicalLoaderRepository3(MBeanServer server, ObjectName parentName) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        this.parentRepository = (UnifiedLoaderRepository3)server.getAttribute(parentName, "Instance");
    }

    public UnifiedClassLoader newClassLoader(URL url, boolean addToRepository) throws Exception {
        UnifiedClassLoader3 ucl = null;
        ucl = !this.java2ParentDelegaton ? new UnifiedClassLoader3(url, null, (ClassLoader)new NoParentClassLoader(), this) : new UnifiedClassLoader3(url, null, this);
        if (addToRepository) {
            this.addClassLoader(ucl);
        }
        return ucl;
    }

    public UnifiedClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository) throws Exception {
        UnifiedClassLoader3 ucl = null;
        ucl = !this.java2ParentDelegaton ? new UnifiedClassLoader3(url, origURL, (ClassLoader)new NoParentClassLoader(), this) : new UnifiedClassLoader3(url, origURL, this);
        if (addToRepository) {
            this.addClassLoader(ucl);
        }
        return ucl;
    }

    public boolean getUseParentFirst() {
        return this.java2ParentDelegaton;
    }

    public void setUseParentFirst(boolean flag) {
        this.java2ParentDelegaton = flag;
    }

    public Class loadClass(String name, boolean resolve, ClassLoader scl) throws ClassNotFoundException {
        Class foundClass;
        block7: {
            foundClass = null;
            if (this.java2ParentDelegaton) {
                try {
                    foundClass = this.parentRepository.loadClass(name, resolve, scl);
                }
                catch (ClassNotFoundException e) {
                    if (foundClass == null) {
                        foundClass = super.loadClass(name, resolve, scl);
                    }
                    break block7;
                }
            }
            try {
                foundClass = super.loadClass(name, resolve, scl);
            }
            catch (ClassNotFoundException e) {
                if (foundClass != null) break block7;
                foundClass = this.parentRepository.loadClass(name, resolve, scl);
            }
        }
        if (foundClass != null) {
            return foundClass;
        }
        throw new ClassNotFoundException(name);
    }

    public URL getResource(String name, ClassLoader scl) {
        URL resource = null;
        if (this.java2ParentDelegaton) {
            resource = this.parentRepository.getResource(name, scl);
            if (resource == null) {
                resource = super.getResource(name, scl);
            }
        } else {
            resource = super.getResource(name, scl);
            if (resource == null) {
                resource = this.parentRepository.getResource(name, scl);
            }
        }
        return resource;
    }

    public void getResources(String name, ClassLoader cl, List urls) {
        if (this.java2ParentDelegaton) {
            this.parentRepository.getResources(name, cl, urls);
            super.getResources(name, cl, urls);
        } else {
            super.getResources(name, cl, urls);
            this.parentRepository.getResources(name, cl, urls);
        }
    }

    public URL[] getURLs() {
        URL[] ourURLs = super.getURLs();
        URL[] parentURLs = this.parentRepository.getURLs();
        int size = ourURLs.length + parentURLs.length;
        URL[] urls = new URL[size];
        System.arraycopy(ourURLs, 0, urls, 0, ourURLs.length);
        System.arraycopy(parentURLs, 0, urls, ourURLs.length, parentURLs.length);
        return urls;
    }

    public Class loadClassFromCache(String name) {
        Class foundClass = null;
        if (this.java2ParentDelegaton) {
            foundClass = this.parentRepository.loadClassFromCache(name);
            if (foundClass == null) {
                foundClass = super.loadClassFromCache(name);
            }
        } else {
            foundClass = super.loadClassFromCache(name);
        }
        return foundClass;
    }

    public HashSet getPackageClassLoaders(String name) {
        LoadMgr.PkgClassLoader pkgUcl;
        UnifiedClassLoader3 ucl;
        Iterator iter;
        HashSet pkgSet = super.getPackageClassLoaders(name);
        HashSet parentPkgSet = this.parentRepository.getPackageClassLoaders(name);
        HashSet<LoadMgr.PkgClassLoader> theSet = new HashSet<LoadMgr.PkgClassLoader>();
        if (pkgSet != null) {
            iter = pkgSet.iterator();
            while (iter.hasNext()) {
                ucl = (UnifiedClassLoader3)iter.next();
                pkgUcl = new LoadMgr.PkgClassLoader(ucl, 0);
                theSet.add(pkgUcl);
            }
        }
        if (parentPkgSet != null) {
            iter = parentPkgSet.iterator();
            while (iter.hasNext()) {
                ucl = (UnifiedClassLoader3)iter.next();
                pkgUcl = new LoadMgr.PkgClassLoader(ucl, 1);
                theSet.add(pkgUcl);
            }
        }
        if (!this.java2ParentDelegaton) {
            ClassLoader loader = (class$org$jboss$mx$loading$UnifiedClassLoader3 == null ? (class$org$jboss$mx$loading$UnifiedClassLoader3 = HeirarchicalLoaderRepository3.class$("org.jboss.mx.loading.UnifiedClassLoader3")) : class$org$jboss$mx$loading$UnifiedClassLoader3).getClassLoader();
            ucl = null;
            ucl = loader instanceof UnifiedClassLoader3 ? (UnifiedClassLoader3)loader : new UnifiedClassLoader3(null, null, this);
            pkgUcl = new LoadMgr.PkgClassLoader(ucl, 2);
            theSet.add(pkgUcl);
        }
        return theSet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            DEFAULT_LOADER_NAME = new ObjectName("JMImplementation:service=LoaderRepository,name=Default");
        }
        catch (Exception e) {
            log.error((Object)"Failed to initialize default loader name", (Throwable)e);
        }
    }

    static class NoParentClassLoader
    extends ClassLoader {
        NoParentClassLoader() {
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            throw new ClassNotFoundException("NoParentClassLoader has no classed");
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException("NoParentClassLoader has no classed");
        }
    }
}

