/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoadingTask;
import org.jboss.mx.loading.UnifiedClassLoader3;
import org.jboss.mx.loading.UnifiedLoaderRepository3;

public class LoadMgr {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$mx$loading$LoadMgr == null ? (class$org$jboss$mx$loading$LoadMgr = LoadMgr.class$("org.jboss.mx.loading.LoadMgr")) : class$org$jboss$mx$loading$LoadMgr));
    private static Object registrationLock = new Object();
    private static HashMap loadClassThreads = new HashMap();
    private static Map loadTasksByThread = Collections.synchronizedMap(new WeakHashMap());
    static /* synthetic */ Class class$org$jboss$mx$loading$LoadMgr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLoaderThread(UnifiedClassLoader3 ucl, Thread t) {
        Object object = registrationLock;
        synchronized (object) {
            Thread prevThread = loadClassThreads.put(ucl, t);
            if (log.isTraceEnabled()) {
                log.trace((Object)("registerLoaderThread, ucl=" + ucl + ", t=" + t + ", prevT=" + prevThread));
            }
            Map map = loadTasksByThread;
            synchronized (map) {
                List taskList = (List)loadTasksByThread.get(t);
                if (taskList == null) {
                    taskList = Collections.synchronizedList(new LinkedList());
                    loadTasksByThread.put(t, taskList);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"created new task list");
                    }
                }
            }
            registrationLock.notifyAll();
        }
    }

    public static boolean beginLoadTask(ClassLoadingTask task, UnifiedLoaderRepository3 repository) throws ClassNotFoundException {
        Class cls;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Begin beginLoadTask, task=" + task));
        }
        if ((cls = repository.loadClassFromCache(task.classname)) != null) {
            task.loadedClass = cls;
            task.state = 4;
            if (trace) {
                log.trace((Object)"End beginLoadTask, loadClassFromCache");
            }
            return true;
        }
        HashSet pkgSet = repository.getPackageClassLoaders(task.classname);
        if (pkgSet == null || pkgSet.size() == 0) {
            try {
                cls = repository.loadClassFromClassLoader(task.classname, false, task.requestingClassLoader);
            }
            catch (LinkageError e) {
                if (trace) {
                    log.trace((Object)("End beginLoadTask, LinkageError for task: " + task), (Throwable)e);
                }
                throw e;
            }
            if (cls != null) {
                task.loadedClass = cls;
                task.state = 4;
                if (trace) {
                    log.trace((Object)"End beginLoadTask, loadClassFromClassLoader");
                }
                return true;
            }
            if (trace) {
                log.trace((Object)"End beginLoadTask, ClassNotFoundException");
            }
            String msg = "No ClassLoaders found for: " + task.classname;
            throw new ClassNotFoundException(msg);
        }
        Iterator iter = pkgSet.iterator();
        while (iter.hasNext()) {
            UnifiedClassLoader3 ucl;
            Object next = iter.next();
            int order = 0;
            if (next instanceof UnifiedClassLoader3) {
                ucl = (UnifiedClassLoader3)next;
            } else {
                PkgClassLoader pkgUcl = (PkgClassLoader)next;
                ucl = pkgUcl.ucl;
                order = pkgUcl.order;
            }
            LoadMgr.scheduleTask(task, ucl, order, false, trace);
        }
        task.state = 1;
        if (trace) {
            log.trace((Object)("End beginLoadTask, task=" + task));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nextTask(Thread t, ClassLoadingTask task, UnifiedLoaderRepository3 repository) throws InterruptedException {
        Object object;
        boolean trace = log.isTraceEnabled();
        List taskList = (List)loadTasksByThread.get(t);
        ClassLoadingTask classLoadingTask = task;
        synchronized (classLoadingTask) {
            while (taskList.size() == 0 && task.threadTaskCount != 0) {
                if (trace) {
                    log.trace((Object)("Begin nextTask(WAIT_ON_EVENT), task=" + task));
                }
                try {
                    task.state = 3;
                    task.wait();
                }
                catch (InterruptedException e) {
                    if (trace) {
                        log.trace((Object)("nextTask(WAIT_ON_EVENT), interrupted, task=" + task), (Throwable)e);
                    }
                    throw e;
                }
            }
            if (trace) {
                log.trace((Object)("Continue nextTask(" + taskList.size() + "), task=" + task));
            }
            if (task.threadTaskCount == 0) {
                task.state = 4;
                log.trace((Object)("End nextTask(FINISHED), task=" + task));
                return;
            }
        }
        ClassLoadingTask.ThreadTask threadTask = (ClassLoadingTask.ThreadTask)taskList.remove(0);
        ClassLoadingTask loadTask = threadTask.getLoadTask();
        if (trace) {
            log.trace((Object)("Begin nextTask(" + taskList.size() + "), loadTask=" + loadTask));
        }
        try {
            if (threadTask.t == null) {
                if (trace) {
                    log.trace((Object)("Rescheduling threadTask=" + threadTask));
                }
                LoadMgr.scheduleTask(loadTask, threadTask.ucl, threadTask.order, true, trace);
            } else {
                if (trace) {
                    log.trace((Object)("Running threadTask=" + threadTask));
                }
                threadTask.run();
            }
        }
        catch (Throwable e) {
            loadTask.loadException = e;
        }
        finally {
            if (threadTask.releaseInNextTask) {
                if (trace) {
                    log.trace((Object)("Releasing loadLock and ownership of UCL: " + threadTask.ucl));
                }
                Object object2 = registrationLock;
                synchronized (object2) {
                    loadClassThreads.remove(threadTask.ucl);
                }
                object = threadTask.ucl;
                synchronized (object) {
                    threadTask.ucl.release();
                    threadTask.ucl.notifyAll();
                }
            }
        }
        if (loadTask.threadTaskCount == 0) {
            Class loadedClass;
            block51: {
                loadedClass = threadTask.getLoadedClass();
                if (loadedClass == null) {
                    try {
                        loadTask.loadedClass = loadedClass = repository.loadClassFromClassLoader(task.classname, false, task.requestingClassLoader);
                        if (trace) {
                            log.trace((Object)("nextTask, called loadClassFromClassLoader for task: " + task));
                        }
                    }
                    catch (Throwable e) {
                        if (!trace) break block51;
                        log.trace((Object)("nextTask, failed to loadClassFromClassLoader for task: " + task));
                    }
                }
            }
            if (loadedClass != null) {
                ClassLoader loader = loadedClass.getClassLoader();
                repository.cacheLoadedClass(threadTask.getClassname(), loadedClass, loader);
            }
            object = loadTask;
            synchronized (object) {
                loadTask.state = 4;
                loadTask.notify();
            }
        }
        if (trace) {
            log.trace((Object)("End nextTask(" + taskList.size() + "), loadTask=" + loadTask));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endLoadTask(ClassLoadingTask task) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Begin endLoadTask, task=" + task));
        }
        Object object = registrationLock;
        synchronized (object) {
            loadClassThreads.remove(task.requestingClassLoader);
            registrationLock.notifyAll();
        }
        List taskList = (List)loadTasksByThread.get(task.requestingThread);
        int size = taskList != null ? taskList.size() : 0;
        List list = taskList;
        synchronized (list) {
            int i = 0;
            while (i < size) {
                ClassLoadingTask loadTask;
                ClassLoadingTask.ThreadTask threadTask = (ClassLoadingTask.ThreadTask)taskList.remove(0);
                ClassLoadingTask classLoadingTask = loadTask = threadTask.getLoadTask();
                synchronized (classLoadingTask) {
                    if (trace) {
                        log.trace((Object)("Reassigning task: " + threadTask + ", to: " + loadTask.requestingThread));
                    }
                    threadTask.t = null;
                    List toTaskList = (List)loadTasksByThread.get(loadTask.requestingThread);
                    toTaskList.add(0, threadTask);
                    loadTask.state = 2;
                    loadTask.notify();
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleTask(ClassLoadingTask task, UnifiedClassLoader3 ucl, int order, boolean reschedule, boolean trace) throws ClassNotFoundException {
        Thread t = null;
        boolean releaseInNextTask = false;
        ClassLoadingTask.ThreadTask subtask = null;
        List taskList = null;
        Object object = registrationLock;
        synchronized (object) {
            t = (Thread)loadClassThreads.get(ucl);
            if (t == null) {
                while (t == null && !ucl.attempt(1L)) {
                    if (trace) {
                        log.trace((Object)("Waiting for owner of UCL: " + ucl));
                    }
                    try {
                        registrationLock.wait();
                    }
                    catch (InterruptedException e) {
                        String msg = "Interrupted waiting for registration notify, classame: " + task.classname;
                        throw new ClassNotFoundException(msg);
                    }
                    t = (Thread)loadClassThreads.get(ucl);
                    if (!trace) continue;
                    log.trace((Object)("Notified that UCL owner is: " + t));
                }
                t = (Thread)loadClassThreads.get(ucl);
                if (t == null) {
                    releaseInNextTask = true;
                    t = task.requestingThread;
                    Thread prevThread = loadClassThreads.put(ucl, t);
                    if (trace) {
                        log.trace((Object)("scheduleTask, taking ownership of ucl=" + ucl + ", t=" + t + ", prevT=" + prevThread));
                    }
                }
            }
            subtask = task.newThreadTask(ucl, t, order, reschedule, releaseInNextTask);
            List list = taskList = (List)loadTasksByThread.get(t);
            synchronized (list) {
                taskList.add(subtask);
                Collections.sort(taskList, ClassLoadingTask.taskComparator);
            }
        }
        if (trace) {
            log.trace((Object)("scheduleTask(" + taskList.size() + "), created subtask: " + subtask));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class PkgClassLoader {
        public final UnifiedClassLoader3 ucl;
        public final int order;

        public PkgClassLoader(UnifiedClassLoader3 ucl) {
            this(ucl, Integer.MAX_VALUE);
        }

        public PkgClassLoader(UnifiedClassLoader3 ucl, int order) {
            this.ucl = ucl;
            this.order = order;
        }
    }
}

