/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.server.ServerConstants;

public abstract class LoaderRepository
implements ServerConstants {
    protected static Vector loaders = new Vector();
    protected static LoaderRepository instance = null;
    protected static HashMap nativeClassBySignature = new HashMap();

    public static synchronized LoaderRepository getDefaultLoaderRepository() {
        if (instance != null) {
            return instance;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String className = System.getProperty("jbossmx.loader.repository.class", "org.jboss.mx.loading.UnifiedLoaderRepository3");
        System.setProperty("jbossmx.loader.repository.class", className);
        try {
            Class<?> repository = cl.loadClass(className);
            instance = (LoaderRepository)repository.newInstance();
            return instance;
        }
        catch (ClassNotFoundException e) {
            throw new Error("Cannot instantiate default loader repository class. Class " + className + " not found.");
        }
        catch (ClassCastException e) {
            throw new Error("Cannot instantiate default loader repository class. The target class is not an instance of LoaderRepository interface.");
        }
        catch (Exception e) {
            throw new Error("Error creating default loader repository: " + e.toString());
        }
    }

    public Vector getLoaders() {
        return loaders;
    }

    public URL[] getURLs() {
        return null;
    }

    public abstract UnifiedClassLoader newClassLoader(URL var1, boolean var2) throws Exception;

    public abstract UnifiedClassLoader newClassLoader(URL var1, URL var2, boolean var3) throws Exception;

    public abstract Class loadClass(String var1) throws ClassNotFoundException;

    public abstract Class loadClass(String var1, boolean var2, ClassLoader var3) throws ClassNotFoundException;

    public abstract URL getResource(String var1, ClassLoader var2);

    public abstract void getResources(String var1, ClassLoader var2, List var3);

    public abstract Class loadClassWithout(ClassLoader var1, String var2) throws ClassNotFoundException;

    public abstract void addClassLoader(ClassLoader var1);

    public abstract boolean addClassLoaderURL(ClassLoader var1, URL var2);

    public abstract void removeClassLoader(ClassLoader var1);

    static {
        nativeClassBySignature.put(Boolean.TYPE.getName(), Boolean.TYPE);
        nativeClassBySignature.put(Byte.TYPE.getName(), Byte.TYPE);
        nativeClassBySignature.put(Character.TYPE.getName(), Character.TYPE);
        nativeClassBySignature.put(Double.TYPE.getName(), Double.TYPE);
        nativeClassBySignature.put(Float.TYPE.getName(), Float.TYPE);
        nativeClassBySignature.put(Integer.TYPE.getName(), Integer.TYPE);
        nativeClassBySignature.put(Long.TYPE.getName(), Long.TYPE);
        nativeClassBySignature.put(Short.TYPE.getName(), Short.TYPE);
        nativeClassBySignature.put(Void.TYPE.getName(), Void.TYPE);
    }
}

