/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.UnifiedClassLoaderMBean;

public class UnifiedClassLoader
extends URLClassLoader
implements UnifiedClassLoaderMBean {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$mx$loading$UnifiedClassLoader == null ? (class$org$jboss$mx$loading$UnifiedClassLoader = UnifiedClassLoader.class$("org.jboss.mx.loading.UnifiedClassLoader")) : class$org$jboss$mx$loading$UnifiedClassLoader));
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];
    protected LoaderRepository repository;
    protected URL url;
    protected URL origURL;
    private Map classes;
    static /* synthetic */ Class class$org$jboss$mx$loading$UnifiedClassLoader;

    public UnifiedClassLoader(URL url) {
        this(url, (URL)null);
    }

    public UnifiedClassLoader(URL url, URL origURL) {
        this(url, origURL, (class$org$jboss$mx$loading$UnifiedClassLoader == null ? (class$org$jboss$mx$loading$UnifiedClassLoader = UnifiedClassLoader.class$("org.jboss.mx.loading.UnifiedClassLoader")) : class$org$jboss$mx$loading$UnifiedClassLoader).getClassLoader());
    }

    public UnifiedClassLoader(URL url, URL origURL, ClassLoader parent) {
        URL[] uRLArray;
        if (url == null) {
            uRLArray = new URL[]{};
        } else {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = url;
        }
        super(uRLArray, parent);
        this.repository = null;
        this.url = null;
        this.origURL = null;
        this.classes = new ConcurrentReaderHashMap();
        log.debug((Object)("New jmx UCL with url " + url));
        this.url = url;
        this.origURL = origURL;
    }

    public UnifiedClassLoader(URL url, LoaderRepository repository) {
        this(url, null, repository);
    }

    public UnifiedClassLoader(URL url, URL origURL, LoaderRepository repository) {
        this(url, origURL);
        this.repository = repository;
        repository.addClassLoader(this);
    }

    public UnifiedClassLoader(URL url, MBeanServer server, ObjectName repositoryName) throws Exception {
        this(url, null, server, repositoryName);
    }

    public UnifiedClassLoader(URL url, URL origURL, MBeanServer server, ObjectName repositoryName) throws Exception {
        this(url, origURL);
        this.repository = (LoaderRepository)server.invoke(repositoryName, "registerClassLoader", new Object[]{this}, new String[]{this.getClass().getName()});
    }

    public UnifiedClassLoader(String name, byte[] code) {
        super(new URL[]{}, (class$org$jboss$mx$loading$UnifiedClassLoader == null ? (class$org$jboss$mx$loading$UnifiedClassLoader = UnifiedClassLoader.class$("org.jboss.mx.loading.UnifiedClassLoader")) : class$org$jboss$mx$loading$UnifiedClassLoader).getClassLoader());
        this.repository = null;
        this.url = null;
        this.origURL = null;
        this.classes = new ConcurrentReaderHashMap();
        this.addClass(name, code);
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        String name = "jmx.loading:UCL=" + Integer.toHexString(super.hashCode());
        return new ObjectName(name);
    }

    public void unregister() {
        if (this.repository != null) {
            this.repository.removeClassLoader(this);
        }
    }

    public void addURL(URL url) {
        if (this.repository.addClassLoaderURL(this, url)) {
            log.debug((Object)("Added url: " + url + ", to ucl: " + this));
            super.addURL(url);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Ignoring duplicate url: " + url + ", for ucl: " + this));
        }
    }

    public void addClass(String name, byte[] code) {
        this.classes.put(name, code);
    }

    public void setRepository(LoaderRepository repository) {
        this.repository = repository;
    }

    public Class loadClassLocally(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    public URL getResourceLocally(String name) {
        URL resURL = super.getResource(name);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getResourceLocally(" + this + "), name=" + name + ", resURL:" + resURL));
        }
        return resURL;
    }

    public URL getURL() {
        return this.url;
    }

    public URL getOrigURL() {
        return this.origURL;
    }

    public URL[] getClasspath() {
        return super.getURLs();
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.repository.loadClass(name, resolve, this);
        return c;
    }

    public URL getResource(String name) {
        URL res = this.repository.getResource(name, this);
        return res;
    }

    public Enumeration findResources(String name) throws IOException {
        Vector resURLs = new Vector();
        this.repository.getResources(name, this, resURLs);
        return resURLs.elements();
    }

    public Enumeration findResourcesLocally(String name) throws IOException {
        Enumeration<URL> resURLs = super.findResources(name);
        return resURLs;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object other) {
        return super.equals(other);
    }

    public URL[] getAllURLs() {
        return this.repository.getURLs();
    }

    public URL[] getURLs() {
        return EMPTY_URL_ARRAY;
    }

    public Package getPackage(String name) {
        return super.getPackage(name);
    }

    public Package[] getPackages() {
        return super.getPackages();
    }

    public String toString() {
        return super.toString() + "{ url=" + this.getURL() + " }";
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Object o = this.classes.get(name);
        Class<?> clazz = null;
        if (o != null) {
            byte[] code = (byte[])o;
            this.classes.remove(name);
            clazz = this.defineClass(name, code, 0, code.length);
        } else {
            clazz = super.findClass(name);
        }
        return clazz;
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        CodeSource permCS = cs;
        if (this.origURL != null) {
            permCS = new CodeSource(this.origURL, cs.getCertificates());
        }
        PermissionCollection perms = super.getPermissions(permCS);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getPermissions, url=" + this.url + ", origURL=" + this.origURL + " -> " + perms));
        }
        return perms;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

