/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoadingTask;
import org.jboss.mx.loading.LoadMgr;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.loading.UnifiedClassLoader3MBean;
import org.jboss.mx.loading.UnifiedLoaderRepository3;

public class UnifiedClassLoader3
extends UnifiedClassLoader
implements UnifiedClassLoader3MBean {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$mx$loading$UnifiedClassLoader3 == null ? (class$org$jboss$mx$loading$UnifiedClassLoader3 = UnifiedClassLoader3.class$("org.jboss.mx.loading.UnifiedClassLoader3")) : class$org$jboss$mx$loading$UnifiedClassLoader3));
    protected ReentrantLock loadLock = new ReentrantLock();
    private int loadClassDepth;
    private int addedOrder;
    static /* synthetic */ Class class$org$jboss$mx$loading$UnifiedClassLoader3;

    public UnifiedClassLoader3(URL url) {
        this(url, (URL)null);
    }

    public UnifiedClassLoader3(URL url, URL origURL) {
        super(url, origURL);
    }

    public UnifiedClassLoader3(URL url, URL origURL, LoaderRepository repository) {
        this(url, origURL);
        this.repository = repository;
    }

    public UnifiedClassLoader3(URL url, URL origURL, ClassLoader parent, LoaderRepository repository) {
        super(url, origURL, parent);
        this.repository = repository;
    }

    public void unregister() {
        this.repository.removeClassLoader(this);
    }

    public int getAddedOrder() {
        return this.addedOrder;
    }

    public void setAddedOrder(int addedOrder) {
        this.addedOrder = addedOrder;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer(super.toString());
        tmp.setCharAt(tmp.length() - 1, ',');
        tmp.append("addedOrder=");
        tmp.append(this.addedOrder);
        tmp.append('}');
        return tmp.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        block16: {
            ++this.loadClassDepth;
            trace = UnifiedClassLoader3.log.isTraceEnabled();
            acquired = this.attempt(1L);
            while (!acquired) {
                try {
                    if (trace) {
                        UnifiedClassLoader3.log.trace((Object)"Waiting for loadClass lock");
                    }
                    this.wait();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                acquired = this.attempt(1L);
            }
            task = null;
            try {
                t = Thread.currentThread();
                if (this.loadLock.holds() == 1L) {
                    LoadMgr.registerLoaderThread(this, t);
                }
                if (LoadMgr.beginLoadTask(task = new ClassLoadingTask(name, this, t), ulr3 = (UnifiedLoaderRepository3)this.repository)) ** GOTO lbl26
                while (task.threadTaskCount != 0) {
                    try {
                        LoadMgr.nextTask(t, task, ulr3);
                    }
                    catch (InterruptedException e) {
                    }
                }
            }
            catch (Throwable var9_10) {
                if (this.loadLock.holds() == 1L) {
                    LoadMgr.endLoadTask(task);
                }
                this.release();
                this.notifyAll();
                --this.loadClassDepth;
                throw var9_10;
            }
lbl26:
            // 3 sources

            if (this.loadLock.holds() == 1L) {
                LoadMgr.endLoadTask(task);
            }
            this.release();
            this.notifyAll();
            --this.loadClassDepth;
            break block16;
            ** GOTO lbl26
        }
        if (task.loadedClass == null) {
            if (task.loadException instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)task.loadException;
            }
            if (task.loadException != null) {
                if (UnifiedClassLoader3.log.isTraceEnabled()) {
                    UnifiedClassLoader3.log.trace((Object)("Unexpected error during load of:" + name), task.loadException);
                }
                msg = "Unexpected error during load of: " + name + ", msg=" + task.loadException.getMessage();
                throw new ClassNotFoundException(msg);
            }
            throw new IllegalStateException("ClassLoadingTask.loadedTask is null, name: " + name);
        }
        return task.loadedClass;
    }

    public URL getResource(String name) {
        UnifiedLoaderRepository3 ulr3 = (UnifiedLoaderRepository3)this.repository;
        URL u = this.repository.getResource(name, this);
        return u;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean attempt(long waitMS) {
        boolean acquired = false;
        boolean trace = log.isTraceEnabled();
        Thread.currentThread();
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            try {
                acquired = this.loadLock.attempt(waitMS);
            }
            catch (InterruptedException e) {
                Object var8_6 = null;
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            Object var8_5 = null;
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
        if (trace) {
            log.trace((Object)("attempt(" + this.loadLock.holds() + ") was: " + acquired + " for :" + this));
        }
        return acquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquire() {
        Thread.currentThread();
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            try {
                this.loadLock.acquire();
            }
            catch (InterruptedException e) {
                Object var4_3 = null;
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            Object var4_2 = null;
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("acquired(" + this.loadLock.holds() + ") for :" + this));
        }
    }

    protected void release() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("release(" + this.loadLock.holds() + ") for :" + this));
        }
        this.loadLock.release();
        if (log.isTraceEnabled()) {
            log.trace((Object)("released, holds: " + this.loadLock.holds()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

