/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoaderUtils;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.ResourceInfo;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.loading.UnifiedClassLoader2;
import org.jboss.mx.loading.UnifiedLoaderRepository2MBean;

public class UnifiedLoaderRepository2
extends LoaderRepository
implements NotificationBroadcaster,
UnifiedLoaderRepository2MBean {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$mx$loading$UnifiedLoaderRepository2 == null ? (class$org$jboss$mx$loading$UnifiedLoaderRepository2 = UnifiedLoaderRepository2.class$("org.jboss.mx.loading.UnifiedLoaderRepository2")) : class$org$jboss$mx$loading$UnifiedLoaderRepository2));
    public static final ReentrantLock repositoryLock = new ReentrantLock();
    private HashSet classLoaders = new HashSet();
    private HashSet classLoaderURLs = new HashSet();
    private HashMap classes = new HashMap();
    private HashMap loaderToClassesMap = new HashMap();
    private HashMap loaderToResourcesMap = new HashMap();
    private HashMap globalResources = new HashMap();
    private HashMap packagesMap = new HashMap();
    private HashMap loaderToPackagesMap = new HashMap();
    private long sequenceNumber = 0L;
    private final NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
    private MBeanNotificationInfo[] info;
    static /* synthetic */ Class class$org$jboss$mx$loading$UnifiedLoaderRepository2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean attempt(long waitMS) {
        boolean acquired = false;
        Thread.currentThread();
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            try {
                acquired = repositoryLock.attempt(waitMS);
            }
            catch (InterruptedException e) {
                Object var6_4 = null;
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            Object var6_3 = null;
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
        return acquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acquire() {
        Thread.currentThread();
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            try {
                repositoryLock.acquire();
            }
            catch (InterruptedException e) {
                Object var3_2 = null;
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            Object var3_1 = null;
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
    }

    public static void release() {
        repositoryLock.release();
    }

    public UnifiedClassLoader newClassLoader(URL url, boolean addToRepository) throws Exception {
        UnifiedClassLoader2 ucl = new UnifiedClassLoader2(url, null, this);
        if (addToRepository) {
            UnifiedClassLoader delegate = ucl.getDelegate();
            this.addClassLoader(delegate);
        }
        return ucl;
    }

    public UnifiedClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository) throws Exception {
        UnifiedClassLoader2 ucl = new UnifiedClassLoader2(url, origURL, this);
        if (addToRepository) {
            UnifiedClassLoader delegate = ucl.getDelegate();
            this.addClassLoader(delegate);
        }
        return ucl;
    }

    public Class loadClass(String name, boolean resolve, ClassLoader cl) throws ClassNotFoundException {
        String subname;
        Class cls = this.loadClassFromCache(name, cl);
        if (cls != null) {
            return cls;
        }
        cls = this.loadClassFromClassLoader(name, resolve, cl);
        if (cls != null) {
            return cls;
        }
        cls = this.loadClassFromRepository(name, resolve, cl);
        if (cls == null && name.charAt(0) == '[' && (cls = this.loadClassFromRepository(subname = name.substring(2, name.length() - 1), resolve, cl)) != null) {
            cls = this.loadClassFromRepository(name, resolve, cl);
        }
        if (cls != null) {
            return cls;
        }
        throw new ClassNotFoundException(name);
    }

    private String getResourcePackageName(String rsrcName) {
        int index = rsrcName.lastIndexOf(47);
        String pkgName = rsrcName;
        if (index > 0) {
            pkgName = rsrcName.substring(0, index);
        }
        return pkgName.replace('/', '.');
    }

    private boolean containsClassPackage(String className) {
        String pkgName = ClassLoaderUtils.getPackageName(className);
        return this.packagesMap.containsKey(pkgName);
    }

    private Class loadClassFromCache(String name, ClassLoader cl) {
        Class cls = (Class)this.classes.get(name);
        return cls;
    }

    private void cacheLoadedClass(String name, Class cls, ClassLoader cl) {
        this.classes.put(name, cls);
        HashSet<String> classes = (HashSet<String>)this.loaderToClassesMap.get(cl);
        if (classes == null) {
            classes = new HashSet<String>();
            this.loaderToClassesMap.put(cl, classes);
        }
        classes.add(name);
    }

    private Class loadClassFromClassLoader(String name, boolean resolve, ClassLoader cl) {
        if (cl instanceof UnifiedClassLoader) {
            try {
                Class cls = ((UnifiedClassLoader)cl).loadClassLocally(name, resolve);
                this.cacheLoadedClass(name, cls, cl);
                return cls;
            }
            catch (ClassNotFoundException x) {
            }
        }
        return null;
    }

    private Class loadClassFromRepository(String name, boolean resolve, ClassLoader cl) {
        String pkgName = ClassLoaderUtils.getPackageName(name);
        HashSet pkgSet = (HashSet)this.packagesMap.get(pkgName);
        if (pkgSet == null) {
            return null;
        }
        Iterator i = pkgSet.iterator();
        while (i.hasNext()) {
            ClassLoader classloader = (ClassLoader)i.next();
            if (classloader.equals(cl) || !(classloader instanceof UnifiedClassLoader)) continue;
            try {
                UnifiedClassLoader ucl = (UnifiedClassLoader)classloader;
                Class cls = ucl.loadClassLocally(name, resolve);
                this.cacheLoadedClass(name, cls, classloader);
                return cls;
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    public URL getResource(String name, ClassLoader cl) {
        URL resource = this.getResourceFromCache(name, cl);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromClassLoader(name, cl);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromGlobalCache(name);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromRepository(name, cl);
        if (resource != null) {
            return resource;
        }
        return null;
    }

    public void getResources(String name, ClassLoader cl, List urls) {
    }

    private URL getResourceFromCache(String name, ClassLoader cl) {
        if (this.loaderToResourcesMap.containsKey(cl)) {
            HashMap resources = (HashMap)this.loaderToResourcesMap.get(cl);
            return (URL)resources.get(name);
        }
        return null;
    }

    private URL getResourceFromClassLoader(String name, ClassLoader cl) {
        if (cl instanceof UnifiedClassLoader) {
            URL url = ((UnifiedClassLoader)cl).getResourceLocally(name);
            this.cacheLoadedResource(name, url, cl);
            return url;
        }
        return null;
    }

    private URL getResourceFromGlobalCache(String name) {
        ResourceInfo ri = (ResourceInfo)this.globalResources.get(name);
        if (ri != null) {
            return ri.url;
        }
        return null;
    }

    private URL getResourceFromRepository(String name, ClassLoader cl) {
        String pkgName = this.getResourcePackageName(name);
        HashSet pkgSet = (HashSet)this.packagesMap.get(pkgName);
        Iterator i = pkgSet != null ? pkgSet.iterator() : this.classLoaders.iterator();
        while (i.hasNext()) {
            URL url;
            ClassLoader classloader = (ClassLoader)i.next();
            if (classloader.equals(cl) || !(classloader instanceof UnifiedClassLoader) || (url = ((UnifiedClassLoader)classloader).getResourceLocally(name)) == null) continue;
            this.cacheLoadedResource(name, url, classloader);
            this.cacheGlobalResource(name, url, classloader);
            return url;
        }
        return null;
    }

    private void cacheLoadedResource(String name, URL url, ClassLoader cl) {
        HashMap<String, URL> resources = (HashMap<String, URL>)this.loaderToResourcesMap.get(cl);
        if (resources == null) {
            resources = new HashMap<String, URL>();
            this.loaderToResourcesMap.put(cl, resources);
        }
        resources.put(name, url);
    }

    private void cacheGlobalResource(String name, URL url, ClassLoader cl) {
        this.globalResources.put(name, new ResourceInfo(url, cl));
    }

    public URL[] getURLs() {
        HashSet<URL> classpath = new HashSet<URL>();
        HashSet tmp = (HashSet)this.classLoaders.clone();
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof UnifiedClassLoader)) continue;
            UnifiedClassLoader cl = (UnifiedClassLoader)obj;
            URL[] urls = cl.getClasspath();
            int length = urls != null ? urls.length : 0;
            int u = 0;
            while (u < length) {
                URL path = urls[u];
                classpath.add(path);
                ++u;
            }
        }
        URL[] cp = new URL[classpath.size()];
        classpath.toArray(cp);
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader scl = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = null;
        UnifiedLoaderRepository2.acquire();
        try {
            try {
                clazz = this.loadClass(className, false, scl);
            }
            catch (ClassNotFoundException e) {
                if (scl instanceof UnifiedClassLoader) throw e;
                clazz = scl.loadClass(className);
                Object var6_5 = null;
                UnifiedLoaderRepository2.release();
                return clazz;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            UnifiedLoaderRepository2.release();
            throw throwable;
        }
        UnifiedLoaderRepository2.release();
        return clazz;
    }

    public Class findClass(String name) {
        String classRsrcName = name.replace('.', '/') + ".class";
        HashSet tmp = (HashSet)this.classLoaders.clone();
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            ClassLoader cl = (ClassLoader)iter.next();
            URL classURL = cl.getResource(classRsrcName);
            log.trace((Object)("Checking CL for URL: " + classURL));
            if (classURL == null) continue;
            try {
                Class<?> cls = cl.loadClass(name);
                log.trace((Object)("Found class in: " + cls.getProtectionDomain()));
                return cls;
            }
            catch (ClassNotFoundException e) {
                log.debug((Object)("Failed to load class: " + name), (Throwable)e);
            }
        }
        log.trace((Object)"Class not found");
        return null;
    }

    public Class loadClassWithout(ClassLoader loader, String className) throws ClassNotFoundException {
        throw new ClassNotFoundException("NYI");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassLoader(ClassLoader loader) {
        UnifiedLoaderRepository2.acquire();
        try {
            if (loader instanceof UnifiedClassLoader) {
                this.addUnifiedClassLoader((UnifiedClassLoader)loader);
            } else if (loader instanceof URLClassLoader) {
                URLClassLoader ucl = (URLClassLoader)loader;
                URL[] urls = ucl.getURLs();
                int i = 0;
                while (i < urls.length) {
                    this.addUnifiedClassLoader(new UnifiedClassLoader(urls[i], this));
                    ++i;
                }
            } else {
                log.warn((Object)"Tried to add non- URLClassLoader.  Ignored");
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            UnifiedLoaderRepository2.release();
            throw throwable;
        }
        UnifiedLoaderRepository2.release();
    }

    public boolean addClassLoaderURL(ClassLoader cl, URL url) {
        return false;
    }

    private void addUnifiedClassLoader(UnifiedClassLoader cl) {
        cl.setRepository(this);
        URL url = cl.getURL();
        boolean added = false;
        boolean exists = this.classLoaderURLs.contains(url);
        if (!exists) {
            this.classLoaderURLs.add(url);
            added = this.classLoaders.add(cl);
        }
        if (added) {
            log.debug((Object)("Adding " + cl));
            this.updatePackageMap(cl);
        } else {
            log.debug((Object)("Skipping duplicate " + cl));
        }
    }

    private void updatePackageMap(UnifiedClassLoader cl) {
        block3: {
            try {
                String[] pkgNames = ClassLoaderUtils.updatePackageMap(cl, this.packagesMap);
                this.loaderToPackagesMap.put(cl, pkgNames);
            }
            catch (Exception e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Failed to update pkgs for cl=" + cl), (Throwable)e);
                    break block3;
                }
                log.debug((Object)("Failed to update pkgs for cl=" + cl), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassLoader(ClassLoader cl) {
        UnifiedLoaderRepository2.acquire();
        try {
            String[] pkgNames;
            HashMap resources;
            HashSet loaded;
            if (cl instanceof UnifiedClassLoader) {
                UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
                URL url = ucl.getURL();
                this.classLoaderURLs.remove(url);
            }
            boolean removed = this.classLoaders.remove(cl);
            log.debug((Object)("UnifiedLoaderRepository removed(" + removed + ") " + cl));
            if (this.loaderToClassesMap.containsKey(cl) && (loaded = (HashSet)this.loaderToClassesMap.remove(cl)) != null) {
                Iterator iter = loaded.iterator();
                while (iter.hasNext()) {
                    this.broadcaster.sendNotification(new Notification("jboss.mx.class.removed", (Object)this, this.getNextSequenceNumber(), (String)iter.next()));
                }
                Iterator i = loaded.iterator();
                while (i.hasNext()) {
                    String cls = (String)i.next();
                    this.classes.remove(cls);
                }
            }
            if (this.loaderToResourcesMap.containsKey(cl) && (resources = (HashMap)this.loaderToResourcesMap.remove(cl)) != null) {
                Iterator i = resources.keySet().iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    ResourceInfo ri = (ResourceInfo)this.globalResources.get(name);
                    if (ri == null || ri.cl != cl) continue;
                    this.globalResources.remove(name);
                }
            }
            int length = (pkgNames = (String[])this.loaderToPackagesMap.remove(cl)) != null ? pkgNames.length : 0;
            int p = 0;
            while (p < length) {
                String pkgName = pkgNames[p];
                HashSet pkgSet = (HashSet)this.packagesMap.get(pkgName);
                if (pkgSet != null) {
                    pkgSet.remove(cl);
                    if (pkgSet.isEmpty()) {
                        this.packagesMap.remove(pkgName);
                    }
                }
                ++p;
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            UnifiedLoaderRepository2.release();
            throw throwable;
        }
        UnifiedLoaderRepository2.release();
    }

    public LoaderRepository registerClassLoader(UnifiedClassLoader ucl) {
        this.addClassLoader(ucl);
        Notification msg = new Notification("jboss.mx.classloader.added", this, this.getNextSequenceNumber());
        msg.setUserData(ucl);
        this.broadcaster.sendNotification(msg);
        return this;
    }

    public LoaderRepository getInstance() {
        return this;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.info == null) {
            this.info = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"CLASSLOADER_ADDED"}, "javax.management.Notification", "Notification that a classloader has been added to the extensible classloader"), new MBeanNotificationInfo(new String[]{"CLASS_REMOVED"}, "javax.management.Notification", "Notification that a class has been removed from the extensible classloader")};
        }
        return this.info;
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    private long getNextSequenceNumber() {
        return this.sequenceNumber++;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

