/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoaderUtils;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.ResourceInfo;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.loading.UnifiedClassLoader3;
import org.jboss.mx.loading.UnifiedLoaderRepository3MBean;

public class UnifiedLoaderRepository3
extends LoaderRepository
implements NotificationBroadcaster,
UnifiedLoaderRepository3MBean {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$mx$loading$UnifiedLoaderRepository3 == null ? (class$org$jboss$mx$loading$UnifiedLoaderRepository3 = UnifiedLoaderRepository3.class$("org.jboss.mx.loading.UnifiedLoaderRepository3")) : class$org$jboss$mx$loading$UnifiedLoaderRepository3));
    private static int addedCount;
    private HashSet classLoaders = new HashSet();
    private HashSet classLoaderURLs = new HashSet();
    private HashMap classes = new HashMap();
    private HashMap loaderToClassesMap = new HashMap();
    private HashMap loaderToResourcesMap = new HashMap();
    private HashMap globalResources = new HashMap();
    private HashMap packagesMap = new HashMap();
    private HashMap loaderToPackagesMap = new HashMap();
    private long sequenceNumber = 0L;
    private final NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
    private MBeanNotificationInfo[] info;
    static /* synthetic */ Class class$org$jboss$mx$loading$UnifiedLoaderRepository3;

    public UnifiedClassLoader newClassLoader(URL url, boolean addToRepository) throws Exception {
        UnifiedClassLoader3 ucl = new UnifiedClassLoader3(url, null, this);
        if (addToRepository) {
            this.registerClassLoader(ucl);
        }
        return ucl;
    }

    public UnifiedClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository) throws Exception {
        UnifiedClassLoader3 ucl = new UnifiedClassLoader3(url, origURL, this);
        if (addToRepository) {
            this.registerClassLoader(ucl);
        }
        return ucl;
    }

    public Class loadClass(String name, boolean resolve, ClassLoader cl) throws ClassNotFoundException {
        UnifiedClassLoader3 ucl = (UnifiedClassLoader3)cl;
        return ucl.loadClass(name, resolve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet getPackageClassLoaders(String className) {
        String pkgName = ClassLoaderUtils.getPackageName(className);
        HashSet pkgSet = null;
        HashMap hashMap = this.packagesMap;
        synchronized (hashMap) {
            pkgSet = (HashSet)this.packagesMap.get(pkgName);
        }
        return pkgSet;
    }

    private String getResourcePackageName(String rsrcName) {
        int index = rsrcName.lastIndexOf(47);
        String pkgName = rsrcName;
        if (index > 0) {
            pkgName = rsrcName.substring(0, index);
        }
        return pkgName.replace('/', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClassFromCache(String name) {
        Class cls = null;
        HashMap hashMap = this.classes;
        synchronized (hashMap) {
            cls = (Class)this.classes.get(name);
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheLoadedClass(String name, Class cls, ClassLoader cl) {
        HashMap hashMap = this.classes;
        synchronized (hashMap) {
            this.classes.put(name, cls);
            HashSet<String> classes = (HashSet<String>)this.loaderToClassesMap.get(cl);
            if (classes == null) {
                classes = new HashSet<String>();
                this.loaderToClassesMap.put(cl, classes);
            }
            classes.add(name);
        }
    }

    Class loadClassFromClassLoader(String name, boolean resolve, UnifiedClassLoader cl) {
        if (cl instanceof UnifiedClassLoader) {
            try {
                Class cls = cl.loadClassLocally(name, resolve);
                this.cacheLoadedClass(name, cls, cl);
                return cls;
            }
            catch (ClassNotFoundException x) {
            }
        }
        return null;
    }

    public URL getResource(String name, ClassLoader cl) {
        URL resource = this.getResourceFromCache(name, cl);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromClassLoader(name, cl);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromGlobalCache(name);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromRepository(name, cl);
        if (resource != null) {
            return resource;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getResources(String name, ClassLoader cl, List urls) {
        HashSet tmpClassLoaders;
        HashSet hashSet = this.classLoaders;
        synchronized (hashSet) {
            tmpClassLoaders = new HashSet(this.classLoaders);
        }
        Iterator iter = tmpClassLoaders.iterator();
        while (iter.hasNext()) {
            ClassLoader nextCL = (ClassLoader)iter.next();
            if (!(nextCL instanceof UnifiedClassLoader)) continue;
            UnifiedClassLoader ucl = (UnifiedClassLoader)nextCL;
            try {
                Enumeration resURLs = ucl.findResourcesLocally(name);
                while (resURLs.hasMoreElements()) {
                    Object res = resURLs.nextElement();
                    urls.add(res);
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getResourceFromCache(String name, ClassLoader cl) {
        URL resource = null;
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            if (this.loaderToResourcesMap.containsKey(cl)) {
                HashMap resources = (HashMap)this.loaderToResourcesMap.get(cl);
                resource = (URL)resources.get(name);
            }
        }
        return resource;
    }

    private URL getResourceFromClassLoader(String name, ClassLoader cl) {
        URL resource = null;
        if (cl instanceof UnifiedClassLoader) {
            UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
            resource = ucl.getResourceLocally(name);
            this.cacheLoadedResource(name, resource, cl);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getResourceFromGlobalCache(String name) {
        ResourceInfo ri = null;
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            ri = (ResourceInfo)this.globalResources.get(name);
        }
        URL resource = null;
        if (ri != null) {
            resource = ri.url;
        }
        return resource;
    }

    private URL getResourceFromRepository(String name, ClassLoader cl) {
        String pkgName = this.getResourcePackageName(name);
        HashSet pkgSet = (HashSet)this.packagesMap.get(pkgName);
        Iterator i = pkgSet != null ? pkgSet.iterator() : this.classLoaders.iterator();
        URL url = null;
        while (i.hasNext()) {
            ClassLoader classloader = (ClassLoader)i.next();
            if (classloader.equals(cl) || !(classloader instanceof UnifiedClassLoader) || (url = ((UnifiedClassLoader)classloader).getResourceLocally(name)) == null) continue;
            this.cacheLoadedResource(name, url, classloader);
            this.cacheGlobalResource(name, url, classloader);
            break;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheLoadedResource(String name, URL url, ClassLoader cl) {
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            HashMap<String, URL> resources = (HashMap<String, URL>)this.loaderToResourcesMap.get(cl);
            if (resources == null) {
                resources = new HashMap<String, URL>();
                this.loaderToResourcesMap.put(cl, resources);
            }
            resources.put(name, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheGlobalResource(String name, URL url, ClassLoader cl) {
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            this.globalResources.put(name, new ResourceInfo(url, cl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getURLs() {
        HashSet<URL> classpath = new HashSet<URL>();
        HashSet tmp = null;
        HashSet hashSet = this.classLoaders;
        synchronized (hashSet) {
            tmp = (HashSet)this.classLoaders.clone();
        }
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof UnifiedClassLoader)) continue;
            UnifiedClassLoader cl = (UnifiedClassLoader)obj;
            URL[] urls = cl.getClasspath();
            int length = urls != null ? urls.length : 0;
            int u = 0;
            while (u < length) {
                URL path = urls[u];
                classpath.add(path);
                ++u;
            }
        }
        URL[] cp = new URL[classpath.size()];
        classpath.toArray(cp);
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String displayClassInfo(String className) {
        String classRsrcName = className.replace('.', '/') + ".class";
        int count = 0;
        Class loadedClass = this.loadClassFromCache(className);
        StringBuffer results = new StringBuffer(className + " Information\n");
        if (loadedClass != null) {
            results.append("Repository cache version:");
            ClassLoaderUtils.displayClassInfo(loadedClass, results);
        } else {
            results.append("Not loaded in repository cache\n");
        }
        HashSet tmp = null;
        HashSet hashSet = this.classLoaders;
        synchronized (hashSet) {
            tmp = (HashSet)this.classLoaders.clone();
        }
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            URLClassLoader cl = (URLClassLoader)iter.next();
            URL classURL = cl.findResource(classRsrcName);
            if (classURL == null) continue;
            results.append("\n\n### Instance" + count + " found in UCL: " + cl + "\n");
            ++count;
        }
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        URLClassLoader[] stack = ClassLoaderUtils.getClassLoaderStack(tcl);
        int s = 0;
        while (s < stack.length) {
            URLClassLoader cl = stack[s];
            URL classURL = cl.findResource(classRsrcName);
            if (classURL != null) {
                results.append("\n\n### Instance" + count + " via UCL: " + cl + "\n");
                ++count;
            }
            ++s;
        }
        return results.toString();
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader scl = Thread.currentThread().getContextClassLoader();
        Class clazz = null;
        clazz = scl instanceof UnifiedClassLoader3 ? this.loadClass(className, false, scl) : scl.loadClass(className);
        return clazz;
    }

    public Class loadClassWithout(ClassLoader loader, String className) throws ClassNotFoundException {
        throw new ClassNotFoundException("NYI");
    }

    public void addClassLoader(ClassLoader loader) {
        if (loader instanceof UnifiedClassLoader) {
            this.addUnifiedClassLoader((UnifiedClassLoader3)loader);
        } else if (loader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)loader;
            URL[] urls = ucl.getURLs();
            int i = 0;
            while (i < urls.length) {
                UnifiedClassLoader3 ucl3 = new UnifiedClassLoader3(urls[i], urls[i], this);
                this.addUnifiedClassLoader(ucl3);
                ++i;
            }
        } else {
            log.warn((Object)"Tried to add non-URLClassLoader.  Ignored");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addClassLoaderURL(ClassLoader cl, URL url) {
        UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
        boolean added = false;
        HashSet hashSet = this.classLoaders;
        synchronized (hashSet) {
            if (!this.classLoaderURLs.contains(url)) {
                this.updatePackageMap(ucl, url);
                this.classLoaderURLs.add(url);
                added = true;
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnifiedClassLoader(UnifiedClassLoader3 cl) {
        cl.setRepository(this);
        URL url = cl.getURL();
        boolean added = false;
        HashSet hashSet = this.classLoaders;
        synchronized (hashSet) {
            boolean exists = this.classLoaderURLs.contains(url);
            if (!exists) {
                this.classLoaderURLs.add(url);
                added = this.classLoaders.add(cl);
            }
            if (added) {
                log.debug((Object)("Adding " + cl));
                cl.setAddedOrder(++addedCount);
                this.updatePackageMap(cl);
            } else {
                log.debug((Object)("Skipping duplicate " + cl));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePackageMap(UnifiedClassLoader cl) {
        block6: {
            try {
                HashMap hashMap = this.packagesMap;
                synchronized (hashMap) {
                    String[] pkgNames = ClassLoaderUtils.updatePackageMap(cl, this.packagesMap);
                    this.loaderToPackagesMap.put(cl, pkgNames);
                }
            }
            catch (Exception e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Failed to update pkgs for cl=" + cl), (Throwable)e);
                    break block6;
                }
                log.debug((Object)("Failed to update pkgs for cl=" + cl), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePackageMap(UnifiedClassLoader cl, URL url) {
        block6: {
            try {
                HashMap hashMap = this.packagesMap;
                synchronized (hashMap) {
                    String[] prevPkgNames = (String[])this.loaderToPackagesMap.get(cl);
                    String[] pkgNames = ClassLoaderUtils.updatePackageMap(cl, this.packagesMap, url, prevPkgNames);
                    this.loaderToPackagesMap.put(cl, pkgNames);
                }
            }
            catch (Exception e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Failed to update pkgs for cl=" + cl), (Throwable)e);
                    break block6;
                }
                log.debug((Object)("Failed to update pkgs for cl=" + cl), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassLoader(ClassLoader cl) {
        Notification msg;
        ArrayList<Notification> removeNotifications = new ArrayList<Notification>();
        HashSet hashSet = this.classLoaders;
        synchronized (hashSet) {
            if (cl instanceof UnifiedClassLoader) {
                UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
                URL[] urls = ucl.getClasspath();
                int u = 0;
                while (u < urls.length) {
                    this.classLoaderURLs.remove(urls[u]);
                    ++u;
                }
            }
            boolean removed = this.classLoaders.remove(cl);
            log.debug((Object)("UnifiedLoaderRepository removed(" + removed + ") " + cl));
            HashSet loadedClasses = null;
            boolean hasLoadedClasses = false;
            HashMap hashMap = this.classes;
            synchronized (hashMap) {
                hasLoadedClasses = this.loaderToClassesMap.containsKey(cl);
                if (hasLoadedClasses) {
                    loadedClasses = (HashSet)this.loaderToClassesMap.remove(cl);
                }
                if (loadedClasses != null) {
                    Iterator iter = loadedClasses.iterator();
                    while (iter.hasNext()) {
                        String className = (String)iter.next();
                        Notification n = new Notification("jboss.mx.class.removed", (Object)this, this.getNextSequenceNumber(), className);
                        removeNotifications.add(n);
                    }
                    Iterator i = loadedClasses.iterator();
                    while (i.hasNext()) {
                        String cls = (String)i.next();
                        this.classes.remove(cls);
                    }
                }
            }
            HashMap hashMap2 = this.loaderToResourcesMap;
            synchronized (hashMap2) {
                HashMap resources;
                if (this.loaderToResourcesMap.containsKey(cl) && (resources = (HashMap)this.loaderToResourcesMap.remove(cl)) != null) {
                    Iterator i = resources.keySet().iterator();
                    while (i.hasNext()) {
                        String name = (String)i.next();
                        ResourceInfo ri = (ResourceInfo)this.globalResources.get(name);
                        if (ri == null || ri.cl != cl) continue;
                        this.globalResources.remove(name);
                    }
                }
            }
            HashMap hashMap3 = this.packagesMap;
            synchronized (hashMap3) {
                String[] pkgNames = (String[])this.loaderToPackagesMap.remove(cl);
                int length = pkgNames != null ? pkgNames.length : 0;
                int p = 0;
                while (p < length) {
                    String pkgName = pkgNames[p];
                    HashSet pkgSet = (HashSet)this.packagesMap.get(pkgName);
                    if (pkgSet != null) {
                        pkgSet.remove(cl);
                        if (pkgSet.isEmpty()) {
                            this.packagesMap.remove(pkgName);
                        }
                    }
                    ++p;
                }
            }
        }
        int n = 0;
        while (n < removeNotifications.size()) {
            msg = (Notification)removeNotifications.get(n);
            this.broadcaster.sendNotification(msg);
            ++n;
        }
        msg = new Notification("jboss.mx.classloader.removed", this, this.getNextSequenceNumber());
        msg.setUserData(cl);
        this.broadcaster.sendNotification(msg);
    }

    public LoaderRepository registerClassLoader(UnifiedClassLoader ucl) {
        this.addClassLoader(ucl);
        Notification msg = new Notification("jboss.mx.classloader.added", this, this.getNextSequenceNumber());
        msg.setUserData(ucl);
        this.broadcaster.sendNotification(msg);
        return this;
    }

    public LoaderRepository getInstance() {
        return this;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.info == null) {
            this.info = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"CLASSLOADER_ADDED"}, "javax.management.Notification", "Notification that a classloader has been added to the extensible classloader"), new MBeanNotificationInfo(new String[]{"CLASS_REMOVED"}, "javax.management.Notification", "Notification that a class has been removed from the extensible classloader")};
        }
        return this.info;
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    private synchronized long getNextSequenceNumber() {
        return this.sequenceNumber++;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

