/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.jboss.logging.Logger;
import org.jboss.mx.metadata.AbstractBuilder;
import org.jboss.mx.metadata.IllegalPropertyException;
import org.jboss.mx.metadata.XMBeanEntityResolver;
import org.jboss.mx.modelmbean.XMBeanConstants;
import org.jboss.util.Strings;
import org.jboss.util.propertyeditor.PropertyEditors;
import org.jdom.Attribute;
import org.jdom.JDOMException;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class JBossXMBean10
extends AbstractBuilder
implements XMBeanConstants {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$mx$metadata$JBossXMBean10 == null ? (class$org$jboss$mx$metadata$JBossXMBean10 = JBossXMBean10.class$("org.jboss.mx.metadata.JBossXMBean10")) : class$org$jboss$mx$metadata$JBossXMBean10));
    private URL url = null;
    private Element element;
    private String mmbClassName = null;
    private String resourceClassName = null;
    private static final Map PRIMITIVE_NAME_TYPE_MAP = new HashMap();
    static /* synthetic */ Class class$org$jboss$mx$metadata$JBossXMBean10;

    public JBossXMBean10(String mmbClassName, String resourceClassName, URL url) {
        this.url = url;
        this.mmbClassName = mmbClassName;
        this.resourceClassName = resourceClassName;
    }

    public JBossXMBean10(String mmbClassName, String resourceClassName, String url) throws MalformedURLException {
        this(mmbClassName, resourceClassName, new URL(url));
    }

    public JBossXMBean10(String mmbClassName, String resourceClassName, URL url, Map properties) {
        this(mmbClassName, resourceClassName, url);
        this.setProperties(properties);
    }

    public JBossXMBean10(String mmbClassName, String resourceClassName, String url, Map properties) throws MalformedURLException {
        this(mmbClassName, resourceClassName, new URL(url), properties);
    }

    public JBossXMBean10(String mmbClassName, String resourceClassName, Element element) {
        this.mmbClassName = mmbClassName;
        this.resourceClassName = resourceClassName;
        this.element = element;
    }

    public MBeanInfo build() throws NotCompliantMBeanException {
        try {
            DOMBuilder builder;
            org.jdom.Element root = null;
            if (this.element == null) {
                builder = null;
                builder = this.properties.get("xmbean.metadata.sax.parser") != null ? new SAXBuilder(this.getStringProperty("xmbean.metadata.sax.parser")) : new SAXBuilder();
                builder.setValidation(true);
                try {
                    boolean validate = this.getBooleanProperty("xmbean.metadata.xml.validate");
                    builder.setValidation(validate);
                }
                catch (IllegalPropertyException e) {
                    // empty catch block
                }
                builder.setEntityResolver((EntityResolver)new XMBeanEntityResolver());
                InputStream docStream = this.url.openStream();
                root = builder.build(docStream).getRootElement();
                docStream.close();
            } else {
                builder = new DOMBuilder();
                root = builder.build(this.element);
            }
            String description = root.getChildText("description");
            if (this.resourceClassName == null) {
                this.resourceClassName = root.getChildText("class");
            }
            List constructors = root.getChildren("constructor");
            List operations = root.getChildren("operation");
            List attributes = root.getChildren("attribute");
            List notifications = root.getChildren("notifications");
            Descriptor descr = this.getDescriptor(root, this.resourceClassName, "mbean");
            ModelMBeanInfo info = this.buildMBeanMetaData(description, constructors, operations, attributes, notifications, descr);
            return (MBeanInfo)((Object)info);
        }
        catch (JDOMException e) {
            Throwable cause = e.getCause();
            String msg = "DOM exception while parsing url:" + this.url + " cause: " + (cause == null ? e.toString() : cause.toString());
            log.debug((Object)msg, (Throwable)e);
            throw new NotCompliantMBeanException(msg);
        }
        catch (IOException e) {
            String msg = "IO Error parsing the XML file: " + this.url + " cause: " + e.toString();
            log.debug((Object)msg, (Throwable)e);
            throw new NotCompliantMBeanException(msg);
        }
    }

    protected Descriptor getDescriptor(org.jdom.Element parent, String infoName, String type) throws NotCompliantMBeanException {
        DescriptorSupport descr = new DescriptorSupport();
        descr.setField("name", infoName);
        descr.setField("descriptorType", type);
        org.jdom.Element descriptors = parent.getChild("descriptors");
        if (descriptors == null) {
            return descr;
        }
        Iterator i = descriptors.getChildren().iterator();
        while (i.hasNext()) {
            String value;
            org.jdom.Element descriptor = (org.jdom.Element)i.next();
            String name = descriptor.getName();
            if (name.equals("persistence")) {
                Attribute persistPolicy = descriptor.getAttribute("persistPolicy");
                Attribute persistPeriod = descriptor.getAttribute("persistPeriod");
                Attribute persistLocation = descriptor.getAttribute("persistLocation");
                Attribute persistName = descriptor.getAttribute("persistName");
                if (persistPolicy != null) {
                    String value2 = persistPolicy.getValue();
                    this.validate(value2, XMBeanConstants.PERSIST_POLICY_LIST);
                    descr.setField("persistPolicy", value2);
                }
                if (persistPeriod != null) {
                    descr.setField("persistPeriod", persistPeriod.getValue());
                }
                if (persistLocation != null) {
                    descr.setField("persistLocation", persistLocation.getValue());
                }
                if (persistName == null) continue;
                descr.setField("persistName", persistName.getValue());
                continue;
            }
            if (name.equals("currencyTimeLimit")) {
                descr.setField("currencyTimeLimit", descriptor.getAttributeValue("value"));
                continue;
            }
            if (name.equals("state-action-on-update")) {
                value = descriptor.getAttributeValue("value");
                this.validate(value, XMBeanConstants.STATE_ACTION_ON_UPDATE_LIST);
                descr.setField("state-action-on-update", value);
                continue;
            }
            if (name.equals("default")) {
                value = descriptor.getAttributeValue("value");
                descr.setField("default", value);
                continue;
            }
            if (name.equals("value")) {
                value = descriptor.getAttributeValue("value");
                descr.setField("value", value);
                continue;
            }
            if (name.equals("persistence-manager")) {
                descr.setField("persistence-manager", descriptor.getAttributeValue("value"));
                continue;
            }
            if (name.equals("descriptor")) {
                descr.setField(descriptor.getAttributeValue("name"), descriptor.getAttributeValue("value"));
                continue;
            }
            if (!name.equals("interceptors")) continue;
            Descriptor[] interceptorDescriptors = this.buildInterceptors(descriptor);
            descr.setField("interceptors", interceptorDescriptors);
        }
        return descr;
    }

    private void validate(String value, String[] valid) throws NotCompliantMBeanException {
        int i = 0;
        while (i < valid.length) {
            if (valid[i].equalsIgnoreCase(value)) {
                return;
            }
            ++i;
        }
        throw new NotCompliantMBeanException("Unknown descriptor value: " + value);
    }

    protected ModelMBeanInfo buildMBeanMetaData(String description, List constructors, List operations, List attributes, List notifications, Descriptor descr) throws NotCompliantMBeanException {
        ModelMBeanOperationInfo[] operInfo = this.buildOperationInfo(operations, attributes);
        ModelMBeanAttributeInfo[] attrInfo = this.buildAttributeInfo(attributes);
        ModelMBeanConstructorInfo[] constrInfo = this.buildConstructorInfo(constructors);
        ModelMBeanNotificationInfo[] notifInfo = this.buildNotificationInfo(notifications);
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(this.mmbClassName, description, attrInfo, constrInfo, operInfo, notifInfo, descr);
        return info;
    }

    protected ModelMBeanConstructorInfo[] buildConstructorInfo(List constructors) throws NotCompliantMBeanException {
        ArrayList<ModelMBeanConstructorInfo> infos = new ArrayList<ModelMBeanConstructorInfo>();
        Iterator it = constructors.iterator();
        while (it.hasNext()) {
            org.jdom.Element constr = (org.jdom.Element)it.next();
            String name = constr.getChildTextTrim("name");
            String description = constr.getChildTextTrim("description");
            List params = constr.getChildren("parameter");
            MBeanParameterInfo[] paramInfo = this.buildParameterInfo(params);
            Descriptor descr = this.getDescriptor(constr, name, "constructor");
            ModelMBeanConstructorInfo info = new ModelMBeanConstructorInfo(name, description, paramInfo, descr);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanConstructorInfo[0]);
    }

    protected ModelMBeanOperationInfo[] buildOperationInfo(List operations, List attributes) throws NotCompliantMBeanException {
        String type;
        ArrayList<ModelMBeanOperationInfo> infos = new ArrayList<ModelMBeanOperationInfo>();
        HashMap<String, String> getters = new HashMap<String, String>();
        HashMap<String, HashSet<String>> setters = new HashMap<String, HashSet<String>>();
        Iterator it = operations.iterator();
        while (it.hasNext()) {
            org.jdom.Element oper = (org.jdom.Element)it.next();
            String name = oper.getChildTextTrim("name");
            String description = oper.getChildTextTrim("description");
            type = oper.getChildTextTrim("return-type");
            String impact = oper.getAttributeValue("impact");
            List params = oper.getChildren("parameter");
            MBeanParameterInfo[] paramInfo = this.buildParameterInfo(params);
            Descriptor descr = this.getDescriptor(oper, name, "operation");
            int operImpact = 2;
            if (impact != null) {
                if (impact.equals("INFO")) {
                    operImpact = 0;
                } else if (impact.equals("ACTION")) {
                    operImpact = 1;
                } else if (impact.equals("ACTION_INFO")) {
                    operImpact = 2;
                }
            }
            if (type == null) {
                type = "void";
            }
            if (paramInfo.length == 0 && !type.equals("void")) {
                getters.put(name, type);
            }
            if (paramInfo.length == 1) {
                HashSet<String> types = (HashSet<String>)setters.get(name);
                if (types == null) {
                    types = new HashSet<String>();
                    setters.put(name, types);
                }
                types.add(paramInfo[0].getType());
            }
            ModelMBeanOperationInfo info = new ModelMBeanOperationInfo(name, description, paramInfo, type, operImpact, descr);
            infos.add(info);
        }
        Iterator it2 = attributes.iterator();
        while (it2.hasNext()) {
            HashSet setterOpTypes;
            Object getterOpType;
            org.jdom.Element attr = (org.jdom.Element)it2.next();
            String name = attr.getChildTextTrim("name");
            type = attr.getChildTextTrim("type");
            String getMethod = attr.getAttributeValue("getMethod");
            String setMethod = attr.getAttributeValue("setMethod");
            if (!(getMethod == null || (getterOpType = getters.get(getMethod)) != null && getterOpType.equals(type))) {
                DescriptorSupport getterDescriptor = new DescriptorSupport();
                getterDescriptor.setField("name", getMethod);
                getterDescriptor.setField("descriptorType", "operation");
                getterDescriptor.setField("role", "getter");
                ModelMBeanOperationInfo info = new ModelMBeanOperationInfo(getMethod, "getMethod operation for '" + name + "' attribute.", new MBeanParameterInfo[0], type, 0, getterDescriptor);
                infos.add(info);
            }
            if (setMethod == null || (setterOpTypes = (HashSet)setters.get(setMethod)) != null && setterOpTypes.contains(type)) continue;
            DescriptorSupport setterDescriptor = new DescriptorSupport();
            setterDescriptor.setField("name", setMethod);
            setterDescriptor.setField("descriptorType", "operation");
            setterDescriptor.setField("role", "setter");
            ModelMBeanOperationInfo info = new ModelMBeanOperationInfo(setMethod, "setMethod operation for '" + name + "' attribute.", new MBeanParameterInfo[]{new MBeanParameterInfo("value", type, "The new value")}, Void.TYPE.getName(), 1, setterDescriptor);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanOperationInfo[0]);
    }

    protected ModelMBeanNotificationInfo[] buildNotificationInfo(List notifications) throws NotCompliantMBeanException {
        ArrayList<ModelMBeanNotificationInfo> infos = new ArrayList<ModelMBeanNotificationInfo>();
        Iterator it = notifications.iterator();
        while (it.hasNext()) {
            org.jdom.Element notif = (org.jdom.Element)it.next();
            String name = notif.getChildTextTrim("name");
            String description = notif.getChildTextTrim("description");
            List notifTypes = notif.getChildren("notification-type");
            Descriptor descr = this.getDescriptor(notif, name, "notification");
            ArrayList<String> types = new ArrayList<String>();
            Iterator iterator = notifTypes.iterator();
            while (iterator.hasNext()) {
                org.jdom.Element type = (org.jdom.Element)iterator.next();
                types.add(type.getTextTrim());
            }
            ModelMBeanNotificationInfo info = new ModelMBeanNotificationInfo((String[])types.toArray(), name, description, descr);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanNotificationInfo[0]);
    }

    protected ModelMBeanAttributeInfo[] buildAttributeInfo(List attributes) throws NotCompliantMBeanException {
        ArrayList<ModelMBeanAttributeInfo> infos = new ArrayList<ModelMBeanAttributeInfo>();
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            Object timeLimit;
            String unconvertedDefault;
            org.jdom.Element attr = (org.jdom.Element)it.next();
            String name = attr.getChildTextTrim("name");
            String description = attr.getChildTextTrim("description");
            String type = attr.getChildTextTrim("type");
            String access = attr.getAttributeValue("access");
            String getMethod = attr.getAttributeValue("getMethod");
            String setMethod = attr.getAttributeValue("setMethod");
            Descriptor descr = this.getDescriptor(attr, name, "attribute");
            String unconvertedValue = (String)descr.getFieldValue("value");
            if (unconvertedValue != null && !"java.lang.String".equals(type)) {
                descr.setField("value", this.convertValue(unconvertedValue, type));
            }
            if ((unconvertedDefault = (String)descr.getFieldValue("default")) != null && !"java.lang.String".equals(type)) {
                descr.setField("default", this.convertValue(unconvertedDefault, type));
            }
            if (getMethod != null) {
                descr.setField("getMethod", getMethod);
            }
            if (setMethod != null) {
                descr.setField("setMethod", setMethod);
            }
            if (getMethod == null && setMethod == null && (timeLimit = descr.getFieldValue("currencyTimeLimit")) == null) {
                descr.setField("currencyTimeLimit", "-1");
            }
            boolean isReadable = true;
            boolean isWritable = true;
            if (access.equalsIgnoreCase("read-only")) {
                isWritable = false;
            } else if (access.equalsIgnoreCase("write-only")) {
                isReadable = false;
            }
            ModelMBeanAttributeInfo info = new ModelMBeanAttributeInfo(name, type, description, isReadable, isWritable, false, descr);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanAttributeInfo[0]);
    }

    protected Object convertValue(String unconverted, String typeName) throws NotCompliantMBeanException {
        Object value = null;
        try {
            value = PropertyEditors.convertValue((String)unconverted, (String)typeName);
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Failed to load type class", (Throwable)e);
            throw new NotCompliantMBeanException("Class not found for type: " + typeName);
        }
        catch (IntrospectionException e) {
            throw new NotCompliantMBeanException("No property editor for type=" + typeName);
        }
        return value;
    }

    protected MBeanParameterInfo[] buildParameterInfo(List parameters) {
        Iterator it = parameters.iterator();
        ArrayList<MBeanParameterInfo> infos = new ArrayList<MBeanParameterInfo>();
        while (it.hasNext()) {
            org.jdom.Element param = (org.jdom.Element)it.next();
            String name = param.getChildTextTrim("name");
            String type = param.getChildTextTrim("type");
            String descr = param.getChildTextTrim("description");
            MBeanParameterInfo info = new MBeanParameterInfo(name, type, descr);
            infos.add(info);
        }
        return infos.toArray(new MBeanParameterInfo[0]);
    }

    protected Descriptor[] buildInterceptors(org.jdom.Element descriptor) {
        List interceptors = descriptor.getChildren("interceptor");
        ArrayList<DescriptorSupport> tmp = new ArrayList<DescriptorSupport>();
        int i = 0;
        while (i < interceptors.size()) {
            org.jdom.Element interceptor = (org.jdom.Element)interceptors.get(i);
            String code = interceptor.getAttributeValue("code");
            DescriptorSupport interceptorDescr = new DescriptorSupport();
            interceptorDescr.setField("code", code);
            List attributes = interceptor.getAttributes();
            int a = 0;
            while (a < attributes.size()) {
                Attribute attr = (Attribute)attributes.get(a);
                String value = attr.getValue();
                value = Strings.replaceProperties((String)value);
                interceptorDescr.setField(attr.getName(), value);
                ++a;
            }
            tmp.add(interceptorDescr);
            ++i;
        }
        Descriptor[] descriptors = new Descriptor[tmp.size()];
        tmp.toArray(descriptors);
        return descriptors;
    }

    public static Class getPrimitiveTypeForName(String name) {
        return (Class)PRIMITIVE_NAME_TYPE_MAP.get(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PRIMITIVE_NAME_TYPE_MAP.put("boolean", Boolean.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("byte", Byte.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("char", Character.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("short", Short.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("int", Integer.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("long", Long.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("float", Float.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("double", Double.TYPE);
    }
}

