/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import org.jboss.mx.metadata.AbstractBuilder;

public class StandardMetaData
extends AbstractBuilder {
    private Object mbeanInstance = null;
    private Class mbeanClass = null;
    private Class mbeanInterface = null;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static Class findStandardInterface(Class mbeanClass) {
        Class concrete = mbeanClass;
        Class stdInterface = null;
        while (null != concrete) {
            stdInterface = StandardMetaData.findStandardInterface(concrete, concrete.getInterfaces());
            if (null != stdInterface) {
                return stdInterface;
            }
            concrete = concrete.getSuperclass();
        }
        return null;
    }

    public static Class findStandardInterface(Class concrete, Class[] interfaces) {
        String stdName = concrete.getName() + "MBean";
        Class retval = null;
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].getName().equals(stdName)) {
                retval = interfaces[i];
                break;
            }
            ++i;
        }
        return retval;
    }

    public StandardMetaData(Object mbeanInstance) {
        this(mbeanInstance.getClass());
        this.mbeanInstance = mbeanInstance;
    }

    public StandardMetaData(Class mbeanClass) {
        this.mbeanClass = mbeanClass;
        this.mbeanInterface = StandardMetaData.findStandardInterface(mbeanClass);
    }

    public MBeanInfo build() throws NotCompliantMBeanException {
        try {
            MBeanAttributeInfo info;
            Method setter;
            Constructor<?>[] constructors = this.mbeanClass.getConstructors();
            MBeanConstructorInfo[] constructorInfo = new MBeanConstructorInfo[constructors.length];
            int i = 0;
            while (i < constructors.length) {
                constructorInfo[i] = new MBeanConstructorInfo("MBean Constructor.", constructors[i]);
                ++i;
            }
            Method[] methods = this.mbeanInterface.getMethods();
            HashMap<String, Method> getters = new HashMap<String, Method>();
            HashMap<String, Method> setters = new HashMap<String, Method>();
            HashMap<String, MBeanOperationInfo> operInfo = new HashMap<String, MBeanOperationInfo>();
            ArrayList<MBeanAttributeInfo> attrInfo = new ArrayList<MBeanAttributeInfo>();
            int i2 = 0;
            while (i2 < methods.length) {
                Method getter;
                String key;
                String methodName = methods[i2].getName();
                Class<?>[] signature = methods[i2].getParameterTypes();
                Class<?> returnType = methods[i2].getReturnType();
                if (methodName.startsWith("set") && signature.length == 1 && returnType == Void.TYPE) {
                    key = methodName.substring(3, methodName.length());
                    setter = (Method)setters.get(key);
                    if (setter != null && !setter.getParameterTypes()[0].equals(signature[0])) {
                        throw new IntrospectionException("overloaded type for attribute set: " + key);
                    }
                    setters.put(key, methods[i2]);
                } else if (methodName.startsWith("get") && signature.length == 0 && returnType != Void.TYPE) {
                    key = methodName.substring(3, methodName.length());
                    getter = (Method)getters.get(key);
                    if (getter != null && !getter.getName().startsWith("get")) {
                        throw new IntrospectionException("mixed use of get/is for attribute " + key);
                    }
                    getters.put(key, methods[i2]);
                } else if (methodName.startsWith("is") && signature.length == 0 && (returnType == (class$java$lang$Boolean == null ? StandardMetaData.class$("java.lang.Boolean") : class$java$lang$Boolean) || returnType == Boolean.TYPE)) {
                    key = methodName.substring(2, methodName.length());
                    getter = (Method)getters.get(key);
                    if (getter != null && !getter.getName().startsWith("is")) {
                        throw new IntrospectionException("mixed use of get/is for attribute " + key);
                    }
                    getters.put(key, methods[i2]);
                } else {
                    MBeanOperationInfo info2 = new MBeanOperationInfo("MBean Operation.", methods[i2]);
                    operInfo.put(methods[i2].toString(), info2);
                }
                ++i2;
            }
            Object[] keys = getters.keySet().toArray();
            int i3 = 0;
            while (i3 < keys.length) {
                String attrName = (String)keys[i3];
                Method getter = (Method)getters.remove(attrName);
                setter = (Method)setters.remove(attrName);
                info = new MBeanAttributeInfo(attrName, "MBean Attribute.", getter, setter);
                attrInfo.add(info);
                ++i3;
            }
            Iterator it = setters.keySet().iterator();
            while (it.hasNext()) {
                String attrName = (String)it.next();
                setter = (Method)setters.get(attrName);
                info = new MBeanAttributeInfo(attrName, "MBean Attribute.", null, setter);
                attrInfo.add(info);
            }
            MBeanAttributeInfo[] attributeInfo = attrInfo.toArray(new MBeanAttributeInfo[0]);
            MBeanOperationInfo[] operationInfo = operInfo.values().toArray(new MBeanOperationInfo[0]);
            MBeanNotificationInfo[] notifications = null;
            notifications = this.mbeanInstance instanceof NotificationBroadcaster ? ((NotificationBroadcaster)this.mbeanInstance).getNotificationInfo() : new MBeanNotificationInfo[]{};
            return new MBeanInfo(this.mbeanClass.getName(), "Management Bean.", attributeInfo, constructorInfo, operationInfo, notifications);
        }
        catch (IntrospectionException e) {
            throw new NotCompliantMBeanException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

