/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.jboss.mx.metadata.AbstractBuilder;
import org.jboss.mx.metadata.IllegalPropertyException;
import org.jboss.mx.modelmbean.XMBeanConstants;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class XMBeanMetaData
extends AbstractBuilder
implements XMBeanConstants {
    private static final String GET_METHOD = "getMethod";
    private static final String SET_METHOD = "setMethod";
    private static final String PERSIST_POLICY = "persistPolicy";
    private static final String PERSIST_PERIOD = "persistPeriod";
    private static final String PERSIST_NAME = "persistName";
    private static final String PERSIST_LOCATION = "persistLocation";
    private static final String CURRENCY_TIME_LIMIT = "currencyTimeLimit";
    private static final String ON_UPDATE = "OnUpdate";
    private static final String NO_MORE_OFTEN_THAN = "NoMoreOftenThan";
    private static final String NEVER = "Never";
    private static final String ON_TIMER = "OnTimer";
    private URL url = null;
    private String resourceClassName = null;
    private String mmbClassName = null;

    public XMBeanMetaData(String mmbClassName, String resourceClassName, URL url) {
        this.url = url;
        this.resourceClassName = resourceClassName;
        this.mmbClassName = mmbClassName;
    }

    public XMBeanMetaData(String mmbClassName, String resourceClassName, String url) throws MalformedURLException {
        this(mmbClassName, resourceClassName, new URL(url));
    }

    public XMBeanMetaData(String mmbClassName, String resourceClassName, URL url, Map properties) {
        this(mmbClassName, resourceClassName, url);
        this.setProperties(properties);
    }

    public XMBeanMetaData(String mmbClassName, String resourceClassName, String url, Map properties) throws MalformedURLException {
        this(mmbClassName, resourceClassName, new URL(url), properties);
    }

    public MBeanInfo build() throws NotCompliantMBeanException {
        try {
            SAXBuilder builder = null;
            builder = this.properties.get("xmbean.metadata.sax.parser") != null ? new SAXBuilder(this.getStringProperty("xmbean.metadata.sax.parser")) : new SAXBuilder();
            builder.setValidation(true);
            try {
                boolean validate = this.getBooleanProperty("xmbean.metadata.xml.validate");
                builder.setValidation(validate);
            }
            catch (IllegalPropertyException e) {
                // empty catch block
            }
            Element root = builder.build(this.url).getRootElement();
            List constructors = root.getChildren("constructor");
            List operations = root.getChildren("operation");
            List attributes = root.getChildren("attribute");
            List notifications = root.getChildren("notifications");
            String description = root.getChildText("description");
            Attribute persistPolicy = root.getAttribute(PERSIST_POLICY);
            Attribute persistPeriod = root.getAttribute(PERSIST_PERIOD);
            Attribute persistLocation = root.getAttribute(PERSIST_LOCATION);
            Attribute persistName = root.getAttribute(PERSIST_NAME);
            Attribute currTimeLimit = root.getAttribute(CURRENCY_TIME_LIMIT);
            DescriptorSupport descr = new DescriptorSupport();
            descr.setField("name", this.mmbClassName);
            descr.setField("descriptorType", "mbean");
            if (persistPolicy != null) {
                descr.setField(PERSIST_POLICY, persistPolicy.getValue());
            }
            if (persistPeriod != null) {
                descr.setField(PERSIST_PERIOD, persistPeriod.getValue());
            }
            if (persistLocation != null) {
                descr.setField(PERSIST_LOCATION, persistLocation.getValue());
            }
            if (persistName != null) {
                descr.setField(PERSIST_NAME, persistName.getValue());
            }
            if (currTimeLimit != null) {
                descr.setField(CURRENCY_TIME_LIMIT, currTimeLimit.getValue());
            }
            ModelMBeanInfo info = this.buildMBeanMetaData(description, constructors, operations, attributes, notifications, descr);
            return (MBeanInfo)((Object)info);
        }
        catch (IOException e) {
            throw new NotCompliantMBeanException("IO Error parsing the XML file: " + this.url + ". Cause: " + e.toString());
        }
        catch (JDOMException e) {
            throw new NotCompliantMBeanException("Error parsing the XML file: " + this.url + ". Cause: " + (e.getCause() == null ? e.toString() : e.getCause().toString()));
        }
    }

    protected ModelMBeanInfo buildMBeanMetaData(String description, List constructors, List operations, List attributes, List notifications, Descriptor descr) {
        ModelMBeanOperationInfo[] operInfo = this.buildOperationInfo(operations);
        ModelMBeanAttributeInfo[] attrInfo = this.buildAttributeInfo(attributes);
        ModelMBeanConstructorInfo[] constrInfo = this.buildConstructorInfo(constructors);
        ModelMBeanNotificationInfo[] notifInfo = this.buildNotificationInfo(notifications);
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(this.mmbClassName, description, attrInfo, constrInfo, operInfo, notifInfo, descr);
        return info;
    }

    protected ModelMBeanConstructorInfo[] buildConstructorInfo(List constructors) {
        Iterator it = constructors.iterator();
        ArrayList<ModelMBeanConstructorInfo> infos = new ArrayList<ModelMBeanConstructorInfo>();
        while (it.hasNext()) {
            Element constr = (Element)it.next();
            String name = constr.getChildTextTrim("name");
            String descr = constr.getChildTextTrim("description");
            List params = constr.getChildren("parameter");
            MBeanParameterInfo[] paramInfo = this.buildParameterInfo(params);
            ModelMBeanConstructorInfo info = new ModelMBeanConstructorInfo(name, descr, paramInfo);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanConstructorInfo[0]);
    }

    protected ModelMBeanOperationInfo[] buildOperationInfo(List operations) {
        Iterator it = operations.iterator();
        ArrayList<ModelMBeanOperationInfo> infos = new ArrayList<ModelMBeanOperationInfo>();
        while (it.hasNext()) {
            Element oper = (Element)it.next();
            String name = oper.getChildTextTrim("name");
            String descr = oper.getChildTextTrim("description");
            String type = oper.getChildTextTrim("return-type");
            String impact = oper.getChildTextTrim("impact");
            List params = oper.getChildren("parameter");
            MBeanParameterInfo[] paramInfo = this.buildParameterInfo(params);
            int operImpact = 2;
            if (impact != null) {
                if (impact.equals("INFO")) {
                    operImpact = 0;
                } else if (impact.equals("ACTION")) {
                    operImpact = 1;
                } else if (impact.equals("ACTION_INFO")) {
                    operImpact = 2;
                }
            }
            if (type == null) {
                type = "void";
            }
            ModelMBeanOperationInfo info = new ModelMBeanOperationInfo(name, descr, paramInfo, type, operImpact);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanOperationInfo[0]);
    }

    protected ModelMBeanNotificationInfo[] buildNotificationInfo(List notifications) {
        Iterator it = notifications.iterator();
        ArrayList<ModelMBeanNotificationInfo> infos = new ArrayList<ModelMBeanNotificationInfo>();
        while (it.hasNext()) {
            Element notif = (Element)it.next();
            String name = notif.getChildTextTrim("name");
            String descr = notif.getChildTextTrim("description");
            List notifTypes = notif.getChildren("notification-type");
            Iterator iterator = notifTypes.iterator();
            ArrayList<String> types = new ArrayList<String>();
            while (iterator.hasNext()) {
                Element type = (Element)iterator.next();
                types.add(type.getTextTrim());
            }
            ModelMBeanNotificationInfo info = new ModelMBeanNotificationInfo((String[])types.toArray(), name, descr);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanNotificationInfo[0]);
    }

    protected ModelMBeanAttributeInfo[] buildAttributeInfo(List attributes) {
        Iterator it = attributes.iterator();
        ArrayList<ModelMBeanAttributeInfo> infos = new ArrayList<ModelMBeanAttributeInfo>();
        while (it.hasNext()) {
            Element attr = (Element)it.next();
            String name = attr.getChildTextTrim("name");
            String description = attr.getChildTextTrim("description");
            String type = attr.getChildTextTrim("type");
            String access = attr.getChildTextTrim("access");
            Attribute persistPolicy = attr.getAttribute(PERSIST_POLICY);
            Attribute persistPeriod = attr.getAttribute(PERSIST_PERIOD);
            Attribute setMethod = attr.getAttribute(SET_METHOD);
            Attribute getMethod = attr.getAttribute(GET_METHOD);
            Attribute currTimeLimit = attr.getAttribute(CURRENCY_TIME_LIMIT);
            DescriptorSupport descr = new DescriptorSupport();
            descr.setField("name", name);
            descr.setField("descriptorType", "attribute");
            if (persistPolicy != null) {
                descr.setField(PERSIST_POLICY, persistPolicy.getValue());
            }
            if (persistPeriod != null) {
                descr.setField(PERSIST_PERIOD, persistPeriod.getValue());
            }
            if (setMethod != null) {
                descr.setField(SET_METHOD, setMethod.getValue());
            }
            if (getMethod != null) {
                descr.setField(GET_METHOD, getMethod.getValue());
            }
            if (currTimeLimit != null) {
                descr.setField(CURRENCY_TIME_LIMIT, currTimeLimit.getValue());
            }
            if (setMethod == null && getMethod == null && currTimeLimit == null) {
                descr.setField(CURRENCY_TIME_LIMIT, "-1");
            }
            boolean isReadable = true;
            boolean isWritable = true;
            if (access.equalsIgnoreCase("read-only")) {
                isWritable = false;
            } else if (access.equalsIgnoreCase("write-only")) {
                isReadable = false;
            }
            ModelMBeanAttributeInfo info = new ModelMBeanAttributeInfo(name, type, description, isReadable, isWritable, false, descr);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanAttributeInfo[0]);
    }

    protected MBeanParameterInfo[] buildParameterInfo(List parameters) {
        Iterator it = parameters.iterator();
        ArrayList<MBeanParameterInfo> infos = new ArrayList<MBeanParameterInfo>();
        while (it.hasNext()) {
            Element param = (Element)it.next();
            String name = param.getChildTextTrim("name");
            String type = param.getChildTextTrim("type");
            String descr = param.getChildTextTrim("description");
            MBeanParameterInfo info = new MBeanParameterInfo(name, type, descr);
            infos.add(info);
        }
        return infos.toArray(new MBeanParameterInfo[0]);
    }
}

