/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import org.jboss.mx.metadata.AbstractBuilder;
import org.jboss.mx.metadata.JBossXMBean10;
import org.jboss.mx.metadata.JBossXMBean12;
import org.jboss.mx.metadata.XMBeanEntityResolver;
import org.jboss.mx.metadata.XMBeanMetaData;
import org.jboss.mx.modelmbean.XMBeanConstants;
import org.jboss.mx.service.ServiceConstants;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class XMLMetaData
extends AbstractBuilder
implements ServiceConstants,
XMBeanConstants {
    private static final int NO_VERSION = -1;
    private static final int XMBEAN = 0;
    private static final int JBOSS_XMBEAN_1_0 = 1;
    private static final int JBOSS_XMBEAN_1_2 = 2;
    private URL url = null;
    private Element element;
    private String versionString;
    private String resourceClassName = null;
    private String mmbClassName = null;

    public XMLMetaData(String mmbClassName, String resourceClassName, URL url) {
        this.url = url;
        this.mmbClassName = mmbClassName;
        this.resourceClassName = resourceClassName;
    }

    public XMLMetaData(String mmbClassName, String resourceClassName, String url) throws MalformedURLException {
        this(mmbClassName, resourceClassName, new URL(url));
    }

    public XMLMetaData(String mmbClassName, String resourceClassName, URL url, Map properties) {
        this(mmbClassName, resourceClassName, url);
        this.setProperties(properties);
    }

    public XMLMetaData(String mmbClassName, String resourceClassName, String url, Map properties) throws MalformedURLException {
        this(mmbClassName, resourceClassName, new URL(url), properties);
    }

    public XMLMetaData(String mmbClassName, String resourceClassName, Element element, String version) {
        this.mmbClassName = mmbClassName;
        this.resourceClassName = resourceClassName;
        this.element = element;
        this.versionString = version;
    }

    public MBeanInfo build() throws NotCompliantMBeanException {
        try {
            int version = -1;
            if (this.versionString == null) {
                SAXBuilder builder = new SAXBuilder();
                builder = this.properties.get("xmbean.metadata.sax.parser") == null ? new SAXBuilder(false) : new SAXBuilder(this.getStringProperty("xmbean.metadata.sax.parser"), false);
                builder.setEntityResolver((EntityResolver)new XMBeanEntityResolver());
                InputStream docStream = this.url.openStream();
                Document doc = builder.build(docStream);
                docStream.close();
                DocType type = doc.getDocType();
                version = this.validateVersionString(type.getPublicID());
                if (version == -1) {
                    version = this.validateVersionString(type.getSystemID());
                }
            } else {
                version = this.validateVersionString(this.versionString);
            }
            if (version == 1) {
                if (this.element == null) {
                    return new JBossXMBean10(this.mmbClassName, this.resourceClassName, this.url, this.properties).build();
                }
                return new JBossXMBean10(this.mmbClassName, this.resourceClassName, this.element).build();
            }
            if (version == 0) {
                return new XMBeanMetaData(this.mmbClassName, this.resourceClassName, this.url, this.properties).build();
            }
            if (version == 2) {
                return new JBossXMBean12(this.mmbClassName, this.resourceClassName, this.url, this.properties).build();
            }
            throw new NotCompliantMBeanException("Unknown xmbean type " + this.versionString);
        }
        catch (JDOMException e) {
            System.out.println("JDOM Exception: " + (Object)((Object)e));
            e.printStackTrace();
            throw new NotCompliantMBeanException("Error parsing the XML file, from XMLMetaData: " + (e.getCause() == null ? e.toString() : e.getCause().toString()));
        }
        catch (IOException e) {
            throw new NotCompliantMBeanException("Error parsing the XML file: " + e.toString());
        }
    }

    private int validateVersionString(String versionString) {
        if ("-//JBoss//DTD JBOSS XMBEAN 1.0//EN".equals(versionString)) {
            return 1;
        }
        if (versionString != null && versionString.endsWith("jboss_xmbean_1_0.dtd")) {
            return 1;
        }
        if (versionString != null && versionString.endsWith("xmbean.dtd")) {
            return 0;
        }
        return -1;
    }
}

