/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.modelmbean;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import org.jboss.logging.Logger;
import org.jboss.mx.interceptor.Interceptor;
import org.jboss.mx.interceptor.MBeanAttributeInterceptor;
import org.jboss.mx.interceptor.ObjectReferenceInterceptor;
import org.jboss.mx.interceptor.PersistenceInterceptor2;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jboss.mx.persistence.NullPersistence;
import org.jboss.mx.persistence.PersistenceManager;
import org.jboss.mx.server.MBeanInvoker;

public abstract class ModelMBeanInvoker
extends MBeanInvoker
implements ModelMBean,
ModelMBeanConstants,
MBeanRegistration {
    Logger log = Logger.getLogger((String)(class$org$jboss$mx$modelmbean$ModelMBeanInvoker == null ? (class$org$jboss$mx$modelmbean$ModelMBeanInvoker = ModelMBeanInvoker.class$("org.jboss.mx.modelmbean.ModelMBeanInvoker")) : class$org$jboss$mx$modelmbean$ModelMBeanInvoker).getName());
    protected String resourceType = null;
    protected PersistenceManager persistence = new NullPersistence();
    protected NotificationBroadcasterSupport notifier = new NotificationBroadcasterSupport();
    protected long notifierSequence = 1L;
    protected long attrNotifierSequence = 1L;
    static /* synthetic */ Class class$org$jboss$mx$modelmbean$ModelMBeanInvoker;
    static /* synthetic */ Class class$javax$management$MBeanInfo;
    static /* synthetic */ Class class$org$jboss$mx$server$MBeanInvoker;

    public ModelMBeanInvoker() {
    }

    public ModelMBeanInvoker(ModelMBeanInfo info) throws MBeanException {
        this.setModelMBeanInfo(info);
        try {
            this.load();
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
    }

    public abstract boolean isSupportedResourceType(Object var1, String var2);

    public void setModelMBeanInfo(ModelMBeanInfo info) throws MBeanException, RuntimeOperationsException {
        if (info == null) {
            throw new IllegalArgumentException("MBeanInfo cannot be null.");
        }
        this.info = new ModelMBeanInfoSupport(info);
        this.setDescriptors(info.getDescriptors(ModelMBeanConstants.ALL_DESCRIPTORS));
    }

    public void setManagedResource(Object ref, String resourceType) throws MBeanException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        if (ref == null) {
            throw new IllegalArgumentException("Resource reference cannot be null.");
        }
        if (!this.isSupportedResourceType(ref, resourceType)) {
            throw new InvalidTargetObjectTypeException("Unsupported resource type: " + resourceType);
        }
        this.resource = ref;
        this.resourceType = resourceType;
        if (this.resource instanceof NotificationBroadcasterSupport) {
            this.notifier = (NotificationBroadcasterSupport)this.resource;
        }
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.notifier.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(listener);
    }

    public void addAttributeChangeNotificationListener(NotificationListener listener, String attributeName, Object handback) throws MBeanException {
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        filter.enableAttribute(attributeName);
        this.notifier.addNotificationListener(listener, filter, handback);
    }

    public void removeAttributeChangeNotificationListener(NotificationListener listener, String attributeName) throws MBeanException, ListenerNotFoundException {
        this.notifier.removeNotificationListener(listener);
    }

    public void sendNotification(String message) throws MBeanException {
        Notification notif = new Notification("jmx.modelmbean.generic", (Object)this, ++this.notifierSequence, message);
        this.sendNotification(notif);
    }

    public void sendNotification(Notification notification) throws MBeanException {
        this.notifier.sendNotification(notification);
    }

    public void sendAttributeChangeNotification(AttributeChangeNotification notification) throws MBeanException {
        this.notifier.sendNotification(notification);
    }

    public void sendAttributeChangeNotification(Attribute oldValue, Attribute newValue) throws MBeanException {
        String attr = oldValue.getName();
        String type = this.getModelMBeanInfo().getAttribute(attr).getType();
        AttributeChangeNotification notif = new AttributeChangeNotification(this, ++this.attrNotifierSequence, System.currentTimeMillis(), "" + attr + " changed from " + oldValue + " to " + newValue, attr, type, oldValue.getValue(), newValue.getValue());
        this.notifier.sendNotification(notif);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        throw new Error("NYI");
    }

    public void load() throws MBeanException, InstanceNotFoundException {
        if (this.getModelMBeanInfo() == null) {
            return;
        }
        this.persistence.load(this, (MBeanInfo)((Object)this.getModelMBeanInfo()));
    }

    public void store() throws MBeanException, InstanceNotFoundException {
        this.persistence.store((MBeanInfo)((Object)this.getModelMBeanInfo()));
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        Interceptor[] interceptors;
        ModelMBeanInfoSupport infoSupport = (ModelMBeanInfoSupport)this.getModelMBeanInfo();
        Descriptor mbeanDescriptor = infoSupport.getDescriptor(null, "MBean");
        Descriptor[] interceptorDescriptors = (Descriptor[])mbeanDescriptor.getFieldValue("interceptors");
        int index = 0;
        if (interceptorDescriptors == null) {
            interceptors = new Interceptor[3];
            interceptors[index++] = new PersistenceInterceptor2(infoSupport, this);
            interceptors[index++] = new MBeanAttributeInterceptor(infoSupport, this);
            interceptors[index++] = new ObjectReferenceInterceptor(infoSupport, this);
        } else {
            Interceptor[] tmp = new Interceptor[interceptorDescriptors.length];
            this.createInterceptors(interceptorDescriptors, tmp);
            index = interceptorDescriptors.length;
            interceptors = tmp;
        }
        Interceptor lastInterceptor = this.stack = interceptors[0];
        int i = 1;
        while (i < interceptors.length) {
            Interceptor next = interceptors[i];
            lastInterceptor = lastInterceptor.setNext(next);
            ++i;
        }
        this.setValuesFromMBeanInfo(infoSupport);
        this.initPersistence(server);
        if (this.resource instanceof MBeanRegistration) {
            return ((MBeanRegistration)this.resource).preRegister(server, name);
        }
        return name;
    }

    public void postRegister(Boolean registrationSuccessful) {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).postRegister(registrationSuccessful);
        }
    }

    public void preDeregister() throws Exception {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).preDeregister();
        }
    }

    public void postDeregister() {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).postDeregister();
        }
    }

    public ModelMBeanInfo getModelMBeanInfo() {
        return (ModelMBeanInfo)((Object)this.info);
    }

    protected void setValuesFromMBeanInfo(ModelMBeanInfo metadata) throws JMException {
        MBeanAttributeInfo[] attrs = metadata.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            ModelMBeanAttributeInfo attributeInfo = (ModelMBeanAttributeInfo)attrs[i];
            if (attributeInfo.isWritable()) {
                Descriptor attrDesc = attributeInfo.getDescriptor();
                Object name = attrDesc.getFieldValue("name");
                Object value = attrDesc.getFieldValue("value");
                if (value != null) {
                    this.log.debug((Object)("loading attribute  name: " + name + ", value: " + value));
                    Attribute curAttribute = new Attribute(name.toString(), value);
                    super.setAttribute(curAttribute);
                }
            }
            ++i;
        }
    }

    protected void initPersistence(MBeanServer server) throws MBeanException, InstanceNotFoundException {
        Descriptor[] descriptors;
        try {
            descriptors = this.getModelMBeanInfo().getDescriptors("MBean");
        }
        catch (MBeanException e) {
            this.log.error((Object)"Failed to obtain MBEAN_DESCRIPTORs", (Throwable)e);
            return;
        }
        if (descriptors == null) {
            return;
        }
        String persistMgrName = null;
        int i = 0;
        while (i < descriptors.length && persistMgrName == null) {
            persistMgrName = (String)descriptors[i].getFieldValue("persistence-manager");
            ++i;
        }
        if (persistMgrName == null) {
            this.log.debug((Object)"No persistence-manager descriptor found, null persistence will be used");
            return;
        }
        try {
            this.persistence = (PersistenceManager)server.instantiate(persistMgrName);
            this.log.debug((Object)("Loaded persistence mgr: " + persistMgrName));
        }
        catch (Exception cause) {
            this.log.error((Object)("Unable to instantiate the persistence manager:" + persistMgrName), (Throwable)cause);
        }
        this.load();
    }

    protected void createInterceptors(Descriptor[] interceptorDescriptors, Interceptor[] interceptors) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        int d = 0;
        while (d < interceptorDescriptors.length) {
            Descriptor info = interceptorDescriptors[d];
            String code = (String)info.getFieldValue("code");
            Class<?> interceptorClass = loader.loadClass(code);
            Interceptor interceptor = null;
            Class[] ctorSig = new Class[]{class$javax$management$MBeanInfo == null ? ModelMBeanInvoker.class$("javax.management.MBeanInfo") : class$javax$management$MBeanInfo, class$org$jboss$mx$server$MBeanInvoker == null ? ModelMBeanInvoker.class$("org.jboss.mx.server.MBeanInvoker") : class$org$jboss$mx$server$MBeanInvoker};
            try {
                Constructor<?> ctor = interceptorClass.getConstructor(ctorSig);
                Object[] ctorArgs = new Object[]{this.getModelMBeanInfo(), this};
                interceptor = (Interceptor)ctor.newInstance(ctorArgs);
            }
            catch (Throwable t) {
                this.log.debug((Object)("Failed to invoke ctor(MBeanInfo, MBeanInvoker) for: " + interceptorClass), t);
                interceptor = (Interceptor)interceptorClass.newInstance();
            }
            interceptors[d] = interceptor;
            String[] names = info.getFieldNames();
            HashMap<String, PropertyDescriptor> propertyMap = new HashMap<String, PropertyDescriptor>();
            if (names.length > 1) {
                BeanInfo beanInfo = Introspector.getBeanInfo(interceptorClass);
                PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
                int p = 0;
                while (p < props.length) {
                    propertyMap.put(Introspector.decapitalize(props[p].getName()), props[p]);
                    ++p;
                }
                int n = 0;
                while (n < names.length) {
                    String name = names[n];
                    if (!name.equals("code")) {
                        String text = (String)info.getFieldValue(name);
                        PropertyDescriptor pd = (PropertyDescriptor)propertyMap.get(name);
                        Method setter = pd.getWriteMethod();
                        if (setter != null) {
                            Class<?> ptype = pd.getPropertyType();
                            PropertyEditor editor = PropertyEditorManager.findEditor(ptype);
                            if (editor == null) {
                                throw new IntrospectionException("Cannot convert string to interceptor attribute:" + name);
                            }
                            editor.setAsText(text);
                            Object[] args = new Object[]{editor.getValue()};
                            setter.invoke((Object)interceptor, args);
                        }
                    }
                    ++n;
                }
            }
            ++d;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

