/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.modelmbean;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.NotCompliantMBeanException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import org.jboss.mx.metadata.MBeanInfoConversion;
import org.jboss.mx.metadata.StandardMetaData;
import org.jboss.mx.metadata.XMLMetaData;
import org.jboss.mx.modelmbean.ModelMBeanInvoker;
import org.jboss.mx.modelmbean.XMBeanConstants;
import org.w3c.dom.Element;

public class XMBean
extends ModelMBeanInvoker
implements MBeanRegistration,
XMBeanConstants {
    public XMBean() {
    }

    public XMBean(ModelMBeanInfo info) throws MBeanException {
        super(info);
    }

    public XMBean(Object resource, String resourceType) throws MBeanException, NotCompliantMBeanException {
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (resourceType.equals("descriptor")) {
                Descriptor d = (Descriptor)resource;
                resourceType = (String)d.getFieldValue("xmbean.resource.type");
                resource = d.getFieldValue("xmbean.resource.reference");
                String[] fields = d.getFieldNames();
                int i = 0;
                while (i < fields.length) {
                    if (fields[i].startsWith("xmbean.metadata.")) {
                        properties.put(fields[i], d.getFieldValue(fields[i]));
                    }
                    ++i;
                }
            }
            this.setManagedResource(resource, resourceType);
            if (resourceType.equals("StandardInterface")) {
                boolean CREATE_ATTRIBUTE_OPERATION_MAPPING = true;
                StandardMetaData builder = new StandardMetaData(resource);
                Iterator it = properties.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    builder.setProperty(key, properties.get(key));
                }
                MBeanInfo standardInfo = builder.build();
                ModelMBeanInfoSupport minfo = MBeanInfoConversion.toModelMBeanInfo(standardInfo, true);
                this.setModelMBeanInfo(minfo);
            } else if (resourceType.endsWith(".xml")) {
                XMLMetaData builder = new XMLMetaData(this.getClass().getName(), resource.getClass().getName(), resourceType);
                Iterator it = properties.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    builder.setProperty(key, properties.get(key));
                }
                ModelMBeanInfo minfo = (ModelMBeanInfo)((Object)builder.build());
                this.setModelMBeanInfo(minfo);
            }
            this.load();
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            if (resourceType.endsWith(".xml")) {
                throw new MBeanException(e, "Malformed URL: " + resourceType);
            }
            throw new MBeanException(e, "Unsupported resource type: " + resourceType);
        }
        catch (MalformedURLException e) {
            throw new MBeanException(e, "Malformed URL: " + resourceType);
        }
    }

    public XMBean(Object resource, URL interfaceURL) throws MBeanException, NotCompliantMBeanException {
        this(resource, interfaceURL.toString());
    }

    public XMBean(Descriptor descriptor) throws MBeanException, NotCompliantMBeanException {
        this((Object)descriptor, "descriptor");
    }

    public XMBean(Object resource, Element element, String version) throws MBeanException, NotCompliantMBeanException {
        try {
            this.setManagedResource(resource, "ObjectReference");
            XMLMetaData builder = new XMLMetaData(this.getClass().getName(), resource.getClass().getName(), element, version);
            this.info = builder.build();
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new MBeanException(e, "Unsupported resource type: " + this.resourceType);
        }
    }

    public boolean isSupportedResourceType(Object resource, String resourceType) {
        if (resourceType == null) {
            return false;
        }
        if (resourceType.equals("ObjectReference")) {
            return true;
        }
        if (resourceType.equals("StandardInterface")) {
            return true;
        }
        if (resourceType.equals("descriptor")) {
            if (!(resource instanceof Descriptor)) {
                return false;
            }
            Descriptor d = (Descriptor)resource;
            if (d.getFieldValue("xmbean.resource.reference") == null) {
                return false;
            }
            return d.getFieldValue("xmbean.resource.type") != null;
        }
        if (resourceType.endsWith(".xml")) {
            try {
                new URL(resourceType);
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return false;
    }

    public MBeanInfo getMBeanInfo() {
        return this.info;
    }
}

