/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.mx.server.ServerConstants;

public class AgentID
implements ServerConstants {
    private static int idSequence = 1;

    public static String create() {
        String ipAddress = null;
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            ipAddress = "127.0.0.1";
        }
        return ipAddress + "/" + System.currentTimeMillis() + "/" + idSequence++;
    }

    public static String get(MBeanServer server) {
        try {
            ObjectName name = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            String agentID = (String)server.getAttribute(name, "MBeanServerId");
            return agentID;
        }
        catch (Throwable t) {
            throw new Error("Cannot find the MBean server delegate: " + t.toString());
        }
    }
}

