/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import org.jboss.mx.util.DefaultExceptionHandler;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.mx.util.ProxyContext;
import org.jboss.mx.util.ProxyExceptionHandler;

public class JMXInvocationHandler
implements ProxyContext,
InvocationHandler,
Serializable {
    protected MBeanServer server = null;
    protected ObjectName objectName = null;
    private ProxyExceptionHandler handler = new DefaultExceptionHandler();
    private HashMap attributeMap = new HashMap();
    static /* synthetic */ Class class$org$jboss$mx$util$ProxyContext;
    static /* synthetic */ Class class$javax$management$DynamicMBean;
    static /* synthetic */ Class class$java$lang$Boolean;

    public JMXInvocationHandler(MBeanServer server, ObjectName name) throws MBeanProxyCreationException {
        try {
            if (server == null) {
                throw new MBeanProxyCreationException("null agent reference");
            }
            this.server = server;
            this.objectName = name;
            MBeanInfo info = server.getMBeanInfo(this.objectName);
            MBeanAttributeInfo[] attributes = info.getAttributes();
            int i = 0;
            while (i < attributes.length) {
                this.attributeMap.put(attributes[i].getName(), attributes[i]);
                ++i;
            }
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanProxyCreationException("Object name " + name + " not found: " + e.toString());
        }
        catch (IntrospectionException e) {
            throw new MBeanProxyCreationException(e.toString());
        }
        catch (ReflectionException e) {
            throw new MBeanProxyCreationException(e.toString());
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        String methodName;
        Class<?> declaringClass = method.getDeclaringClass();
        if (method.getDeclaringClass() == (class$org$jboss$mx$util$ProxyContext == null ? (class$org$jboss$mx$util$ProxyContext = JMXInvocationHandler.class$("org.jboss.mx.util.ProxyContext")) : class$org$jboss$mx$util$ProxyContext)) {
            return method.invoke((Object)this, args);
        }
        if (method.getDeclaringClass() == (class$javax$management$DynamicMBean == null ? (class$javax$management$DynamicMBean = JMXInvocationHandler.class$("javax.management.DynamicMBean")) : class$javax$management$DynamicMBean)) {
            methodName = method.getName();
            if (methodName.equals("setAttribute")) {
                this.server.setAttribute(this.objectName, (Attribute)args[0]);
                return null;
            }
            if (methodName.equals("setAttributes")) {
                return this.server.setAttributes(this.objectName, (AttributeList)args[0]);
            }
            if (methodName.equals("getAttribute")) {
                return this.server.getAttribute(this.objectName, (String)args[0]);
            }
            if (methodName.equals("getAttributes")) {
                return this.server.getAttributes(this.objectName, (String[])args[0]);
            }
            if (methodName.equals("invoke")) {
                return this.server.invoke(this.objectName, (String)args[0], (Object[])args[1], (String[])args[2]);
            }
            if (methodName.equals("getMBeanInfo")) {
                return this.server.getMBeanInfo(this.objectName);
            }
        }
        try {
            Object retType;
            MBeanAttributeInfo info;
            String attrName;
            methodName = method.getName();
            if (methodName.startsWith("get") && args == null) {
                attrName = methodName.substring(3, methodName.length());
                info = (MBeanAttributeInfo)this.attributeMap.get(attrName);
                if (info != null && ((String)(retType = method.getReturnType().getName())).equals(info.getType())) {
                    return this.server.getAttribute(this.objectName, attrName);
                }
            } else if (methodName.startsWith("is") && args == null) {
                attrName = methodName.substring(2, methodName.length());
                info = (MBeanAttributeInfo)this.attributeMap.get(attrName);
                if (info != null && info.isIs() && ((retType = method.getReturnType()).equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JMXInvocationHandler.class$("java.lang.Boolean")) : class$java$lang$Boolean) || retType.equals(Boolean.TYPE))) {
                    return this.server.getAttribute(this.objectName, attrName);
                }
            } else if (methodName.startsWith("set") && args != null && args.length == 1 && (info = (MBeanAttributeInfo)this.attributeMap.get(attrName = methodName.substring(3, methodName.length()))) != null && method.getReturnType().equals(Void.TYPE) && info.getType().equals(args[0].getClass().getName())) {
                this.server.setAttribute(this.objectName, new Attribute(attrName, args[0]));
                return null;
            }
            String[] signature = null;
            if (args != null) {
                signature = new String[args.length];
                Class<?>[] sign = method.getParameterTypes();
                int i = 0;
                while (i < sign.length) {
                    signature[i] = sign[i].getName();
                    ++i;
                }
            }
            return this.server.invoke(this.objectName, methodName, args, signature);
        }
        catch (InstanceNotFoundException e) {
            return this.getExceptionHandler().handleInstanceNotFound(this, e, method, args);
        }
        catch (AttributeNotFoundException e) {
            return this.getExceptionHandler().handleAttributeNotFound(this, e, method, args);
        }
        catch (InvalidAttributeValueException e) {
            return this.getExceptionHandler().handleInvalidAttributeValue(this, e, method, args);
        }
        catch (MBeanException e) {
            return this.getExceptionHandler().handleMBeanException(this, e, method, args);
        }
        catch (ReflectionException e) {
            return this.getExceptionHandler().handleReflectionException(this, e, method, args);
        }
        catch (RuntimeOperationsException e) {
            return this.getExceptionHandler().handleRuntimeOperationsException(this, e, method, args);
        }
        catch (RuntimeMBeanException e) {
            return this.getExceptionHandler().handleRuntimeMBeanException(this, e, method, args);
        }
        catch (RuntimeErrorException e) {
            return this.getExceptionHandler().handleRuntimeError(this, e, method, args);
        }
    }

    public ProxyExceptionHandler getExceptionHandler() {
        return this.handler;
    }

    public void setExceptionHandler(ProxyExceptionHandler handler) {
        this.handler = handler;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

